/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.imageio;

import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class IIOMetadataDumper {
    private Node root;
    private volatile String formatName = "";
    private String metadata;

    public IIOMetadataDumper(IIOMetadata metadata, String name) {
        this.root = metadata.getAsTree(name);
        StringBuffer buff = new StringBuffer();
        this.parseMetadata(buff, this.root, 0);
        this.formatName = name;
        this.metadata = buff.toString();
    }

    public IIOMetadataDumper(IIOMetadataNode rootNode) {
        this.root = rootNode;
        StringBuffer buff = new StringBuffer();
        this.parseMetadata(buff, this.root, 0);
        this.metadata = buff.toString();
    }

    private void indent(StringBuffer buff, int level) {
        for (int i = 0; i < level; ++i) {
            buff.append("  ");
        }
    }

    private void parseMetadata(StringBuffer buff, Node node, int level) {
        Node child;
        this.indent(buff, level);
        buff.append("<").append(node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                buff.append(" ").append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            buff.append(">\n");
            while (child != null) {
                this.parseMetadata(buff, child, level + 1);
                child = child.getNextSibling();
            }
            this.indent(buff, level);
            buff.append("</").append(node.getNodeName()).append(">\n");
        } else {
            buff.append("/>\n");
        }
    }

    public synchronized String getMetadata() {
        return this.metadata;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public synchronized void setFormatName(String formatName) {
        if (this.formatName.equalsIgnoreCase(formatName)) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        this.parseMetadata(buff, this.root, 0);
        this.formatName = formatName;
        this.metadata = buff.toString();
    }
}

