/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.PlanarImage;
import org.geotools.image.io.ScaledColorSpace;
import org.geotools.resources.image.ComponentColorModelJAI;

public class RawBinaryImageReadParam
extends ImageReadParam {
    private SampleModel model;
    private Dimension size;
    private int dataType = 32;
    private int targetDataType = 32;
    private double padValue = Double.NaN;

    public void setStreamImageSize(Dimension size) {
        this.size = size != null ? new Dimension(size.width, size.height) : null;
    }

    public Dimension getStreamImageSize() {
        return this.size != null ? (Dimension)this.size.clone() : null;
    }

    private static void checkDataType(int dataType) throws IllegalArgumentException {
        if ((dataType < 0 || dataType > 5) && dataType != 32) {
            throw new IllegalArgumentException(String.valueOf(dataType));
        }
    }

    public void setStreamDataType(int dataType) {
        RawBinaryImageReadParam.checkDataType(dataType);
        this.dataType = dataType;
    }

    public int getStreamDataType() {
        return this.dataType;
    }

    public void setDestinationType(int destType) {
        RawBinaryImageReadParam.checkDataType(destType);
        this.targetDataType = destType;
        this.setDestinationType(this.getDestinationType(this.model != null ? this.model.getNumBands() : 1));
    }

    final ImageTypeSpecifier getDestinationType(int numBands) {
        SampleModel sampleModel;
        if (this.targetDataType == 32) {
            return null;
        }
        ColorSpace colorSpace = this.getColorSpace(numBands);
        if (this.model != null) {
            if (numBands != this.model.getNumBands()) {
                throw new IllegalArgumentException("Number of bands mismatch");
            }
            sampleModel = RawBinaryImageReadParam.getStreamSampleModel(this.model, this.model, this.size, this.targetDataType);
        } else {
            int height;
            int width;
            if (this.size != null) {
                width = this.size.width;
                height = this.size.height;
            } else {
                height = 1;
                width = 1;
            }
            int[] bankIndices = new int[numBands];
            int[] bandOffsets = new int[numBands];
            int i = numBands;
            while (--i >= 0) {
                bankIndices[i] = i;
            }
            sampleModel = new ComponentSampleModelJAI(this.targetDataType, width, height, 1, width, bankIndices, bandOffsets);
        }
        ColorModel colorModel = sampleModel instanceof ComponentSampleModel ? new ComponentColorModelJAI(this.getColorSpace(numBands), false, false, 1, sampleModel.getDataType()) : PlanarImage.createColorModel((SampleModel)sampleModel);
        return new ImageTypeSpecifier(colorModel, sampleModel);
    }

    private ColorSpace getColorSpace(int numBands) {
        if (this.destination != null) {
            return this.destination.getColorModel().getColorSpace();
        }
        if (this.sourceBands != null) {
            numBands = this.sourceBands.length;
        } else if (this.model != null) {
            numBands = this.model.getNumBands();
        }
        if (this.destinationBands != null) {
            for (int i = 0; i < this.destinationBands.length; ++i) {
                if (this.destinationBands[i] < numBands) continue;
                numBands = this.destinationBands[i] + 1;
            }
        }
        if (numBands == 1) {
            return ColorSpace.getInstance(1003);
        }
        return new ScaledColorSpace(numBands, 0.0f, 1.0f);
    }

    public void setPadValue(double padValue) {
        this.padValue = padValue;
    }

    public double getPadValue() {
        return this.padValue;
    }

    public void setStreamSampleModel(SampleModel model) {
        this.model = model;
        if (model != null) {
            this.size = new Dimension(model.getWidth(), model.getHeight());
            this.dataType = model.getDataType();
        }
    }

    public SampleModel getStreamSampleModel() {
        this.model = this.getStreamSampleModel(null);
        return this.model;
    }

    final SampleModel getStreamSampleModel(SampleModel defaultSampleModel) {
        return RawBinaryImageReadParam.getStreamSampleModel(defaultSampleModel, this.model, this.size, this.dataType);
    }

    private static SampleModel getStreamSampleModel(SampleModel defaultSampleModel, SampleModel model, Dimension size, int dataType) {
        if (defaultSampleModel != null) {
            if (model == null) {
                model = defaultSampleModel;
            }
            if (size == null) {
                size = new Dimension(defaultSampleModel.getWidth(), defaultSampleModel.getHeight());
            }
            if (dataType == 32) {
                dataType = defaultSampleModel.getDataType();
            }
        }
        if (model == null || size == null || dataType == 32) {
            return null;
        }
        int width = size.width;
        int height = size.height;
        if (dataType != ((SampleModel)model).getDataType()) {
            if (model instanceof ComponentSampleModel) {
                ComponentSampleModel cast = (ComponentSampleModel)model;
                int pixelStride = cast.getPixelStride();
                int scanlineStride = cast.getScanlineStride();
                int[] bankIndices = cast.getBankIndices();
                int[] bandOffsets = cast.getBandOffsets();
                model = model instanceof BandedSampleModel ? new BandedSampleModel(dataType, width, height, scanlineStride, bankIndices, bandOffsets) : (model instanceof PixelInterleavedSampleModel ? new PixelInterleavedSampleModel(dataType, width, height, pixelStride, scanlineStride, bandOffsets) : (model instanceof ComponentSampleModelJAI ? new ComponentSampleModelJAI(dataType, width, height, pixelStride, scanlineStride, bankIndices, bandOffsets) : new ComponentSampleModel(dataType, width, height, pixelStride, scanlineStride, bankIndices, bandOffsets)));
            } else if (model instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel cast = (MultiPixelPackedSampleModel)model;
                int numberOfBits = DataBuffer.getDataTypeSize(dataType);
                int scanlineStride = cast.getScanlineStride();
                int dataBitOffset = cast.getDataBitOffset();
                model = new MultiPixelPackedSampleModel(dataType, width, height, numberOfBits, scanlineStride, dataBitOffset);
            } else if (model instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel cast = (SinglePixelPackedSampleModel)model;
                int scanlineStride = cast.getScanlineStride();
                int[] bitMasks = cast.getBitMasks();
                model = new SinglePixelPackedSampleModel(dataType, width, height, scanlineStride, bitMasks);
            } else {
                throw new IllegalStateException(model.getClass().getName());
            }
        }
        if (((SampleModel)model).getWidth() != width || ((SampleModel)model).getHeight() != height) {
            model = ((SampleModel)model).createCompatibleSampleModel(width, height);
        }
        return model;
    }
}

