/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.util.Range;
import org.geotools.image.io.RawBinaryImageReadParam;
import org.geotools.image.io.SimpleImageReader;
import org.geotools.resources.i18n.Descriptions;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ComponentColorModelJAI;

public class RawBinaryImageReader
extends SimpleImageReader {
    private Range[] ranges;
    private final double padValue;
    protected Dimension imageSize;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public RawBinaryImageReader(ImageReaderSpi provider) {
        super(provider);
        if (provider instanceof Spi) {
            Spi spi = (Spi)provider;
            this.padValue = spi.padValue;
            this.imageSize = spi.imageSize;
        } else {
            this.padValue = Double.NaN;
            this.imageSize = null;
        }
    }

    private void clear() {
        this.ranges = null;
    }

    public void reset() {
        this.clear();
        super.reset();
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.clear();
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    public int getWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (this.imageSize != null) {
            return this.imageSize.width;
        }
        throw new IIOException(Errors.format(141));
    }

    public int getHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (this.imageSize != null) {
            return this.imageSize.height;
        }
        throw new IIOException(Errors.format(141));
    }

    public int getRawDataType(int imageIndex) throws IOException {
        if (this.originatingProvider instanceof Spi) {
            this.checkImageIndex(imageIndex);
            return ((Spi)this.originatingProvider).dataType;
        }
        return super.getRawDataType(imageIndex);
    }

    public Range getExpectedRange(int imageIndex, int bandIndex) throws IOException {
        this.checkBandIndex(imageIndex, bandIndex);
        return this.ranges != null ? this.ranges[bandIndex] : null;
    }

    protected double transform(double value) {
        return value == this.padValue ? Double.NaN : value;
    }

    protected SampleModel getStreamSampleModel(int imageIndex, ImageReadParam param) throws IOException {
        Dimension streamImageSize = this.imageSize;
        RawBinaryImageReadParam rawParam = null;
        if (param instanceof RawBinaryImageReadParam && (streamImageSize = (rawParam = (RawBinaryImageReadParam)param).getStreamImageSize()) == null) {
            streamImageSize = this.imageSize;
        }
        if (streamImageSize == null) {
            throw new IIOException(Errors.format(141));
        }
        if (this.imageSize != null && !streamImageSize.equals(this.imageSize)) {
            throw new IIOException(Errors.format(128));
        }
        SampleModel streamModel = this.getRawImageType(imageIndex).getSampleModel();
        streamModel = streamModel.createCompatibleSampleModel(streamImageSize.width, streamImageSize.height);
        if (rawParam != null) {
            streamModel = rawParam.getStreamSampleModel(streamModel);
        }
        return streamModel;
    }

    public ImageReadParam getDefaultReadParam() {
        return new RawBinaryImageReadParam();
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        ColorSpace newColorSpace;
        ColorSpace oldColorSpace;
        ColorModel finalColorModel;
        int sourceYSubsampling;
        int sourceXSubsampling;
        int[] destinationBands;
        int[] sourceBands;
        this.clearAbortRequest();
        this.checkImageIndex(imageIndex);
        if (param != null) {
            sourceBands = param.getSourceBands();
            destinationBands = param.getDestinationBands();
            sourceXSubsampling = param.getSourceXSubsampling();
            sourceYSubsampling = param.getSourceYSubsampling();
        } else {
            sourceBands = null;
            destinationBands = null;
            sourceXSubsampling = 1;
            sourceYSubsampling = 1;
        }
        ImageInputStream input = (ImageInputStream)this.getInput();
        SampleModel streamModel = this.getStreamSampleModel(imageIndex, param);
        int streamWidth = streamModel.getWidth();
        int streamHeight = streamModel.getHeight();
        int streamDataType = streamModel.getDataType();
        int streamWidthInBytes = streamWidth * DataBuffer.getDataTypeSize(streamDataType) / 8;
        BufferedImage image = this.getDestination(imageIndex, param, sourceBands, destinationBands, streamModel, streamWidth, streamHeight);
        SampleModel imageModel = image.getSampleModel();
        int numDstBands = imageModel.getNumBands();
        int numSrcBands = streamModel.getNumBands();
        RawBinaryImageReader.checkReadParamBandSettings(param, numSrcBands, numDstBands);
        this.processImageStarted(imageIndex);
        Rectangle srcRegion = new Rectangle();
        Rectangle dstRegion = new Rectangle();
        RawBinaryImageReader.computeRegions(param, streamWidth, streamHeight, image, srcRegion, dstRegion);
        int srcXMin = srcRegion.x;
        int srcXMax = srcXMin + srcRegion.width;
        int srcYMin = srcRegion.y;
        int srcYMax = srcYMin + srcRegion.height;
        int dstXMin = dstRegion.x;
        int dstXMax = dstXMin + dstRegion.width;
        int dstYMin = dstRegion.y;
        int dstYMax = dstYMin + dstRegion.height;
        boolean isDirect = sourceXSubsampling == 1 && sourceYSubsampling == 1 && srcXMin == 0 && srcXMax == streamWidth && srcYMin == 0 && srcYMax == streamHeight && dstXMin == 0 && dstXMax == streamWidth && dstYMin == 0 && dstYMax == streamHeight && imageModel.equals(streamModel);
        WritableRaster dstRaster = image.getRaster();
        WritableRaster srcRaster = isDirect ? dstRaster : WritableRaster.createWritableRaster(streamModel.createCompatibleSampleModel(streamWidth, Math.min(8, streamHeight)), null);
        DataBuffer buffer = srcRaster.getDataBuffer();
        int bufferHeight = srcRaster.getHeight();
        int[] offsets = buffer.getOffsets();
        double[] minimum = new double[numSrcBands];
        double[] maximum = new double[numSrcBands];
        double userPadValue = param instanceof RawBinaryImageReadParam ? ((RawBinaryImageReadParam)param).getPadValue() : Double.NaN;
        Arrays.fill(minimum, Double.POSITIVE_INFINITY);
        Arrays.fill(maximum, Double.NEGATIVE_INFINITY);
        long startStreamPosition = input.getStreamPosition();
        long expectedStreamLength = streamWidthInBytes * streamHeight * offsets.length;
        for (int bank = 0; bank < offsets.length; ++bank) {
            int upperSrcBand;
            int lowerSrcBand;
            if (offsets.length == numSrcBands) {
                lowerSrcBand = bank;
                upperSrcBand = bank + 1;
            } else if (offsets.length == 1) {
                lowerSrcBand = 0;
                upperSrcBand = numSrcBands;
            } else {
                throw new IIOException("Unknow SampleModel");
            }
            if (!isDirect) {
                long toSkip = srcYMin;
                if (bank != 0) {
                    toSkip += (long)(streamHeight - srcYMax);
                }
                if (input.skipBytes(toSkip *= (long)streamWidthInBytes) != toSkip) {
                    throw new EOFException("No bank #" + (bank + 1));
                }
                input.flushBefore(input.getStreamPosition());
            }
            int offset = offsets[bank];
            for (int sy = srcYMin; sy < srcYMax; sy += bufferHeight) {
                int validHeight = Math.min(srcYMax - sy, bufferHeight);
                int validLength = streamWidth * validHeight;
                switch (streamDataType) {
                    case 0: {
                        input.readFully(((DataBufferByte)buffer).getData(bank), offset, validLength);
                        break;
                    }
                    case 1: {
                        input.readFully(((DataBufferUShort)buffer).getData(bank), offset, validLength);
                        break;
                    }
                    case 2: {
                        input.readFully(((DataBufferShort)buffer).getData(bank), offset, validLength);
                        break;
                    }
                    case 3: {
                        input.readFully(((DataBufferInt)buffer).getData(bank), offset, validLength);
                        break;
                    }
                    case 4: {
                        input.readFully(((DataBufferFloat)buffer).getData(bank), offset, validLength);
                        break;
                    }
                    case 5: {
                        input.readFully(((DataBufferDouble)buffer).getData(bank), offset, validLength);
                        break;
                    }
                    default: {
                        throw new IIOException(Errors.format(142));
                    }
                }
                long streamPosition = input.getStreamPosition();
                input.flushBefore(streamPosition);
                this.processImageProgress((float)(streamPosition - startStreamPosition) * 100.0f / (float)expectedStreamLength);
                if (this.abortRequested()) {
                    this.processReadAborted();
                    return image;
                }
                if (isDirect) {
                    for (int srcBand = lowerSrcBand; srcBand < upperSrcBand; ++srcBand) {
                        int stop = offset + validLength;
                        for (int i = offset; i < stop; ++i) {
                            double value = buffer.getElemDouble(srcBand, i);
                            if (value == userPadValue) {
                                value = Double.NaN;
                            }
                            if (!Double.isNaN(value = this.transform(value))) {
                                if (value < minimum[srcBand]) {
                                    minimum[srcBand] = value;
                                }
                                if (value > maximum[srcBand]) {
                                    maximum[srcBand] = value;
                                }
                            }
                            buffer.setElemDouble(srcBand, i, value);
                        }
                    }
                    continue;
                }
                int dstYStart = dstYMin + (sy - srcYMin + sourceYSubsampling - 1) / sourceYSubsampling;
                int dstYStop = dstYMin + (sy - srcYMin + validHeight) / sourceYSubsampling;
                if (!($assertionsDisabled || dstYStart <= dstYStop && dstYStart >= dstYMin && dstYStop <= dstYMax)) {
                    throw new AssertionError();
                }
                for (int srcBand = lowerSrcBand; srcBand < upperSrcBand; ++srcBand) {
                    int dstBand = RawBinaryImageReader.sourceToDestBand(sourceBands, destinationBands, srcBand);
                    if (dstBand < 0) continue;
                    if (!$assertionsDisabled && RawBinaryImageReader.destToSourceBand(sourceBands, destinationBands, dstBand) != srcBand) {
                        throw new AssertionError();
                    }
                    int srcY = srcYMin + (dstYStart - dstYMin) * sourceYSubsampling;
                    srcY -= sy;
                    for (int dstY = dstYStart; dstY < dstYStop; ++dstY) {
                        if (!($assertionsDisabled || srcY >= 0 && srcY < validHeight)) {
                            throw new AssertionError();
                        }
                        int srcX = srcXMin;
                        for (int dstX = dstXMin; dstX < dstXMax; ++dstX) {
                            if (!$assertionsDisabled && srcX >= srcXMax) {
                                throw new AssertionError();
                            }
                            double value = srcRaster.getSampleDouble(srcX, srcY, srcBand);
                            if (value == userPadValue) {
                                value = Double.NaN;
                            }
                            if (!Double.isNaN(value = this.transform(value))) {
                                if (value < minimum[srcBand]) {
                                    minimum[srcBand] = value;
                                }
                                if (value > maximum[srcBand]) {
                                    maximum[srcBand] = value;
                                }
                            }
                            dstRaster.setSample(dstX, dstY, dstBand, value);
                            srcX += sourceXSubsampling;
                        }
                        srcY += sourceYSubsampling;
                    }
                }
            }
        }
        this.processImageComplete();
        this.ranges = new Range[numSrcBands];
        for (int band = 0; band < numSrcBands; ++band) {
            Range range;
            double min = minimum[band];
            double max = maximum[band];
            if (!(min < max)) continue;
            switch (streamDataType) {
                case 0: 
                case 2: {
                    range = new Range(class$java$lang$Short == null ? RawBinaryImageReader.class$("java.lang.Short") : class$java$lang$Short, (Comparable)new Short((short)min), (Comparable)new Short((short)max));
                    break;
                }
                case 1: 
                case 3: {
                    range = new Range(class$java$lang$Integer == null ? RawBinaryImageReader.class$("java.lang.Integer") : class$java$lang$Integer, (Comparable)new Integer((int)min), (Comparable)new Integer((int)max));
                    break;
                }
                case 4: {
                    range = new Range(class$java$lang$Float == null ? RawBinaryImageReader.class$("java.lang.Float") : class$java$lang$Float, (Comparable)new Float((float)min), (Comparable)new Float((float)max));
                    break;
                }
                case 5: {
                    range = new Range(class$java$lang$Double == null ? RawBinaryImageReader.class$("java.lang.Double") : class$java$lang$Double, (Comparable)new Double(min), (Comparable)new Double(max));
                    break;
                }
                default: {
                    throw new IOException(Errors.format(142));
                }
            }
            this.ranges[band] = range;
        }
        if (streamDataType != 0 && (finalColorModel = image.getColorModel()) instanceof ComponentColorModel && !(oldColorSpace = finalColorModel.getColorSpace()).equals(newColorSpace = this.getColorSpace(imageIndex, sourceBands, destinationBands))) {
            int[] bits = finalColorModel.getComponentSize();
            boolean hasAlpha = finalColorModel.hasAlpha();
            boolean isAlphaPremultiplied = finalColorModel.isAlphaPremultiplied();
            int transparency = finalColorModel.getTransparency();
            int transfertType = finalColorModel.getTransferType();
            finalColorModel = new ComponentColorModelJAI(newColorSpace, bits, hasAlpha, isAlphaPremultiplied, transparency, transfertType);
            return new BufferedImage(finalColorModel, image.getRaster(), image.isAlphaPremultiplied(), null);
        }
        return image;
    }

    protected final BufferedImage getDestination(int imageIndex, ImageReadParam param) throws IOException {
        SampleModel model = this.getStreamSampleModel(imageIndex, param);
        return this.getDestination(imageIndex, param, param.getSourceBands(), param.getDestinationBands(), model, model.getWidth(), model.getHeight());
    }

    private BufferedImage getDestination(int imageIndex, ImageReadParam param, int[] sourceBands, int[] destinationBands, SampleModel streamModel, int streamWidth, int streamHeight) throws IOException {
        int numBands;
        RawBinaryImageReadParam rawParam;
        ImageTypeSpecifier userType;
        ArrayList imageTypeList = new ArrayList();
        Iterator it = this.getImageTypes(imageIndex);
        while (it.hasNext()) {
            imageTypeList.add(it.next());
        }
        ColorSpace colorSpace = this.getColorSpace(imageIndex, sourceBands, destinationBands);
        ComponentColorModelJAI colorModel = new ComponentColorModelJAI(colorSpace, false, false, 1, streamModel.getDataType());
        imageTypeList.add(0, new ImageTypeSpecifier(colorModel, streamModel));
        if (param instanceof RawBinaryImageReadParam && (userType = (rawParam = (RawBinaryImageReadParam)param).getDestinationType(numBands = colorSpace.getNumComponents())) != null) {
            imageTypeList.add(0, userType);
        }
        return RawBinaryImageReader.getDestination(param, imageTypeList.iterator(), streamWidth, streamHeight);
    }

    private ColorSpace getColorSpace(int imageIndex, int[] sourceBands, int[] destinationBands) throws IOException {
        int numBands = this.getNumBands(imageIndex);
        int firstVisibleSourceBand = 0;
        if (destinationBands != null) {
            numBands = destinationBands.length;
            for (int i = 1; i < destinationBands.length; ++i) {
                if (destinationBands[i] >= destinationBands[firstVisibleSourceBand]) continue;
                firstVisibleSourceBand = i;
            }
        }
        if (sourceBands != null) {
            numBands = sourceBands.length;
            firstVisibleSourceBand = sourceBands[firstVisibleSourceBand];
        }
        return this.getColorSpace(imageIndex, firstVisibleSourceBand, numBands);
    }

    static {
        $assertionsDisabled = !RawBinaryImageReader.class.desiredAssertionStatus();
    }

    public static class Spi
    extends ImageReaderSpi {
        private static final String[] EXTENSIONS = new String[]{"raw"};
        protected Dimension imageSize;
        protected double padValue = Double.NaN;
        protected int dataType = 4;

        public Spi() {
            this("raw", "image/raw");
        }

        public Spi(String name, String mime) {
            if (name != null) {
                this.names = new String[]{name};
            }
            if (mime != null) {
                this.MIMETypes = new String[]{mime};
            }
            this.suffixes = EXTENSIONS;
            this.inputTypes = STANDARD_INPUT_TYPE;
            this.pluginClassName = "org.geotools.image.io.RawBinaryImageReader";
            this.vendorName = "Geotools 2";
            this.version = "1.0";
        }

        public String getDescription(Locale locale) {
            return Descriptions.getResources(locale).getString(2);
        }

        public boolean canDecodeInput(Object source) throws IOException {
            return false;
        }

        public ImageReader createReaderInstance() throws IOException {
            return new RawBinaryImageReader(this);
        }

        public ImageReader createReaderInstance(Object extension) throws IOException {
            ImageReader reader = this.createReaderInstance();
            if (reader instanceof RawBinaryImageReader) {
                RawBinaryImageReader rawReader = (RawBinaryImageReader)reader;
                if (extension instanceof Dimension) {
                    rawReader.imageSize = new Dimension((Dimension)extension);
                }
            }
            return reader;
        }
    }
}

