/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.util.Arrays;
import javax.imageio.IIOException;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;

final class RecordList {
    private double[] min;
    private double[] max;
    private float[] interval;
    private float[] data;
    private int columnCount = -1;
    private int upper;
    private int expectedLineCount = 1024;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RecordList() {
    }

    public RecordList(int columnCount, int expectedLineCount) {
        this.columnCount = columnCount;
        this.expectedLineCount = expectedLineCount;
    }

    public void add(double[] line) {
        if (this.data == null) {
            if (this.columnCount < 0) {
                this.columnCount = line.length;
            }
            this.min = new double[this.columnCount];
            Arrays.fill(this.min, Double.POSITIVE_INFINITY);
            this.max = new double[this.columnCount];
            Arrays.fill(this.max, Double.NEGATIVE_INFINITY);
            this.data = new float[this.columnCount * this.expectedLineCount];
        }
        int limit = Math.min(this.columnCount, line.length);
        int nextUpper = this.upper + this.columnCount;
        if (nextUpper >= this.data.length) {
            this.data = XArray.resize(this.data, Math.max(nextUpper, this.data.length + Math.min(this.data.length, 65536)));
        }
        for (int i = 0; i < limit; ++i) {
            double value = line[i];
            if (value < this.min[i]) {
                this.min[i] = value;
            }
            if (value > this.max[i]) {
                this.max[i] = value;
            }
            this.data[this.upper + i] = (float)value;
        }
        Arrays.fill(this.data, this.upper + limit, nextUpper, Float.NaN);
        this.upper = nextUpper;
    }

    public void trimToSize() {
        if (this.data != null) {
            this.data = XArray.resize(this.data, this.upper);
        }
    }

    final float[] getData() {
        return this.data;
    }

    final int getDataCount() {
        return this.upper;
    }

    public int getLineCount() {
        if (this.columnCount <= 0) {
            return 0;
        }
        if (!$assertionsDisabled && this.upper % this.columnCount != 0) {
            throw new AssertionError();
        }
        return this.upper / this.columnCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public double getMinimum(int column) {
        return this.min != null && this.min[column] <= this.max[column] ? this.min[column] : Double.NaN;
    }

    public double getMaximum(int column) {
        return this.max != null && this.max[column] >= this.min[column] ? this.max[column] : Double.NaN;
    }

    private float getInterval(int column, float eps) throws IIOException {
        int i;
        int oldCount;
        if (this.interval == null) {
            if (this.columnCount <= 0) {
                return Float.NaN;
            }
            this.interval = new float[this.columnCount];
        }
        if (this.interval[column] != 0.0f) {
            return this.interval[column];
        }
        int count = 0;
        float[] array = new float[this.getLineCount()];
        for (int i2 = column; i2 < this.upper; i2 += this.columnCount) {
            array[count++] = this.data[i2];
        }
        if (!$assertionsDisabled && count != array.length) {
            throw new AssertionError();
        }
        Arrays.sort(array);
        int upper = count - 1;
        int lower = count;
        while (--lower >= 1) {
            if (array[upper] == array[lower - 1]) continue;
            if (upper != lower) {
                System.arraycopy(array, upper, array, lower, count - upper);
                oldCount = count;
                Arrays.fill(array, count -= upper - lower, oldCount, Float.NaN);
            }
            upper = lower - 1;
        }
        if (upper != lower) {
            System.arraycopy(array, upper, array, lower, count - upper);
            oldCount = count;
            Arrays.fill(array, count -= upper - lower, oldCount, Float.NaN);
        }
        float delta = Float.POSITIVE_INFINITY;
        for (i = 1; i < count; ++i) {
            float d = array[i] - array[i - 1];
            if (!$assertionsDisabled && !(d > 0.0f)) {
                throw new AssertionError();
            }
            if (!(d < delta)) continue;
            delta = d;
        }
        for (i = 1; i < count; ++i) {
            float e = (array[i] - array[i - 1]) / delta;
            if (!(Math.abs((double)e - Math.rint(e)) > (double)eps)) continue;
            throw new IIOException(Errors.format(88));
        }
        this.interval[column] = Float.isInfinite(delta) ? Float.NaN : delta;
        return this.interval[column];
    }

    public int getPointCount(int column, float eps) throws IIOException {
        return (int)Math.round((this.getMaximum(column) - this.getMinimum(column)) / (double)this.getInterval(column, eps)) + 1;
    }

    public String toString(int xColumn, int yColumn, float eps) {
        float xCount = Float.NaN;
        float yCount = Float.NaN;
        if (xColumn >= 0) {
            try {
                xCount = this.getPointCount(xColumn, eps);
            }
            catch (IIOException exception) {
                // empty catch block
            }
        }
        if (yColumn >= 0) {
            try {
                yCount = this.getPointCount(yColumn, eps);
            }
            catch (IIOException exception) {
                // empty catch block
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(Vocabulary.format(130, new Integer(this.upper), new Float(xCount), new Float(yCount)));
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this));
        buffer.append('[');
        buffer.append(this.getLineCount());
        buffer.append("\u00a0\u00d7\u00a0");
        buffer.append(this.getColumnCount());
        buffer.append(']');
        return buffer.toString();
    }

    static {
        $assertionsDisabled = !RecordList.class.desiredAssertionStatus();
    }
}

