/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.color.ColorSpace;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.util.Range;
import org.geotools.image.io.ScaledColorSpace;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ComponentColorModelJAI;

public abstract class SimpleImageReader
extends ImageReader {
    static final boolean USE_JAI_MODEL = true;
    private long streamOrigin;

    protected SimpleImageReader(ImageReaderSpi provider) {
        super(provider);
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input instanceof ImageInputStream) {
            try {
                this.streamOrigin = ((ImageInputStream)input).getStreamPosition();
            }
            catch (IOException exception) {
                this.streamOrigin = 0L;
                Utilities.unexpectedException("org.geotools.gcs", "SimpleImageReader", "setInput", exception);
            }
        }
    }

    final void checkImageIndex(int imageIndex) throws IOException, IndexOutOfBoundsException {
        int numImages = this.getNumImages(false);
        if (imageIndex < this.minIndex || imageIndex >= numImages && numImages >= 0) {
            throw new IndexOutOfBoundsException(String.valueOf(imageIndex));
        }
    }

    final void checkBandIndex(int imageIndex, int bandIndex) throws IOException, IndexOutOfBoundsException {
        if (bandIndex >= this.getNumBands(imageIndex) || bandIndex < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(bandIndex));
        }
    }

    public int getNumImages(boolean allowSearch) throws IllegalStateException, IOException {
        if (this.input != null) {
            return 1;
        }
        throw new IllegalStateException(Errors.format(97));
    }

    public int getNumBands(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return 1;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        return Collections.singleton(this.getRawImageType(imageIndex)).iterator();
    }

    public ImageTypeSpecifier getRawImageType(int imageIndex) throws IOException {
        return this.getRawImageType(imageIndex, this.getNumBands(imageIndex));
    }

    final ImageTypeSpecifier getRawImageType(int imageIndex, int numBands) throws IOException {
        int dataType = this.getRawDataType(imageIndex);
        int[] bankIndices = new int[numBands];
        int[] bandOffsets = new int[numBands];
        int i = numBands;
        while (--i >= 0) {
            bankIndices[i] = i;
        }
        ColorSpace colorSpace = this.getColorSpace(imageIndex, 0, numBands);
        ComponentColorModelJAI cm = new ComponentColorModelJAI(colorSpace, null, false, false, 1, dataType);
        return new ImageTypeSpecifier(cm, (SampleModel)new ComponentSampleModelJAI(dataType, 1, 1, 1, 1, bankIndices, bandOffsets));
    }

    public int getRawDataType(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return 4;
    }

    public abstract Range getExpectedRange(int var1, int var2) throws IOException;

    final ColorSpace getColorSpace(int imageIndex, int bandIndex, int numBands) throws IOException {
        Range range;
        int dataType = this.getRawDataType(imageIndex);
        if (dataType != 0 && (range = this.getExpectedRange(imageIndex, bandIndex)) != null && Number.class.isAssignableFrom(range.getElementClass())) {
            float maxValue;
            float minValue;
            Number minimum = (Number)((Object)range.getMinValue());
            Number maximum = (Number)((Object)range.getMaxValue());
            if (minimum != null && maximum != null && (minValue = minimum.floatValue()) < (maxValue = maximum.floatValue()) && !Float.isInfinite(minValue) && !Float.isInfinite(maxValue)) {
                return new ScaledColorSpace(numBands, minValue, maxValue);
            }
        }
        return ColorSpace.getInstance(1003);
    }

    static int sourceToDestBand(int[] sourceBands, int[] destinationBands, int srcBand) {
        if (sourceBands == null) {
            return destinationBands != null ? destinationBands[srcBand] : srcBand;
        }
        for (int i = 0; i < sourceBands.length; ++i) {
            if (sourceBands[i] != srcBand) continue;
            return destinationBands != null ? destinationBands[i] : i;
        }
        return -1;
    }

    static int destToSourceBand(int[] sourceBands, int[] destinationBands, int destBand) {
        if (destinationBands == null) {
            return sourceBands != null ? sourceBands[destBand] : destBand;
        }
        for (int i = 0; i < destinationBands.length; ++i) {
            if (destinationBands[i] != destBand) continue;
            return sourceBands != null ? sourceBands[i] : i;
        }
        throw new IllegalArgumentException(String.valueOf(destBand));
    }

    final long getStreamLength() throws IOException {
        Object input = this.getInput();
        if (input instanceof ImageInputStream) {
            long length = ((ImageInputStream)input).length();
            if (length >= 0L) {
                length -= this.streamOrigin;
            }
            return length;
        }
        if (input instanceof File) {
            return ((File)input).length();
        }
        if (input instanceof URL) {
            return ((URL)input).openConnection().getContentLength();
        }
        if (input instanceof URLConnection) {
            return ((URLConnection)input).getContentLength();
        }
        return -1L;
    }

    final long getStreamLength(int fromImage, int toImage) throws IOException {
        int numImages;
        long length = this.getStreamLength();
        if (length > 0L && (numImages = this.getNumImages(false)) > 0) {
            if (toImage == -1) {
                toImage = numImages;
            }
            if (fromImage < 0 || fromImage > numImages) {
                throw new IndexOutOfBoundsException(String.valueOf(fromImage));
            }
            if (toImage < 0 || toImage > numImages) {
                throw new IndexOutOfBoundsException(String.valueOf(toImage));
            }
            if (fromImage > toImage) {
                throw new IllegalArgumentException();
            }
            return length * (long)(toImage - fromImage) / (long)numImages;
        }
        return length;
    }
}

