/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.util.Range;
import org.geotools.image.io.TextImageReader;
import org.geotools.io.LineFormat;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Descriptions;

public class TextMatrixImageReader
extends TextImageReader {
    private float[] data;
    private int width;
    private int height;
    private int expectedHeight;
    private boolean completed;
    private Range range;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected TextMatrixImageReader(ImageReaderSpi provider) {
        super(provider, 4);
    }

    private void clear() {
        this.completed = false;
        this.range = null;
        this.data = null;
        this.width = 0;
        this.height = 0;
        this.expectedHeight = 0;
    }

    public void reset() {
        this.clear();
        super.reset();
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.clear();
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    private boolean load(int imageIndex, boolean all) throws IOException {
        String line;
        this.clearAbortRequest();
        if (all) {
            this.processImageStarted(imageIndex);
        }
        float[] values = this.data != null ? new float[this.width] : null;
        int offset = this.width * this.height;
        BufferedReader input = this.getReader();
        LineFormat format = this.getLineFormat(imageIndex);
        float padValue = (float)this.getPadValue(imageIndex);
        while ((line = input.readLine()) != null) {
            int newOffset;
            if (this.isComment(line)) continue;
            try {
                format.setLine(line);
                values = format.getValues(values);
                int i = values.length;
                while (--i >= 0) {
                    if (values[i] != padValue) continue;
                    values[i] = Float.NaN;
                }
            }
            catch (ParseException exception) {
                throw new IIOException(this.getPositionString(exception.getLocalizedMessage()), exception);
            }
            if (this.data == null) {
                this.data = new float[1024];
            }
            if ((newOffset = offset + (this.width = values.length)) > this.data.length) {
                this.data = XArray.resize(this.data, newOffset + Math.min(newOffset, 65536));
            }
            System.arraycopy(values, 0, this.data, offset, this.width);
            offset = newOffset;
            ++this.height;
            if (!all) {
                long streamLength = this.getStreamLength(imageIndex, imageIndex + 1);
                if (streamLength < 0L) break;
                this.expectedHeight = (int)(streamLength / (long)(line.length() + 1));
                break;
            }
            if (this.height > this.expectedHeight) continue;
            this.processImageProgress((float)this.height * 100.0f / (float)this.expectedHeight);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            return true;
        }
        if (this.completed = all) {
            this.data = XArray.resize(this.data, offset);
            this.expectedHeight = this.height;
        }
        if (all) {
            this.processImageComplete();
        }
        return false;
    }

    public int getWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (this.data == null) {
            this.load(imageIndex, false);
        }
        return this.width;
    }

    public int getHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (this.data == null || !this.completed) {
            this.load(imageIndex, true);
        }
        return this.height;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        boolean isDirect;
        int destinationYOffset;
        int destinationXOffset;
        int subsamplingYOffset;
        int subsamplingXOffset;
        int sourceYSubsampling;
        int sourceXSubsampling;
        int[] destinationBands;
        int[] sourceBands;
        boolean numSrcBands = true;
        boolean numDstBands = true;
        this.checkImageIndex(imageIndex);
        TextMatrixImageReader.checkReadParamBandSettings(param, 1, 1);
        if (param != null) {
            sourceBands = param.getSourceBands();
            destinationBands = param.getDestinationBands();
            Point offset = param.getDestinationOffset();
            sourceXSubsampling = param.getSourceXSubsampling();
            sourceYSubsampling = param.getSourceYSubsampling();
            subsamplingXOffset = param.getSubsamplingXOffset();
            subsamplingYOffset = param.getSubsamplingYOffset();
            destinationXOffset = offset.x;
            destinationYOffset = offset.y;
        } else {
            sourceBands = null;
            destinationBands = null;
            sourceXSubsampling = 1;
            sourceYSubsampling = 1;
            subsamplingXOffset = 0;
            subsamplingYOffset = 0;
            destinationXOffset = 0;
            destinationYOffset = 0;
        }
        Rectangle srcRegion = TextMatrixImageReader.getSourceRegion(param, this.width, this.height);
        boolean bl = isDirect = sourceXSubsampling == 1 && sourceYSubsampling == 1 && subsamplingXOffset == 0 && subsamplingYOffset == 0 && destinationXOffset == 0 && destinationYOffset == 0 && srcRegion.x == 0 && srcRegion.width == this.width && srcRegion.y == 0 && srcRegion.height == this.height;
        if ((this.data == null || !this.completed) && this.load(imageIndex, true)) {
            return null;
        }
        if (isDirect && (param == null || param.getDestination() == null)) {
            ImageTypeSpecifier type = this.getRawImageType(imageIndex);
            SampleModel model = type.getSampleModel().createCompatibleSampleModel(this.width, this.height);
            DataBufferFloat buffer = new DataBufferFloat(this.data, this.data.length);
            WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
            return new BufferedImage(type.getColorModel(), raster, false, null);
        }
        boolean dstBand = false;
        BufferedImage image = TextMatrixImageReader.getDestination(param, this.getImageTypes(imageIndex), this.width, this.height);
        WritableRaster dstRaster = image.getRaster();
        Rectangle dstRegion = new Rectangle();
        TextMatrixImageReader.computeRegions(param, this.width, this.height, image, srcRegion, dstRegion);
        int dstXMin = dstRegion.x;
        int dstYMin = dstRegion.y;
        int dstXMax = dstRegion.width + dstXMin;
        int dstYMax = dstRegion.height + dstYMin;
        int srcY = srcRegion.y;
        for (int y = dstYMin; y < dstYMax; ++y) {
            if (!$assertionsDisabled && srcY >= srcRegion.y + srcRegion.height) {
                throw new AssertionError();
            }
            int srcX = srcRegion.x;
            for (int x = dstXMin; x < dstXMax; ++x) {
                if (!$assertionsDisabled && srcX >= srcRegion.x + srcRegion.width) {
                    throw new AssertionError();
                }
                float value = this.data[srcY * this.width + srcX];
                dstRaster.setSample(x, y, 0, value);
                srcX += sourceXSubsampling;
            }
            srcY += sourceYSubsampling;
        }
        return image;
    }

    public Range getExpectedRange(int imageIndex, int bandIndex) throws IOException {
        this.checkBandIndex(imageIndex, bandIndex);
        if (this.range == null) {
            this.load(imageIndex, true);
            float minimum = Float.POSITIVE_INFINITY;
            float maximum = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < this.data.length; ++i) {
                float value = this.data[i];
                if (value < minimum) {
                    minimum = value;
                }
                if (!(value > maximum)) continue;
                maximum = value;
            }
            if (minimum < maximum) {
                this.range = new Range(Float.class, (Comparable)new Float(minimum), (Comparable)new Float(maximum));
            }
        }
        return this.range;
    }

    static {
        $assertionsDisabled = !TextMatrixImageReader.class.desiredAssertionStatus();
    }

    public static class Spi
    extends TextImageReader.Spi {
        public Spi() {
            this("matrix", "text/matrix");
        }

        public Spi(String name, String mime) {
            super(name, mime);
            this.pluginClassName = "org.geotools.image.io.TextMatrixImageReader";
        }

        public String getDescription(Locale locale) {
            return Descriptions.getResources(locale).getString(1);
        }

        public ImageReader createReaderInstance(Object extension) throws IOException {
            return new TextMatrixImageReader(this);
        }

        Boolean isValueCountAcceptable(int count) {
            return count > 10 ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

