/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.util.Range;
import org.geotools.image.io.RecordList;
import org.geotools.image.io.TextImageReader;
import org.geotools.io.LineFormat;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Descriptions;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.NumberRange;

public class TextRecordImageReader
extends TextImageReader {
    private static final float EPS = 1.0E-5f;
    private static final int PROGRESS_INTERVAL = 4096;
    private static final boolean CLEAR = true;
    private static final double[] EMPTY = new double[0];
    private transient int xColumn = 0;
    private transient int yColumn = 1;
    private transient double padValue = Double.NaN;
    private transient LineFormat lineFormat;
    private RecordList[] data;
    private int nextImageIndex;
    private float expectedDatumLength = 10.4f;

    public TextRecordImageReader(ImageReaderSpi provider) {
        super(provider, 4);
    }

    public TextRecordImageReader(ImageReaderSpi provider, int rawImageType) {
        super(provider, rawImageType);
        this.clear();
        if (rawImageType == 5) {
            Logger.getLogger("org.geotools.image.io").warning("Type double is deprecated.");
        }
    }

    private float getGridTolerance() {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).gridTolerance : 1.0E-5f;
    }

    public int getColumnX(int imageIndex) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).xColumn : 0;
    }

    public int getColumnY(int imageIndex) throws IOException {
        return this.originatingProvider instanceof Spi ? ((Spi)this.originatingProvider).yColumn : 1;
    }

    private int getColumn(int imageIndex, int band) throws IOException {
        int yColumn;
        int xColumn = this.getColumnX(imageIndex);
        if (band >= Math.min(xColumn, yColumn = this.getColumnY(imageIndex))) {
            ++band;
        }
        if (band >= Math.max(xColumn, yColumn)) {
            ++band;
        }
        return band;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.clear();
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    public int getNumBands(int imageIndex) throws IOException {
        return this.getRecords(imageIndex).getColumnCount() - (this.getColumnX(imageIndex) == this.getColumnY(imageIndex) ? 1 : 2);
    }

    public int getWidth(int imageIndex) throws IOException {
        return this.getRecords(imageIndex).getPointCount(this.getColumnX(imageIndex), this.getGridTolerance());
    }

    public int getHeight(int imageIndex) throws IOException {
        return this.getRecords(imageIndex).getPointCount(this.getColumnY(imageIndex), this.getGridTolerance());
    }

    public Rectangle2D getLogicalBounds(int imageIndex) throws IOException {
        float tolerance = this.getGridTolerance();
        RecordList records = this.getRecords(imageIndex);
        int xColumn = this.getColumnX(imageIndex);
        int yColumn = this.getColumnY(imageIndex);
        double xmin = records.getMinimum(xColumn);
        double ymin = records.getMinimum(yColumn);
        double width = records.getMaximum(xColumn) - xmin;
        double height = records.getMaximum(yColumn) - ymin;
        double dx = width / (double)(records.getPointCount(xColumn, tolerance) - 1);
        double dy = height / (double)(records.getPointCount(yColumn, tolerance) - 1);
        return new Rectangle2D.Double(xmin - 0.5 * dx, ymin - 0.5 * dy, width + dx, height + dy);
    }

    public AffineTransform getTransform(int imageIndex) throws IOException {
        Rectangle2D bounds = this.getLogicalBounds(imageIndex);
        int width = this.getWidth(imageIndex);
        int height = this.getHeight(imageIndex);
        double pixelWidth = bounds.getWidth() / (double)(width - 1);
        double pixelHeight = bounds.getHeight() / (double)(height - 1);
        return new AffineTransform(pixelWidth, 0.0, 0.0, -pixelHeight, bounds.getMinX() - 0.5 * pixelWidth, bounds.getMaxY() + 0.5 * pixelHeight);
    }

    public Range getExpectedRange(int imageIndex, int band) throws IOException {
        int column = this.getColumn(imageIndex, band);
        RecordList records = this.getRecords(imageIndex);
        return new NumberRange(records.getMinimum(column), records.getMaximum(column));
    }

    protected double[] parseLine(String line, double[] values) throws ParseException {
        if (line == null) {
            return null;
        }
        if (this.isComment(line) || this.lineFormat.setLine(line) == 0) {
            return EMPTY;
        }
        values = this.lineFormat.getValues(values);
        for (int i = 0; i < values.length; ++i) {
            if (i == this.xColumn || i == this.yColumn || values[i] != this.padValue) continue;
            values[i] = Double.NaN;
        }
        return values;
    }

    private RecordList getRecords(int imageIndex) throws IOException {
        RecordList records;
        this.clearAbortRequest();
        this.checkImageIndex(imageIndex);
        if (imageIndex >= this.nextImageIndex) {
            long nextProgressPosition;
            this.processImageStarted(imageIndex);
            BufferedReader reader = this.getReader();
            long origine = TextRecordImageReader.getStreamPosition(reader);
            long length = this.getStreamLength(this.nextImageIndex, imageIndex + 1);
            long l = nextProgressPosition = origine >= 0L && length > 0L ? 0L : Long.MAX_VALUE;
            while (this.nextImageIndex <= imageIndex) {
                RecordList records2;
                if (this.seekForwardOnly) {
                    this.minIndex = this.nextImageIndex;
                }
                if (this.nextImageIndex != 0 && this.data != null && (records2 = this.data[this.nextImageIndex - 1]) != null) {
                    if (this.seekForwardOnly) {
                        this.data[this.nextImageIndex - 1] = null;
                    } else {
                        records2.trimToSize();
                    }
                }
                double[] values = null;
                RecordList records3 = null;
                boolean keep = this.nextImageIndex == imageIndex || !this.seekForwardOnly;
                this.xColumn = this.getColumnX(this.nextImageIndex);
                this.yColumn = this.getColumnY(this.nextImageIndex);
                this.padValue = this.getPadValue(this.nextImageIndex);
                this.lineFormat = this.getLineFormat(this.nextImageIndex);
                try {
                    double[] candidate;
                    String line;
                    while ((line = reader.readLine()) != null && (candidate = this.parseLine(line, values)) != null) {
                        long position;
                        if (candidate.length == 0) continue;
                        values = candidate;
                        if (keep) {
                            if (records3 == null) {
                                int expectedLineCount = Math.max(8, Math.min(65536, Math.round((float)length / (this.expectedDatumLength * (float)values.length))));
                                records3 = new RecordList(values.length, expectedLineCount);
                            }
                            records3.add(values);
                        }
                        if ((position = TextRecordImageReader.getStreamPosition(reader) - origine) < nextProgressPosition) continue;
                        this.processImageProgress((float)position * (100.0f / (float)length));
                        nextProgressPosition = position + 4096L;
                        if (!this.abortRequested()) continue;
                        this.processReadAborted();
                        return records3;
                    }
                }
                catch (ParseException exception) {
                    throw new IIOException(this.getPositionString(exception.getLocalizedMessage()), exception);
                }
                if (records3 != null) {
                    int lineCount = records3.getLineCount();
                    if (lineCount < 2) {
                        throw new IIOException(this.getPositionString(Errors.format(37)));
                    }
                    if (this.data == null) {
                        this.data = new RecordList[imageIndex + 1];
                    } else if (this.data.length <= imageIndex) {
                        this.data = (RecordList[])XArray.resize(this.data, imageIndex + 1);
                    }
                    this.data[this.nextImageIndex] = records3;
                    float meanDatumLength = (float)(TextRecordImageReader.getStreamPosition(reader) - origine) / (float)records3.getDataCount();
                    if (meanDatumLength > 0.0f) {
                        this.expectedDatumLength = meanDatumLength;
                    }
                }
                ++this.nextImageIndex;
            }
            this.processImageComplete();
        }
        if (this.data != null && imageIndex < this.data.length && (records = this.data[imageIndex]) != null) {
            return records;
        }
        throw new IndexOutOfBoundsException(String.valueOf(imageIndex));
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        int i;
        int b;
        int destinationYOffset;
        int destinationXOffset;
        int subsamplingYOffset;
        int subsamplingXOffset;
        int sourceYSubsampling;
        int sourceXSubsampling;
        int[] dstBands;
        int[] srcBands;
        float tolerance = this.getGridTolerance();
        int xColumn = this.getColumnX(imageIndex);
        int yColumn = this.getColumnY(imageIndex);
        RecordList records = this.getRecords(imageIndex);
        int width = records.getPointCount(xColumn, tolerance);
        int height = records.getPointCount(yColumn, tolerance);
        int numSrcBands = records.getColumnCount() - (xColumn == yColumn ? 1 : 2);
        if (param != null) {
            srcBands = param.getSourceBands();
            dstBands = param.getDestinationBands();
            Point offset = param.getDestinationOffset();
            sourceXSubsampling = param.getSourceXSubsampling();
            sourceYSubsampling = param.getSourceYSubsampling();
            subsamplingXOffset = param.getSubsamplingXOffset();
            subsamplingYOffset = param.getSubsamplingYOffset();
            destinationXOffset = offset.x;
            destinationYOffset = offset.y;
        } else {
            srcBands = null;
            dstBands = null;
            sourceXSubsampling = 1;
            sourceYSubsampling = 1;
            subsamplingXOffset = 0;
            subsamplingYOffset = 0;
            destinationXOffset = 0;
            destinationYOffset = 0;
        }
        int numDstBands = dstBands != null ? dstBands.length : (srcBands != null ? srcBands.length : numSrcBands);
        BufferedImage image = TextRecordImageReader.getDestination(param, this.getImageTypes(imageIndex, numDstBands), width, height);
        TextRecordImageReader.checkReadParamBandSettings(param, numSrcBands, image.getSampleModel().getNumBands());
        Rectangle srcRegion = new Rectangle();
        Rectangle dstRegion = new Rectangle();
        TextRecordImageReader.computeRegions(param, width, height, image, srcRegion, dstRegion);
        int sourceXMin = srcRegion.x;
        int sourceYMin = srcRegion.y;
        int sourceXMax = srcRegion.width + sourceXMin;
        int sourceYMax = srcRegion.height + sourceYMin;
        WritableRaster raster = image.getRaster();
        int rasterWidth = raster.getWidth();
        int rasterHeigth = raster.getHeight();
        int columnCount = records.getColumnCount();
        int dataCount = records.getDataCount();
        float[] data = records.getData();
        double xmin = records.getMinimum(xColumn);
        double ymin = records.getMinimum(yColumn);
        double xmax = records.getMaximum(xColumn);
        double ymax = records.getMaximum(yColumn);
        double scaleX = (double)(width - 1) / (xmax - xmin);
        double scaleY = (double)(height - 1) / (ymax - ymin);
        int minX = dstRegion.x;
        int minY = dstRegion.y;
        int maxX = dstRegion.width + minX;
        int maxY = dstRegion.height + minY;
        int n = b = dstBands != null ? dstBands.length : numDstBands;
        while (--b >= 0) {
            int band = dstBands != null ? dstBands[b] : b;
            for (int y = minY; y < maxY; ++y) {
                for (int x = minX; x < maxX; ++x) {
                    raster.setSample(x, y, band, Float.NaN);
                }
            }
        }
        int[] columns = new int[srcBands != null ? srcBands.length : numDstBands];
        for (i = 0; i < columns.length; ++i) {
            columns[i] = this.getColumn(imageIndex, srcBands != null ? srcBands[i] : i);
        }
        for (i = 0; i < dataCount; i += columnCount) {
            double fx = ((double)data[i + xColumn] - xmin) * scaleX;
            double fy = (ymax - (double)data[i + yColumn]) * scaleY;
            int x = (int)Math.round(fx);
            int y = (int)Math.round(fy);
            if (!(Math.abs((double)x - fx) <= (double)tolerance)) {
                this.fireBadCoordinate(data[i + xColumn]);
                continue;
            }
            if (!(Math.abs((double)y - fy) <= (double)tolerance)) {
                this.fireBadCoordinate(data[i + yColumn]);
                continue;
            }
            if (x < sourceXMin || x >= sourceXMax || y < sourceYMin || y >= sourceYMax || (x -= subsamplingXOffset) % sourceXSubsampling != 0 || (y -= subsamplingYOffset) % sourceYSubsampling != 0) continue;
            x = x / sourceXSubsampling + (destinationXOffset - sourceXMin);
            y = y / sourceYSubsampling + (destinationYOffset - sourceYMin);
            if (x >= rasterWidth || y >= rasterHeigth) continue;
            for (int j = 0; j < columns.length; ++j) {
                raster.setSample(x, y, dstBands != null ? dstBands[j] : j, data[i + columns[j]]);
            }
        }
        return image;
    }

    private Iterator getImageTypes(int imageIndex, int numBands) throws IOException {
        ArrayList<ImageTypeSpecifier> list = new ArrayList<ImageTypeSpecifier>();
        list.add(this.getRawImageType(imageIndex, numBands));
        Iterator it = this.getImageTypes(imageIndex);
        while (it.hasNext()) {
            list.add((ImageTypeSpecifier)it.next());
        }
        return list.iterator();
    }

    private void fireBadCoordinate(float coordinate) {
        this.processWarningOccurred(this.getPositionString(Errors.format(7, new Float(coordinate))));
    }

    private void clear() {
        this.data = null;
        this.lineFormat = null;
        this.nextImageIndex = 0;
        this.expectedDatumLength = 10.4f;
        if (this.originatingProvider instanceof Spi) {
            Spi provider = (Spi)this.originatingProvider;
            this.xColumn = provider.xColumn;
            this.yColumn = provider.yColumn;
            this.padValue = provider.padValue;
        } else {
            this.xColumn = 0;
            this.yColumn = 1;
            this.padValue = Double.NaN;
        }
    }

    public void reset() {
        this.clear();
        super.reset();
    }

    public static class Spi
    extends TextImageReader.Spi {
        final int xColumn;
        final int yColumn;
        protected float gridTolerance = 1.0E-5f;

        public Spi() {
            this("gridded records", "text/x-grid");
        }

        public Spi(String name, String mime) {
            this(name, mime, 0, 1);
        }

        public Spi(String name, String mime, int xColumn, int yColumn) {
            super(name, mime);
            this.xColumn = xColumn;
            this.yColumn = yColumn;
            if (xColumn < 0) {
                throw new IllegalArgumentException(Errors.format(74, "x", new Integer(xColumn)));
            }
            if (yColumn < 0) {
                throw new IllegalArgumentException(Errors.format(74, "y", new Integer(yColumn)));
            }
            this.pluginClassName = "org.geotools.image.io.TextRecordImageReader";
        }

        public String getDescription(Locale locale) {
            return Descriptions.getResources(locale).getString(0);
        }

        protected Boolean canDecodeLine(String line) {
            if (line.trim().length() != 0) {
                try {
                    LineFormat reader = this.locale != null ? new LineFormat(this.locale) : new LineFormat();
                    if (reader.setLine(line) >= (this.xColumn == this.yColumn ? 2 : 3)) {
                        return Boolean.TRUE;
                    }
                }
                catch (ParseException exception) {
                    return Boolean.FALSE;
                }
            }
            return null;
        }

        public ImageReader createReaderInstance(Object extension) throws IOException {
            return new TextRecordImageReader(this);
        }

        Boolean isValueCountAcceptable(int count) {
            return count <= 10 ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

