/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.jai;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.OperationDescriptorImpl;
import org.geotools.image.jai.CombineTransform;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;

public class CombineDescriptor
extends OperationDescriptorImpl {
    public static final String OPERATION_NAME = "org.geotools.Combine";

    public CombineDescriptor() {
        super((String[][])new String[][]{{"GlobalName", OPERATION_NAME}, {"LocalName", OPERATION_NAME}, {"Vendor", "org.geotools"}, {"Description", "Combine rendered images using a linear relation."}, {"DocURL", "http://www.geotools.org/"}, {"Version", "1.0"}, {"arg0Desc", "The coefficients for linear combinaison as a matrix."}, {"arg1Desc", "An optional transform to apply on sample values before the linear combinaison."}}, new String[]{"rendered"}, 0, new String[]{"matrix", "transform"}, new Class[]{[[D.class, CombineTransform.class}, new Object[]{NO_PARAMETER_DEFAULT, null}, null);
    }

    protected boolean validateSources(String modeName, ParameterBlock param, StringBuffer message) {
        if (super.validateSources(modeName, param, message)) {
            int i = param.getNumSources();
            while (--i >= 0) {
                Object source = param.getSource(i);
                if (source instanceof RenderedImage) continue;
                message.append(Errors.format(12, "source" + i, Utilities.getShortClassName(source)));
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validateParameters(String modeName, ParameterBlock param, StringBuffer message) {
        if (!super.validateParameters(modeName, param, message)) {
            return false;
        }
        double[][] matrix = (double[][])param.getObjectParameter(0);
        int numSamples = 1;
        int i = param.getNumSources();
        while (--i >= 0) {
            numSamples += ((RenderedImage)param.getSource(i)).getSampleModel().getNumBands();
        }
        for (i = 0; i < matrix.length; ++i) {
            if (matrix[i].length == numSamples) continue;
            message.append(Errors.format(130, new Integer(i), new Integer(matrix[i].length), new Integer(numSamples)));
            return false;
        }
        return true;
    }
}

