/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.jai;

import java.awt.image.renderable.RenderedImageFactory;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.registry.RIFRegistry;
import org.geotools.image.jai.CombineCRIF;
import org.geotools.image.jai.CombineDescriptor;
import org.geotools.image.jai.HysteresisCRIF;
import org.geotools.image.jai.HysteresisDescriptor;
import org.geotools.image.jai.NodataFilterCRIF;
import org.geotools.image.jai.NodataFilterDescriptor;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Logging;

public final class Registry {
    private Registry() {
    }

    public static boolean registerGeotoolsServices(OperationRegistry registry) {
        LogRecord record;
        String op = "org.geotools";
        try {
            op = "org.geotools.Combine";
            registry.registerDescriptor((RegistryElementDescriptor)new CombineDescriptor());
            RIFRegistry.register((OperationRegistry)registry, (String)op, (String)"org.geotools", (RenderedImageFactory)((Object)new CombineCRIF()));
            op = "org.geotools.Hysteresis";
            registry.registerDescriptor((RegistryElementDescriptor)new HysteresisDescriptor());
            RIFRegistry.register((OperationRegistry)registry, (String)op, (String)"org.geotools", (RenderedImageFactory)((Object)new HysteresisCRIF()));
            op = "org.geotools.NodataFilter";
            registry.registerDescriptor((RegistryElementDescriptor)new NodataFilterDescriptor());
            RIFRegistry.register((OperationRegistry)registry, (String)op, (String)"org.geotools", (RenderedImageFactory)((Object)new NodataFilterCRIF()));
            record = Logging.format(Level.CONFIG, 31);
            op = null;
        }
        catch (IllegalArgumentException exception) {
            record = Logging.getResources(null).getLogRecord(Level.WARNING, 4, op);
            record.setThrown(exception);
        }
        Registry.log("registerGeotoolsServices", record);
        return op == null;
    }

    public static synchronized void setNativeAccelerationAllowed(String operation, boolean allowed) {
        String product = "com.sun.media.jai";
        OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
        List factories = registry.getOrderedFactoryList("rendered", operation, "com.sun.media.jai");
        if (factories != null) {
            RenderedImageFactory javaFactory = null;
            RenderedImageFactory nativeFactory = null;
            Boolean currentState = null;
            Iterator it = factories.iterator();
            while (it.hasNext()) {
                RenderedImageFactory factory = (RenderedImageFactory)it.next();
                String pack = factory.getClass().getPackage().getName();
                if (pack.equals("com.sun.media.jai.mlib")) {
                    nativeFactory = factory;
                    if (javaFactory != null) {
                        currentState = Boolean.FALSE;
                    }
                }
                if (!pack.equals("com.sun.media.jai.opimage")) continue;
                javaFactory = factory;
                if (nativeFactory == null) continue;
                currentState = Boolean.TRUE;
            }
            if (currentState != null && currentState != allowed) {
                RIFRegistry.unsetPreference((OperationRegistry)registry, (String)operation, (String)"com.sun.media.jai", (RenderedImageFactory)(allowed ? javaFactory : nativeFactory), (RenderedImageFactory)(allowed ? nativeFactory : javaFactory));
                RIFRegistry.setPreference((OperationRegistry)registry, (String)operation, (String)"com.sun.media.jai", (RenderedImageFactory)(allowed ? nativeFactory : javaFactory), (RenderedImageFactory)(allowed ? javaFactory : nativeFactory));
                LogRecord record = Logging.format(Level.CONFIG, 11, operation, new Integer(allowed ? 1 : 0));
                Registry.log("setNativeAccelerationAllowed", record);
            }
        }
    }

    private static void log(String method, LogRecord record) {
        record.setSourceClassName(Utilities.getShortName(Registry.class));
        record.setSourceMethodName(method);
        Logger.getLogger("org.geotools.image").log(record);
    }
}

