/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.image;

import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.PropertySource;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.RenderedCoverage;
import org.geotools.factory.Hints;
import org.geotools.util.NumberRange;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.operation.MathTransform1D;

public final class CoverageUtilities {
    public static final Hints LENIENT_HINT = new Hints(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);

    private CoverageUtilities() {
    }

    public static double[] getBackgroundValues(GridCoverage2D coverage) {
        GridSampleDimension[] sampleDimensions = coverage.getSampleDimensions();
        double[] background = new double[sampleDimensions.length];
        int length = background.length;
        for (int i = 0; i < length; ++i) {
            NumberRange range = sampleDimensions[i].getBackground().getRange();
            double min = range.getMinimum();
            double max = range.getMaximum();
            background[i] = range.isMinIncluded() ? min : (range.isMaxIncluded() ? max : 0.5 * (min + max));
        }
        return background;
    }

    public static boolean hasTransform(SampleDimension[] sampleDimensions) {
        int i = sampleDimensions.length;
        if (--i >= 0) {
            MathTransform1D tr;
            SampleDimension sd = sampleDimensions[i];
            if (sd instanceof GridSampleDimension) {
                sd = ((GridSampleDimension)sd).geophysics(false);
            }
            return (tr = sd.getSampleToGeophysics()) != null && !tr.isIdentity();
        }
        return false;
    }

    public static boolean uses(GridCoverage coverage, RenderedImage image) {
        if (coverage != null) {
            if (coverage instanceof RenderedCoverage && ((RenderedCoverage)coverage).getRenderedImage() == image) {
                return true;
            }
            List sources = coverage.getSources();
            if (sources != null) {
                Iterator it = sources.iterator();
                while (it.hasNext()) {
                    if (!CoverageUtilities.uses((GridCoverage)it.next(), image)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getVisibleBand(Object image) {
        Object candidate = null;
        if (image instanceof RenderedImage) {
            candidate = ((RenderedImage)image).getProperty("GC_VisibleBand");
        } else if (image instanceof PropertySource) {
            candidate = ((PropertySource)image).getProperty("GC_VisibleBand");
        }
        if (candidate instanceof Integer) {
            return (Integer)candidate;
        }
        return 0;
    }

    public static int prepareSourcesForGCOperation(GridCoverage2D coverage, Interpolation interpolation, boolean hasFilter, RenderingHints hints) {
        boolean getGeophysics;
        Vector<RenderedImage> sources;
        GridCoverage2D candidate;
        boolean isIndexColorModel;
        RenderedImage sourceImage = coverage.getRenderedImage();
        boolean useNonGeoView = false;
        if (hints != null && hints.containsKey(Hints.REPLACE_NON_GEOPHYSICS_VIEW)) {
            boolean bl = useNonGeoView = (Boolean)hints.get(Hints.REPLACE_NON_GEOPHYSICS_VIEW) == false;
        }
        if (!(isIndexColorModel = sourceImage.getColorModel() instanceof IndexColorModel)) {
            return 0;
        }
        boolean isNearestNeigborInterpolation = interpolation instanceof InterpolationNearest;
        if (isNearestNeigborInterpolation && !hasFilter && (candidate = coverage.geophysics(false)) != coverage && (sources = coverage.getRenderedImage().getSources()) != null && sources.contains(candidate.getRenderedImage())) {
            return 3;
        }
        boolean hasRenderingCategories = CoverageUtilities.hasRenderingCategories(coverage);
        boolean preprocessIndexed = isIndexColorModel && (!isNearestNeigborInterpolation || hasFilter);
        boolean bl = getGeophysics = !useNonGeoView && hasRenderingCategories && preprocessIndexed;
        if (preprocessIndexed) {
            if (!getGeophysics) {
                return 1;
            }
            if (getGeophysics) {
                return 2;
            }
        }
        return 0;
    }

    public static boolean hasRenderingCategories(GridCoverage gridCoverage) {
        boolean retVal = false;
        int numSampleDimensions = gridCoverage.getNumSampleDimensions();
        if (numSampleDimensions > 0) {
            SampleDimension[] sampleDimensions = new SampleDimension[numSampleDimensions];
            for (int i = 0; i < numSampleDimensions; ++i) {
                sampleDimensions[i] = gridCoverage.getSampleDimension(i);
            }
            return CoverageUtilities.hasTransform(sampleDimensions);
        }
        return retVal;
    }
}

