/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.image;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.media.jai.BorderExtender;
import javax.media.jai.ColorCube;
import javax.media.jai.IHSColorSpace;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandCombineDescriptor;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.NullDescriptor;
import org.geotools.image.ImageWorker;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;

public final class ImageUtilities {
    public static final RenderingHints DONT_REPLACE_INDEX_COLOR_MODEL = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
    public static final RenderingHints REPLACE_INDEX_COLOR_MODEL = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
    public static final RenderingHints NN_INTERPOLATION_HINT = new RenderingHints(JAI.KEY_INTERPOLATION, new InterpolationNearest());
    public static final RenderingHints NOCACHE_HINT = new RenderingHints(JAI.KEY_TILE_CACHE, null);
    public static final RenderingHints EXTEND_BORDER_BY_COPYING = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
    public static final RenderingHints EXTEND_BORDER_BY_REFLECT = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)2));
    private static final Dimension GEOTOOLS_DEFAULT_TILE_SIZE = new Dimension(512, 512);
    private static final int GEOTOOLS_MIN_TILE_SIZE = 256;
    private static final int STRIPE_SIZE = 64;
    private static final String[] INTERPOLATION_NAMES = new String[]{"Nearest", "NearestNeighbor", "Bilinear", "Bicubic", "Bicubic2"};
    private static final int[] INTERPOLATION_TYPES = new int[]{0, 0, 1, 2, 3};
    private static final boolean PROPOSED_REPLACEMENT = false;

    private ImageUtilities() {
    }

    public static ImageLayout getImageLayout(RenderedImage image) {
        return ImageUtilities.getImageLayout(image, true);
    }

    private static ImageLayout getImageLayout(RenderedImage image, boolean initToImage) {
        ImageLayout layout;
        if (image == null) {
            return null;
        }
        ImageLayout imageLayout = layout = initToImage ? new ImageLayout(image) : null;
        if (!(image.getNumXTiles() != 1 && image.getTileWidth() > 64 || image.getNumYTiles() != 1 && image.getTileHeight() > 64)) {
            int s;
            Dimension defaultSize;
            if (layout != null) {
                layout = layout.unsetTileLayout();
            }
            if ((defaultSize = JAI.getDefaultTileSize()) == null) {
                defaultSize = GEOTOOLS_DEFAULT_TILE_SIZE;
            }
            if ((s = ImageUtilities.toTileSize(image.getWidth(), defaultSize.width)) != 0) {
                if (layout == null) {
                    layout = new ImageLayout();
                }
                layout = layout.setTileWidth(s);
                layout.setTileGridXOffset(image.getMinX());
            }
            if ((s = ImageUtilities.toTileSize(image.getHeight(), defaultSize.height)) != 0) {
                if (layout == null) {
                    layout = new ImageLayout();
                }
                layout = layout.setTileHeight(s);
                layout.setTileGridYOffset(image.getMinY());
            }
        }
        return layout;
    }

    public static RenderingHints getRenderingHints(RenderedImage image) {
        ImageLayout layout = ImageUtilities.getImageLayout(image, false);
        return layout != null ? new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout) : null;
    }

    public static Dimension toTileSize(Dimension size) {
        int s;
        Dimension defaultSize = JAI.getDefaultTileSize();
        if (defaultSize == null) {
            defaultSize = GEOTOOLS_DEFAULT_TILE_SIZE;
        }
        if ((s = ImageUtilities.toTileSize(size.width, defaultSize.width)) != 0) {
            size.width = s;
        }
        if ((s = ImageUtilities.toTileSize(size.height, defaultSize.height)) != 0) {
            size.height = s;
        }
        return size;
    }

    private static int toTileSize(int imageSize, int tileSize) {
        int MAX_TILE_SIZE = Math.min(tileSize * 2, imageSize);
        int stop = Math.max(tileSize - 256, MAX_TILE_SIZE - tileSize);
        int sopt = 0;
        int rmax = 0;
        for (int i = 0; i <= stop; ++i) {
            int r;
            int s = tileSize + i;
            if (s <= MAX_TILE_SIZE) {
                r = imageSize % s;
                if (r == 0) {
                    return s;
                }
                if (r > rmax) {
                    rmax = r;
                    sopt = s;
                }
            }
            if ((s = tileSize - i) < 256) continue;
            r = imageSize % s;
            if (r == 0) {
                return s;
            }
            if (r <= rmax) continue;
            rmax = r;
            sopt = s;
        }
        return rmax >= tileSize - tileSize / 4 ? sopt : 0;
    }

    public static ImageLayout createIntersection(ImageLayout layout, List sources) {
        int n;
        ImageLayout result = layout;
        if (result == null) {
            result = new ImageLayout();
        }
        if ((n = sources.size()) != 0) {
            RenderedImage source = (RenderedImage)sources.get(0);
            int minXL = result.getMinX(source);
            int minYL = result.getMinY(source);
            int maxXL = result.getWidth(source) + minXL;
            int maxYL = result.getHeight(source) + minYL;
            for (int i = 0; i < n; ++i) {
                source = (RenderedImage)sources.get(i);
                int minX = source.getMinX();
                int minY = source.getMinY();
                int maxX = source.getWidth() + minX;
                int maxY = source.getHeight() + minY;
                int mask = 0;
                if (minXL < minX) {
                    mask |= 5;
                }
                if (minYL < minY) {
                    mask |= 0xA;
                }
                if (maxXL > maxX) {
                    mask |= 4;
                }
                if (maxYL > maxY) {
                    mask |= 8;
                }
                if (mask == 0) continue;
                if (layout == result) {
                    result = (ImageLayout)layout.clone();
                }
                if ((mask & 1) != 0) {
                    minXL = minX;
                    result.setMinX(minXL);
                }
                if ((mask & 2) != 0) {
                    minYL = minY;
                    result.setMinY(minYL);
                }
                if ((mask & 4) != 0) {
                    maxXL = maxX;
                    result.setWidth(maxXL - minXL);
                }
                if ((mask & 8) == 0) continue;
                maxYL = maxY;
                result.setHeight(maxYL - minYL);
            }
            if (result != layout) {
                int newSize;
                int oldSize;
                source = (RenderedImage)sources.get(0);
                if (result.isValid(64) && (oldSize = result.getTileWidth(source)) != (newSize = ImageUtilities.toTileSize(result.getWidth(source), oldSize))) {
                    result.setTileWidth(newSize);
                }
                if (result.isValid(128) && (oldSize = result.getTileHeight(source)) != (newSize = ImageUtilities.toTileSize(result.getHeight(source), oldSize))) {
                    result.setTileHeight(newSize);
                }
            }
        }
        return result;
    }

    public static Interpolation toInterpolation(Object type) throws IllegalArgumentException {
        if (type instanceof Interpolation) {
            return (Interpolation)type;
        }
        if (type instanceof CharSequence) {
            String name = type.toString();
            int length = INTERPOLATION_NAMES.length;
            for (int i = 0; i < length; ++i) {
                if (!INTERPOLATION_NAMES[i].equalsIgnoreCase(name)) continue;
                return Interpolation.getInstance((int)INTERPOLATION_TYPES[i]);
            }
        }
        throw new IllegalArgumentException(Errors.format(132, type));
    }

    public static String getInterpolationName(Interpolation interp) {
        String prefix = "Interpolation";
        for (Class<?> classe = interp.getClass(); classe != null; classe = classe.getSuperclass()) {
            String name = Utilities.getShortName(classe);
            int index = name.lastIndexOf("Interpolation");
            if (index < 0) continue;
            return name.substring(index + "Interpolation".length());
        }
        return Utilities.getShortClassName(interp);
    }

    public static synchronized void allowNativeCodec(String format, boolean writer, boolean allowed) {
        ImageReaderWriterSpi standard = null;
        ImageReaderWriterSpi codeclib = null;
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Class clazz = writer ? ImageWriterSpi.class : ImageReaderSpi.class;
        Class category = clazz;
        Iterator it = registry.getServiceProviders(category, false);
        block0: while (it.hasNext()) {
            ImageReaderWriterSpi provider = (ImageReaderWriterSpi)it.next();
            String[] formats = provider.getFormatNames();
            for (int i = 0; i < formats.length; ++i) {
                if (!formats[i].equalsIgnoreCase(format)) continue;
                if (Utilities.getShortClassName(provider).startsWith("CLib")) {
                    codeclib = provider;
                    continue block0;
                }
                standard = provider;
                continue block0;
            }
        }
        if (standard != null && codeclib != null) {
            if (allowed) {
                registry.setOrdering(category, codeclib, standard);
            } else {
                registry.setOrdering(category, standard, codeclib);
            }
        }
    }

    public static RenderedOp tileImage(RenderedOp image) throws IOException {
        ImageReader reader;
        int width = image.getWidth();
        int height = image.getHeight();
        int tileHeight = image.getTileHeight();
        int tileWidth = image.getTileWidth();
        boolean needToTile = false;
        Object o = image.getProperty("JAI.ImageReader");
        if (o instanceof ImageReader && !(reader = (ImageReader)o).isImageTiled(0)) {
            needToTile = true;
        }
        if (!needToTile && tileWidth == width && tileHeight <= height) {
            needToTile = true;
        }
        if (needToTile) {
            ImageLayout layout = ImageUtilities.getImageLayout((RenderedImage)image);
            layout.unsetValid(768);
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            ParameterBlockJAI pbjFormat = new ParameterBlockJAI("Format");
            pbjFormat.addSource((Object)image);
            pbjFormat.setParameter("dataType", image.getSampleModel().getDataType());
            return JAI.create((String)"Format", (ParameterBlock)pbjFormat, (RenderingHints)hints);
        }
        return image;
    }

    public static PlanarImage rescale2Byte(PlanarImage surrogateImage) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(surrogateImage);
        pb.add(null);
        pb.add(1);
        pb.add(1);
        double[][] extrema = (double[][])JAI.create((String)"extrema", (ParameterBlock)pb).getProperty("extrema");
        pb.removeSources();
        pb.removeParameters();
        pb.addSource(surrogateImage);
        double[] scale = new double[extrema[0].length];
        double[] offset = new double[extrema[0].length];
        int length = extrema[0].length;
        for (int i = 0; i < length; ++i) {
            scale[i] = 255.0 / (extrema[1][i] - extrema[0][i]);
            offset[i] = -(255.0 * extrema[0][i] / (extrema[1][i] - extrema[0][i]));
        }
        pb.add(scale);
        pb.add(offset);
        RenderedOp image2return = JAI.create((String)"rescale", (ParameterBlock)pb);
        ImageLayout layout = new ImageLayout((RenderedImage)image2return);
        Dimension tileSize = ImageUtilities.toTileSize(new Dimension(image2return.getWidth(), image2return.getHeight()));
        layout.setTileGridXOffset(0);
        layout.setTileGridYOffset(0);
        layout.setTileHeight((int)tileSize.getWidth());
        layout.setTileWidth((int)tileSize.getHeight());
        pb.removeParameters();
        pb.removeSources();
        pb.addSource(image2return);
        pb.add(0);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return JAI.create((String)"format", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static PlanarImage RGBIndexColorModel(PlanarImage sourceImage) {
        if (sourceImage.getColorModel() instanceof IndexColorModel) {
            return sourceImage;
        }
        KernelJAI ditherMask = KernelJAI.ERROR_FILTER_FLOYD_STEINBERG;
        ColorCube colorMap = ColorCube.BYTE_496;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(sourceImage);
        pb.add(colorMap);
        pb.add(ditherMask);
        ImageLayout layout = ImageUtilities.getImageLayout((RenderedImage)sourceImage);
        layout.unsetValid(512);
        layout.unsetValid(256);
        return JAI.create((String)"ErrorDiffusion", (ParameterBlock)pb, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
    }

    public static final PlanarImage direct2ComponentColorModel(PlanarImage sourceImage) {
        ColorModel cm = sourceImage.getColorModel();
        if (!(cm instanceof DirectColorModel)) {
            return null;
        }
        ParameterBlockJAI pb = new ParameterBlockJAI("Format");
        pb.addSource((Object)sourceImage);
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), cm.hasAlpha(), cm.isAlphaPremultiplied(), cm.getTransparency(), 0);
        pb.setParameter("dataType", 0);
        ImageLayout layout = ImageUtilities.getImageLayout((RenderedImage)sourceImage);
        layout.setColorModel((ColorModel)colorModel);
        layout.setSampleModel(colorModel.createCompatibleSampleModel(sourceImage.getWidth(), sourceImage.getHeight()));
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return JAI.create((String)"Format", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static final RenderedOp binarizeImageExt(RenderedImage source, double threshold, boolean cacheMe) {
        SampleModel sm = source.getSampleModel();
        if (sm.getNumBands() != 1) {
            ParameterBlockJAI pbjBandSelect = new ParameterBlockJAI("BandSelect");
            pbjBandSelect.addSource((Object)source);
            pbjBandSelect.setParameter("bandIndices", (Object)new int[]{0});
            source = JAI.create((String)"BandSelect", (ParameterBlock)pbjBandSelect, (RenderingHints)new RenderingHints(JAI.KEY_TILE_CACHE, null));
        }
        if (threshold >= 1.0 && ImageUtil.isBinary((SampleModel)sm)) {
            return NullDescriptor.create((RenderedImage)source, (RenderingHints)(cacheMe ? null : new RenderingHints(JAI.KEY_TILE_CACHE, null)));
        }
        ParameterBlockJAI pbj = new ParameterBlockJAI("binarize");
        pbj.addSource((Object)source);
        pbj.setParameter("threshold", threshold);
        return JAI.create((String)"binarize", (ParameterBlock)pbj, (RenderingHints)(cacheMe ? null : new RenderingHints(JAI.KEY_TILE_CACHE, null)));
    }

    public static ROI roiExt(RenderedOp image, double threshold, boolean cache) {
        RenderedOp ihs = ImageUtilities.bandCombineSimple(image, cache);
        RenderedOp i = ImageUtilities.selectBand((RenderedImage)ihs, cache);
        RenderedOp bin = ImageUtilities.binarizeImageExt((RenderedImage)i, threshold, cache);
        return new ROI((RenderedImage)bin, (int)threshold);
    }

    public static final RenderedOp bandCombineSimple(RenderedOp image, boolean cache) {
        int i;
        boolean hasAlpha;
        ColorModel cm = image.getColorModel();
        if (cm instanceof IndexColorModel) {
            image = ImageUtilities.reformatColorModel2ComponentColorModel((PlanarImage)image);
            cm = image.getColorModel();
        }
        int numBands = cm.getNumComponents();
        int numColorBands = cm.getNumColorComponents();
        boolean bl = hasAlpha = cm.hasAlpha() && numColorBands - numBands > 0;
        if (numBands == 1) {
            return image;
        }
        if (numColorBands == 1 && hasAlpha) {
            return BandSelectDescriptor.create((RenderedImage)image, (int[])new int[]{0}, (RenderingHints)(cache ? null : new RenderingHints(JAI.KEY_TILE_CACHE, null)));
        }
        if (hasAlpha) {
            int[] bands = new int[numColorBands];
            for (i = 0; i < numColorBands; ++i) {
                bands[i] = i;
            }
            image = BandSelectDescriptor.create((RenderedImage)image, (int[])bands, null);
        }
        double[][] coeff = new double[1][numColorBands + 1];
        for (i = 0; i < numColorBands; ++i) {
            coeff[0][i] = 1.0 / (double)numColorBands;
        }
        return BandCombineDescriptor.create((RenderedImage)image, (double[][])coeff, (RenderingHints)(cache ? null : new RenderingHints(JAI.KEY_TILE_CACHE, null)));
    }

    public static final RenderedOp selectBand(RenderedImage image, boolean cache) {
        ColorModel cm = image.getColorModel();
        if (cm.getNumComponents() <= 1 || !(cm.getColorSpace() instanceof IHSColorSpace)) {
            return image instanceof RenderedOp ? (RenderedOp)image : NullDescriptor.create((RenderedImage)image, null);
        }
        if (cache) {
            return BandSelectDescriptor.create((RenderedImage)image, (int[])new int[]{0}, null);
        }
        return BandSelectDescriptor.create((RenderedImage)image, (int[])new int[]{0}, (RenderingHints)new RenderingHints(JAI.KEY_TILE_CACHE, null));
    }

    public static RenderedOp convertIHS(RenderedImage image, boolean cache) {
        ColorSpace cs;
        int colorSpaceType;
        ColorModel cm = image.getColorModel();
        if (!(cm instanceof ComponentColorModel)) {
            ImageWorker worker = new ImageWorker(image);
            if (!cache) {
                worker.setRenderingHint(JAI.KEY_TILE_CACHE, null);
            }
            worker.forceComponentColorModel();
            image = worker.getRenderedImage();
        }
        if ((colorSpaceType = (cs = cm.getColorSpace()).getType()) == 1003 || colorSpaceType == 6 || cs instanceof IHSColorSpace) {
            return image instanceof RenderedOp ? (RenderedOp)image : NullDescriptor.create((RenderedImage)image, null);
        }
        ComponentColorModel newCm = new ComponentColorModel((ColorSpace)IHSColorSpace.getInstance(), false, false, cm.getTransparency(), cm.getTransferType());
        ParameterBlockJAI pbjCC = new ParameterBlockJAI("colorconvert");
        pbjCC.addSource((Object)image);
        pbjCC.setParameter("colorModel", (Object)newCm);
        if (cache) {
            return JAI.create((String)"colorconvert", (ParameterBlock)pbjCC);
        }
        return JAI.create((String)"colorconvert", (ParameterBlock)pbjCC, (RenderingHints)new RenderingHints(JAI.KEY_TILE_CACHE, null));
    }

    public static PlanarImage addTransparency2IndexColorModel(PlanarImage surrogateImage, RenderedImage alphaChannel, boolean optimizeForWritingGIF) {
        IndexColorModel cm = (IndexColorModel)surrogateImage.getColorModel();
        byte[][] rgba = new byte[3][256];
        cm.getReds(rgba[0]);
        cm.getGreens(rgba[1]);
        cm.getBlues(rgba[2]);
        IndexColorModel cm1 = new IndexColorModel(cm.getPixelSize(), 256, rgba[0], rgba[1], rgba[2], 255);
        ParameterBlockJAI pbTheshold = new ParameterBlockJAI("Threshold");
        pbTheshold.addSource((Object)alphaChannel);
        pbTheshold.setParameter("low", (Object)new double[]{1.0});
        pbTheshold.setParameter("high", (Object)new double[]{254.0});
        pbTheshold.setParameter("constants", (Object)new double[]{255.0});
        RenderedOp newAlphaChannel = JAI.create((String)"threshold", (ParameterBlock)pbTheshold, (RenderingHints)new RenderingHints(JAI.KEY_TILE_CACHE, null));
        ParameterBlockJAI pbInvert = new ParameterBlockJAI("Invert");
        pbInvert.addSource((Object)newAlphaChannel);
        RenderedOp newInvertedAlphaChannel = JAI.create((String)"Invert", (ParameterBlock)pbInvert, (RenderingHints)new RenderingHints(JAI.KEY_TILE_CACHE, null));
        ImageLayout layout = new ImageLayout((RenderedImage)surrogateImage);
        layout.setColorModel((ColorModel)cm1);
        if (optimizeForWritingGIF) {
            layout.setTileGridXOffset(surrogateImage.getMinX());
            layout.setTileGridYOffset(surrogateImage.getMinY());
            layout.setTileWidth(surrogateImage.getWidth());
            layout.setTileHeight(surrogateImage.getHeight());
        }
        RenderingHints hints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, null));
        ParameterBlockJAI pbjAdd = new ParameterBlockJAI("add");
        pbjAdd.addSource((Object)surrogateImage);
        pbjAdd.addSource((Object)newInvertedAlphaChannel);
        return JAI.create((String)"add", (ParameterBlock)pbjAdd, (RenderingHints)hints);
    }

    public static final PlanarImage componentColorModel2IndexColorModel4GIF(PlanarImage sourceImage) {
        int numBands;
        ParameterBlock pb = new ParameterBlock();
        RenderedOp alphaChannel = null;
        if (sourceImage.getSampleModel().getTransferType() != 0) {
            sourceImage = ImageUtilities.rescale2Byte(sourceImage);
        }
        if (sourceImage.getColorModel().hasAlpha()) {
            numBands = sourceImage.getSampleModel().getNumBands();
            alphaChannel = JAI.create((String)"bandSelect", (RenderedImage)sourceImage, (Object)new int[]{numBands - 1});
            sourceImage = ImageUtilities.getBandsFromImage(sourceImage, numBands);
        }
        if (sourceImage.getSampleModel().getNumBands() == 1 && alphaChannel != null) {
            numBands = sourceImage.getSampleModel().getNumBands();
            RenderedOp firstBand = JAI.create((String)"bandSelect", (RenderedImage)sourceImage, (Object)new int[]{0});
            for (int i = 0; i < 3 - numBands; ++i) {
                pb.removeParameters();
                pb.removeSources();
                pb.addSource(sourceImage);
                pb.addSource(firstBand);
                sourceImage = JAI.create((String)"bandmerge", (ParameterBlock)pb);
                pb.removeParameters();
                pb.removeSources();
            }
        }
        if (sourceImage.getSampleModel().getNumBands() == 3) {
            sourceImage = ImageUtilities.RGBIndexColorModel(sourceImage);
        }
        if (alphaChannel != null) {
            sourceImage = ImageUtilities.addTransparency2IndexColorModel(sourceImage, (RenderedImage)alphaChannel, true);
        }
        return sourceImage;
    }

    public static PlanarImage getBandsFromImage(PlanarImage surrogateImage, int numBands) {
        switch (numBands - 1) {
            case 1: {
                surrogateImage = JAI.create((String)"bandSelect", (RenderedImage)surrogateImage, (Object)new int[]{0});
                break;
            }
            case 3: {
                surrogateImage = JAI.create((String)"bandSelect", (RenderedImage)surrogateImage, (Object)new int[]{0, 1, 2});
            }
        }
        return surrogateImage;
    }

    public static final PlanarImage convertIndexColorModelAlpha4GIF(PlanarImage surrogateImage) {
        IndexColorModel cm = (IndexColorModel)surrogateImage.getColorModel();
        if (cm.getTransparency() != 3) {
            return surrogateImage;
        }
        byte[][] rgba = new byte[4][256];
        cm.getReds(rgba[0]);
        cm.getGreens(rgba[1]);
        cm.getBlues(rgba[2]);
        int transparencyIndex = -1;
        int index = -1;
        int length = cm.getMapSize();
        byte[] lookupTable = new byte[256];
        for (int i = 0; i < length; ++i) {
            if ((cm.getAlpha(i) & 0xFF) == 0) {
                if (transparencyIndex == -1) {
                    transparencyIndex = cm.getAlpha(index);
                }
                lookupTable[i] = (byte)(transparencyIndex & 0xFF);
                continue;
            }
            lookupTable[i] = (byte)(i & 0xFF);
        }
        IndexColorModel cm1 = new IndexColorModel(cm.getComponentSize(0), 256, rgba[0], rgba[1], rgba[2], transparencyIndex);
        LookupTableJAI lookUpTableJAI = new LookupTableJAI(lookupTable);
        ParameterBlockJAI pbjLookUp = new ParameterBlockJAI("LookUp");
        pbjLookUp.setParameter("table", (Object)lookUpTableJAI);
        pbjLookUp.addSource((Object)surrogateImage);
        ImageLayout layout = new ImageLayout((RenderedImage)surrogateImage);
        layout.setColorModel((ColorModel)cm1);
        layout.setTileGridXOffset(0);
        layout.setTileGridYOffset(0);
        Dimension tileSize = ImageUtilities.toTileSize(new Dimension(surrogateImage.getWidth(), surrogateImage.getHeight()));
        layout.setTileHeight((int)tileSize.getHeight());
        layout.setTileWidth((int)tileSize.getWidth());
        RenderingHints hints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, null));
        return JAI.create((String)"LookUp", (ParameterBlock)pbjLookUp, (RenderingHints)hints);
    }

    /*
     * WARNING - void declaration
     */
    public static RenderedOp reformatColorModel2ComponentColorModel(PlanarImage sourceImage) throws IllegalArgumentException {
        void var5_5;
        ColorModel cm = sourceImage.getColorModel();
        SampleModel sm = sourceImage.getSampleModel();
        if (cm instanceof ComponentColorModel) {
            return NullDescriptor.create((RenderedImage)sourceImage, (RenderingHints)new RenderingHints(JAI.KEY_TILE_CACHE, null));
        }
        ParameterBlockJAI pbjFormat = new ParameterBlockJAI("Format");
        pbjFormat.addSource((Object)sourceImage);
        pbjFormat.setParameter("dataType", sm.getTransferType());
        int transferType = cm instanceof DirectColorModel ? 0 : sm.getTransferType();
        switch (transferType) {
            case 0: {
                int numBits = 8;
                break;
            }
            case 1: {
                int numBits = 16;
                break;
            }
            case 2: {
                int numBits = 16;
                break;
            }
            case 3: {
                int numBits = 32;
                break;
            }
            case 4: {
                int numBits = 32;
                break;
            }
            case 5: {
                int numBits = 64;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type for a color model!");
            }
        }
        int transparency = cm.getTransparency();
        ComponentColorModel cm1 = transparency != 1 ? new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{var5_5, var5_5, var5_5, var5_5}, true, false, transparency, transferType) : new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{var5_5, var5_5, var5_5}, false, false, transparency, transferType);
        ImageLayout layout = ImageUtilities.getImageLayout((RenderedImage)sourceImage);
        layout.setColorModel((ColorModel)cm1);
        layout.setSampleModel(((ColorModel)cm1).createCompatibleSampleModel(sourceImage.getWidth(), sourceImage.getHeight()));
        RenderingHints hint = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return JAI.create((String)"format", (ParameterBlock)pbjFormat, (RenderingHints)hint);
    }
}

