/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.input.spi;

import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class StringImageInputStreamSpi
extends ImageInputStreamSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.stream.input");
    private static final String vendorName = "GeoSolutions";
    private static final String version = "1.0-RC1";
    private static final Class inputClass = String.class;

    public StringImageInputStreamSpi() {
        super(vendorName, version, inputClass);
    }

    public ImageInputStream createInputStreamInstance(Object input, boolean useCache, File cacheDir) throws IOException {
        if (!(input instanceof String)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("The provided input is not a valid String.");
            }
            return null;
        }
        String sourceString = (String)input;
        URL tempURL = new URL(sourceString);
        if (tempURL.getProtocol().compareToIgnoreCase("file") == 0) {
            File tempFile = new File(URLDecoder.decode(tempURL.getFile(), "UTF-8"));
            if (!tempFile.exists()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("The provided input file does not exist.");
                }
                return null;
            }
            return new FileImageInputStreamExtImpl(tempFile);
        }
        try {
            InputStream inStream = tempURL.openStream();
            if (useCache) {
                return new MemoryCacheImageInputStream(inStream);
            }
            return new FileCacheImageInputStream(inStream, cacheDir);
        }
        catch (IOException e) {
            File tempFile;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            if (!(tempFile = new File(sourceString)).exists()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("The provided input file does not exist.");
                }
                return null;
            }
            return new FileImageInputStreamExtImpl(tempFile);
        }
    }

    public String getDescription(Locale locale) {
        return "Service provider that helps connecting to the object pointed by a String";
    }
}

