/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.input.spi;

import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class URLImageInputStreamSpi
extends ImageInputStreamSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.stream.input");
    private static final String vendorName = "GeoSolutions";
    private static final String version = "1.0-RC1";
    private static final Class inputClass = URL.class;

    public URLImageInputStreamSpi() {
        super(vendorName, version, inputClass);
    }

    public ImageInputStream createInputStreamInstance(Object input, boolean useCache, File cacheDir) {
        if (!(input instanceof URL)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("The provided input is not a valid URL.");
            }
            return null;
        }
        try {
            URL sourceURL = (URL)input;
            if (sourceURL.getProtocol().compareToIgnoreCase("file") == 0) {
                File tempFile = new File(URLDecoder.decode(sourceURL.getFile(), "UTF-8"));
                if (!tempFile.exists()) {
                    return null;
                }
                return new FileImageInputStreamExtImpl(tempFile);
            }
            if (useCache) {
                return new MemoryCacheImageInputStream(sourceURL.openStream());
            }
            return new FileCacheImageInputStream(sourceURL.openStream(), cacheDir);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public String getDescription(Locale locale) {
        return "Service provider that helps connecting to the onject pointed by a URL";
    }
}

