/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.output.spi;

import com.sun.imageio.spi.FileImageOutputStreamSpi;
import it.geosolutions.imageio.stream.output.FileImageOutputStreamExtImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;

public class FileImageOutputStreamExtImplSpi
extends ImageOutputStreamSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.stream.output");
    private static final String vendorName = "-----";
    private static final String version = "-----";
    private static final Class outputClass = File.class;

    public FileImageOutputStreamExtImplSpi() {
        super("-----", "-----", outputClass);
    }

    public String getDescription(Locale locale) {
        return "Service provider that wraps a FileImageOutputStream";
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        super.onRegistration(registry, category);
        Iterator i = registry.getServiceProviders(ImageOutputStreamSpi.class, true);
        while (i.hasNext()) {
            Object other = i.next();
            if (other instanceof FileImageOutputStreamSpi) {
                registry.deregisterServiceProvider(other);
            }
            if (this == other) continue;
            registry.setOrdering(class$javax$imageio$spi$ImageOutputStreamSpi == null ? FileImageOutputStreamExtImplSpi.class$("javax.imageio.spi.ImageOutputStreamSpi") : class$javax$imageio$spi$ImageOutputStreamSpi, this, other);
        }
    }

    public ImageOutputStream createOutputStreamInstance(Object output, boolean useCache, File cacheDir) {
        try {
            return new FileImageOutputStreamExtImpl((File)output);
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }
}

