/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.io.input;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends FilterInputStream {
    int vbits = 0;
    int bitbuf = 0;
    private int bitsToRead = 8;

    public BitInputStream(InputStream in) {
        super(in);
    }

    public int getBitsToRead() {
        return this.bitsToRead;
    }

    public void setBitsToRead(int bitsToRead) {
        if (bitsToRead > 8) {
            throw new IllegalArgumentException();
        }
        this.bitsToRead = bitsToRead;
    }

    public int read() throws IOException {
        return this.read(this.bitsToRead);
    }

    public int read(int nbits) throws IOException {
        if (nbits == 0) {
            return 0;
        }
        if (nbits > 8) {
            throw new IllegalArgumentException("max 8 bits can be read at once");
        }
        if (nbits > this.vbits) {
            this.fillBuffer(nbits);
        }
        if (this.vbits == 0) {
            return -1;
        }
        int ret = this.bitbuf << 32 - this.vbits >>> 32 - nbits;
        this.vbits -= nbits;
        if (this.vbits < 0) {
            this.vbits = 0;
        }
        return ret;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (len <= 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        for (i = 1; i < len && (c = this.read()) != -1; ++i) {
            b[off + i] = (byte)c;
        }
        return i;
    }

    public void resetBuffer() {
        this.vbits = 0;
        this.bitbuf = 0;
    }

    public long skip(long n) throws IOException {
        if (this.vbits == 0) {
            return this.in.skip(n);
        }
        int b = (this.vbits + 8) / 8;
        this.in.skip(n - (long)b);
        int vbits = this.vbits;
        this.resetBuffer();
        this.fillBuffer(vbits);
        return n;
    }

    private void fillBuffer(int nbits) throws IOException {
        int c;
        while (this.vbits < nbits && (c = this.in.read()) != -1) {
            this.bitbuf = (this.bitbuf << 8) + (c & 0xFF);
            this.vbits += 8;
        }
    }

    public int getBitOffset() {
        return 7 - this.vbits % 8;
    }
}

