/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import org.geotools.data.FIDReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.indexed.IndexedFidReader;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.data.shapefile.indexed.RecordNumberTracker;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.renderer.shape.MultiLineHandler;
import org.geotools.renderer.shape.MultiPointHandler;
import org.geotools.renderer.shape.PointHandler;
import org.geotools.renderer.shape.PolygonHandler;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ShapefileRendererUtil {
    public static ShapefileReader getShpReader(ShapefileDataStore ds, Envelope bbox, Rectangle screenSize, MathTransform mt, boolean hasOpacity) throws IOException, TransformException {
        ShapefileReader reader = ds.openShapeReader();
        ShapeType type = reader.getHeader().getShapeType();
        if (type == ShapeType.ARC || type == ShapeType.ARCM || type == ShapeType.ARCZ) {
            reader.setHandler((ShapeHandler)new MultiLineHandler(type, bbox, mt, hasOpacity, screenSize));
        }
        if (type == ShapeType.POLYGON || type == ShapeType.POLYGONM || type == ShapeType.POLYGONZ) {
            reader.setHandler((ShapeHandler)new PolygonHandler(type, bbox, mt, hasOpacity));
        }
        if (type == ShapeType.POINT || type == ShapeType.POINTM || type == ShapeType.POINTZ) {
            reader.setHandler((ShapeHandler)new PointHandler(type, bbox, screenSize, mt, hasOpacity));
        }
        if (type == ShapeType.MULTIPOINT || type == ShapeType.MULTIPOINTM || type == ShapeType.MULTIPOINTZ) {
            reader.setHandler((ShapeHandler)new MultiPointHandler(type, bbox, screenSize, mt, hasOpacity));
        }
        return reader;
    }

    public static IndexedDbaseFileReader getDBFReader(ShapefileDataStore ds) throws IOException {
        return new IndexedDbaseFileReader(ds.getReadChannel(ds.dbfURL), true, ds.getStringCharset());
    }

    public static ReadableByteChannel getShpReadChannel(ShapefileDataStore ds) throws IOException {
        return ds.getReadChannel(ds.shpURL);
    }

    public static URL getshpURL(ShapefileDataStore ds) {
        return ds.shpURL;
    }

    public static FIDReader getFidReader(ShapefileDataStore datastore, RecordNumberTracker tracker) throws MalformedURLException {
        if (datastore instanceof IndexedShapefileDataStore) {
            IndexedShapefileDataStore ids = (IndexedShapefileDataStore)datastore;
            if (ids.fixURL == null) {
                return ShapefileRendererUtil.createBasicFidReader(datastore, tracker);
            }
            try {
                return new IndexedFidReader(datastore.getCurrentTypeName(), tracker, datastore.getReadChannel(ids.fixURL));
            }
            catch (Exception e) {
                return ShapefileRendererUtil.createBasicFidReader(datastore, tracker);
            }
        }
        return ShapefileRendererUtil.createBasicFidReader(datastore, tracker);
    }

    private static FIDReader createBasicFidReader(ShapefileDataStore datastore, final RecordNumberTracker tracker) {
        final String typename = datastore.getCurrentTypeName() + ".";
        return new FIDReader(){
            int i = 0;
            boolean closed = false;

            public void close() throws IOException {
                this.closed = true;
            }

            public boolean hasNext() throws IOException {
                return !this.closed;
            }

            public String next() throws IOException {
                if (this.closed) {
                    throw new IllegalStateException("Reader is closed");
                }
                ++this.i;
                return typename + tracker.getRecordNumber();
            }
        };
    }
}

