/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.data;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LiteralExpression;

public class FilterExample {
    private static URL getResource(String path) {
        return FilterExample.class.getResource(path);
    }

    public static void main(String[] args) {
        try {
            FilterExample.polygonIntersectsPoint();
        }
        catch (Exception e) {
            System.out.println("Ops! Something went wrong :-(");
            e.printStackTrace();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void polygonIntersectsPoint() throws IOException, FactoryConfigurationError {
        block5: {
            URL url = FilterExample.getResource("test-data/bc_2m_lakes.shp");
            HashMap<String, URL> params = new HashMap<String, URL>();
            params.put("url", url);
            DataStore dataStore = DataStoreFinder.getDataStore(params);
            String typeName = dataStore.getTypeNames()[0];
            FeatureSource featureSource = dataStore.getFeatureSource(typeName);
            FilterFactory filterFactory = FilterFactoryFinder.createFilterFactory();
            String geometryName = featureSource.getSchema().getDefaultGeometry().getName();
            AttributeExpression geometryExpression = filterFactory.createAttributeExpression(geometryName);
            Coordinate pointCoordinate = new Coordinate(-116.883011765104, 50.0001019506261);
            GeometryFactory geometryFactory = new GeometryFactory();
            Point point = geometryFactory.createPoint(pointCoordinate);
            LiteralExpression pointExpression = filterFactory.createLiteralExpression();
            pointExpression.setLiteral((Object)point);
            GeometryFilter withinFilter = filterFactory.createGeometryFilter((short)7);
            withinFilter.addLeftGeometry((Expression)geometryExpression);
            withinFilter.addRightGeometry((Expression)pointExpression);
            FeatureCollection featureCollection = featureSource.getFeatures((Filter)withinFilter);
            Iterator iterator = featureCollection.iterator();
            try {
                int count = 0;
                if (iterator.hasNext()) {
                    while (iterator.hasNext()) {
                        Feature feature = (Feature)iterator.next();
                        System.out.println(feature);
                        if (++count != 10) continue;
                        break block5;
                    }
                    break block5;
                }
                System.out.println("Point not found in any Polygons.");
            }
            finally {
                featureCollection.close(iterator);
            }
        }
    }
}

