/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.data;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JFileChooser;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.demo.data.SimpleFileFilter;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;

public class ShapeReader {
    private static URL getResource(String path) {
        return ShapeReader.class.getResource(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Feature feature;
            int count;
            int i;
            URL url = null;
            url = args.length == 1 ? ShapeReader.getResource(args[0]) : ShapeReader.openURL();
            DataStore dataStore = ShapeReader.openShapefile3(url);
            String typeName = dataStore.getTypeNames()[0];
            FeatureSource featureSource = dataStore.getFeatureSource(typeName);
            FeatureCollection featureCollection = featureSource.getFeatures();
            FeatureType featureType = featureSource.getSchema();
            System.out.println("FID\t");
            for (i = 0; i < featureType.getAttributeCount(); ++i) {
                AttributeType attributeType = featureType.getAttributeType(i);
                if (attributeType instanceof GeometryAttributeType) continue;
                System.out.print(attributeType.getType().getName() + "\t");
            }
            System.out.println();
            for (i = 0; i < featureType.getAttributeCount(); ++i) {
                AttributeType at = featureType.getAttributeType(i);
                if (!(at instanceof GeometryAttributeType)) continue;
                System.out.print(at.getName() + "\t");
            }
            System.out.println();
            Iterator iterator = featureCollection.iterator();
            try {
                count = 0;
                while (iterator.hasNext()) {
                    feature = (Feature)iterator.next();
                    System.out.print(feature.getID() + "\t");
                    for (int i2 = 0; i2 < feature.getNumberOfAttributes(); ++i2) {
                        Object attribute = feature.getAttribute(i2);
                        if (attribute instanceof Geometry) continue;
                        System.out.print(attribute + "\t");
                    }
                    System.out.println();
                    if (count == 10) {
                        break;
                    }
                    ++count;
                }
            }
            finally {
                featureCollection.close(iterator);
            }
            System.out.println();
            iterator = featureCollection.iterator();
            try {
                count = 0;
                while (iterator.hasNext()) {
                    feature = (Feature)iterator.next();
                    System.out.print(feature.getID() + "\t");
                    System.out.println(feature.getDefaultGeometry());
                    System.out.println();
                    if (count == 10) {
                        break;
                    }
                    ++count;
                }
            }
            finally {
                featureCollection.close(iterator);
            }
        }
        catch (Exception e) {
            System.out.println("Ops! Something went wrong :-(");
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static URL openURL() throws MalformedURLException {
        URL shapeURL = null;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new SimpleFileFilter("shp", "Shapefile"));
        int result = fileChooser.showOpenDialog(null);
        if (result == 0) {
            File f = fileChooser.getSelectedFile();
            shapeURL = f.toURL();
        } else {
            System.out.println("Goodbye");
            System.exit(0);
        }
        return shapeURL;
    }

    public static ShapefileDataStore openShapefile(URL shapeURL) throws MalformedURLException {
        return new ShapefileDataStore(shapeURL);
    }

    public static DataStore openShapefile2(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put("url", url);
        DataStoreFactorySpi found = null;
        Iterator iterator = DataStoreFinder.getAvailableDataStores();
        while (iterator.hasNext()) {
            DataStoreFactorySpi factory = (DataStoreFactorySpi)iterator.next();
            if (!factory.canProcess(params)) continue;
            System.out.println(factory.getDisplayName() + ":(" + factory.getDescription() + ")");
            found = factory;
        }
        if (found != null) {
            System.out.println("Using " + found.getDisplayName());
            DataStoreFactorySpi.Param[] parameters = found.getParametersInfo();
            for (int i = 0; i < parameters.length; ++i) {
                System.out.print(parameters[i]);
            }
            return found.createDataStore(params);
        }
        throw new IOException("Could not connect to:" + params);
    }

    public static DataStore openShapefile3(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put("url", url);
        return DataStoreFinder.getDataStore(params);
    }
}

