/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.data;

import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.demo.data.SimpleFileFilter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapeReprojector {
    private static URL getResource(String path) {
        return ShapeReprojector.class.getClassLoader().getResource(path);
    }

    public static void main(String[] args) {
        try {
            URL shapeURL = null;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Choose a shapefile, or press cancel to use the default one");
            fileChooser.setFileFilter(new SimpleFileFilter("shp", "Shapefile"));
            int result = fileChooser.showOpenDialog(null);
            if (result == 0) {
                File f = fileChooser.getSelectedFile();
                shapeURL = f.toURL();
            } else {
                shapeURL = ShapeReprojector.getResource("org/geotools/sampleData/statepop.shp");
            }
            DefaultGeographicCRS originCrs = DefaultGeographicCRS.WGS84;
            CoordinateReferenceSystem destCrs = CRS.decode((String)"AUTO:42001,0.0,0.0");
            System.out.println("Origin CRS: " + originCrs);
            System.out.println("Destination CRS: " + destCrs);
            ShapefileDataStore store = new ShapefileDataStore(shapeURL);
            String name = store.getTypeNames()[0];
            DefaultQuery q = new DefaultQuery(name);
            q.setCoordinateSystem((CoordinateReferenceSystem)originCrs);
            q.setCoordinateSystemReproject(destCrs);
            FeatureSource reprojectedSource = store.getView((Query)q);
            result = fileChooser.showSaveDialog(null);
            if (result != 0) {
                return;
            }
            File f = fileChooser.getSelectedFile();
            if (!f.getName().toLowerCase().endsWith(".shp")) {
                f = new File(f.getAbsolutePath() + ".shp");
            }
            ShapefileDataStore dest = new ShapefileDataStore(f.toURL());
            dest.createSchema(reprojectedSource.getSchema());
            FeatureStore writer = (FeatureStore)dest.getFeatureSource();
            writer.setFeatures(reprojectedSource.getFeatures().reader());
            System.out.println("Reprojected shapefile " + f.getAbsolutePath() + " successfully written");
        }
        catch (Exception e) {
            System.out.println("Ops! Something went wrong :-(");
            e.printStackTrace();
        }
        System.exit(0);
    }
}

