/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.attributeio.WKTAttributeIO;
import org.geotools.data.mysql.MySQLConnectionFactory;
import org.geotools.data.mysql.MySQLFeatureWriter;
import org.geotools.data.mysql.MySQLSQLBuilder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoderMySQL;

public class MySQLDataStore
extends JDBCDataStore {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.mysql");

    public MySQLDataStore(ConnectionPool connectionPool) throws IOException {
        this(connectionPool, null);
    }

    public MySQLDataStore(ConnectionPool connectionPool, String databaseSchemaName) throws IOException {
        this(connectionPool, databaseSchemaName, null);
    }

    public MySQLDataStore(ConnectionPool connectionPool, String databaseSchemaName, String namespace) throws IOException {
        super(connectionPool, JDBCDataStoreConfig.createWithNameSpaceAndSchemaName((String)namespace, (String)databaseSchemaName));
    }

    public static MySQLDataStore getInstance(String host, String schema, String username, String password) throws IOException, SQLException {
        return MySQLDataStore.getInstance(host, 3306, schema, username, password);
    }

    public static MySQLDataStore getInstance(String host, int port, String schema, String username, String password) throws IOException, SQLException {
        return new MySQLDataStore(new MySQLConnectionFactory(host, port, schema).getConnectionPool(username, password));
    }

    public FeatureWriter getFeatureWriter(String typeName) throws IOException {
        return this.getFeatureWriter(typeName, Filter.NONE, Transaction.AUTO_COMMIT);
    }

    public FeatureWriter getFeatureWriterAppend(String typeName) throws IOException {
        return this.getFeatureWriterAppend(typeName, Transaction.AUTO_COMMIT);
    }

    protected AttributeType buildAttributeType(ResultSet rs) throws IOException {
        int COLUMN_NAME = 4;
        int DATA_TYPE = 5;
        int TYPE_NAME = 6;
        try {
            int dataType = rs.getInt(5);
            if (dataType == 1111) {
                String typeName = rs.getString(6);
                String typeNameLower = typeName.toLowerCase();
                if ("geometry".equals(typeNameLower)) {
                    return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)Geometry.class);
                }
                if ("point".equals(typeNameLower)) {
                    return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)Point.class);
                }
                if ("linestring".equals(typeNameLower)) {
                    return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)LineString.class);
                }
                if ("polygon".equals(typeNameLower)) {
                    return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)Polygon.class);
                }
                if ("multipoint".equals(typeNameLower)) {
                    return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)MultiPoint.class);
                }
                if ("multilinestring".equals(typeNameLower)) {
                    return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)MultiLineString.class);
                }
                if ("multipolygon".equals(typeNameLower)) {
                    return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)MultiPolygon.class);
                }
                if ("geometrycollection".equals(typeNameLower)) {
                    return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)GeometryCollection.class);
                }
                return super.buildAttributeType(rs);
            }
            return super.buildAttributeType(rs);
        }
        catch (SQLException e) {
            throw new IOException("SQL exception occurred: " + e.getMessage());
        }
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        SQLEncoderMySQL encoder = new SQLEncoderMySQL();
        encoder.setFIDMapper(this.getFIDMapper(typeName));
        return new MySQLSQLBuilder(encoder, this.getSchema(typeName));
    }

    protected AttributeIO getGeometryAttributeIO(AttributeType type, QueryData queryData) {
        return new WKTAttributeIO();
    }

    protected JDBCFeatureWriter createFeatureWriter(FeatureReader reader, QueryData queryData) throws IOException {
        LOGGER.fine("returning jdbc feature writer");
        return new MySQLFeatureWriter(reader, queryData);
    }
}

