/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.mysql.MySQLConnectionFactory;
import org.geotools.data.mysql.MySQLDataStore;

public class MySQLDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOGGER = Logger.getLogger(MySQLDataStoreFactory.class.getName());
    private static final String DRIVER_CLASS = "com.mysql.jdbc.Driver";
    static final DataStoreFactorySpi.Param DBTYPE = new DataStoreFactorySpi.Param("dbtype", String.class, "must be 'mysql'", true, (Object)"mysql");
    static final DataStoreFactorySpi.Param HOST = new DataStoreFactorySpi.Param("host", String.class, "mysql host machine", true, (Object)"localhost");
    static final DataStoreFactorySpi.Param PORT = new DataStoreFactorySpi.Param("port", String.class, "mysql connection port", true, (Object)"3306");
    static final DataStoreFactorySpi.Param DATABASE = new DataStoreFactorySpi.Param("database", String.class, "msyql database");
    static final DataStoreFactorySpi.Param USER = new DataStoreFactorySpi.Param("user", String.class, "user name to login as", false);
    static final DataStoreFactorySpi.Param PASSWD = new DataStoreFactorySpi.Param("passwd", String.class, "password used to login", false);
    static final DataStoreFactorySpi.Param NAMESPACE = new DataStoreFactorySpi.Param("namespace", String.class, "namespace prefix used", false);
    static final DataStoreFactorySpi.Param[] arrayParameters = new DataStoreFactorySpi.Param[]{DBTYPE, HOST, PORT, DATABASE, USER, PASSWD, NAMESPACE};

    public boolean canProcess(Map params) {
        if (params != null) {
            for (int i = 0; i < arrayParameters.length; ++i) {
                Object value = params.get(MySQLDataStoreFactory.arrayParameters[i].key);
                if (value != null && MySQLDataStoreFactory.arrayParameters[i].type.isInstance(value) || !MySQLDataStoreFactory.arrayParameters[i].required) continue;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Failed on : " + MySQLDataStoreFactory.arrayParameters[i].key + ", full " + "params= " + params.toString());
                }
                return false;
            }
        } else {
            return false;
        }
        return ((String)params.get("dbtype")).equalsIgnoreCase("mysql");
    }

    public DataStore createDataStore(Map params) throws IOException {
        ConnectionPool pool;
        String host = (String)HOST.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        String port = (String)PORT.lookUp(params);
        String database = (String)DATABASE.lookUp(params);
        String namespace = (String)NAMESPACE.lookUp(params);
        if (!this.canProcess(params)) {
            LOGGER.warning("Can not process : " + params);
            throw new IOException("The parameteres map isn't correct!!");
        }
        MySQLConnectionFactory connFact = new MySQLConnectionFactory(host, new Integer(port), database);
        connFact.setLogin(user, passwd);
        try {
            pool = connFact.getConnectionPool();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not create connection to MySQL database.", e);
            throw new DataSourceException("Could not create connection", (Throwable)e);
        }
        if (namespace != null) {
            return new MySQLDataStore(pool, namespace);
        }
        return new MySQLDataStore(pool);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("MySQL cannot create a new Database");
    }

    public String getDisplayName() {
        return "MySQL";
    }

    public String getDescription() {
        return "MySQL Database";
    }

    public boolean isAvailable() {
        try {
            Class.forName(DRIVER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.warning("MySQL data sources are not available: " + cnfe.getMessage());
            return false;
        }
        return true;
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{DBTYPE, HOST, PORT, DATABASE, USER, PASSWD, NAMESPACE};
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

