/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.JDBCTextFeatureWriter;
import org.geotools.data.jdbc.QueryData;

public class MySQLFeatureWriter
extends JDBCTextFeatureWriter {
    private static WKTWriter geometryWriter = new WKTWriter();

    public MySQLFeatureWriter(FeatureReader fReader, QueryData queryData) throws IOException {
        super(fReader, queryData);
    }

    protected String getGeometryInsertText(Geometry geom, int srid) {
        if (geom == null) {
            return "NULL";
        }
        String geoText = geometryWriter.write(geom);
        String sql = null;
        sql = GeometryCollection.class.isAssignableFrom(geom.getClass()) ? (MultiPoint.class.isAssignableFrom(geom.getClass()) ? "MultiPointFromText" : (MultiLineString.class.isAssignableFrom(geom.getClass()) ? "MultiLineStringFromText" : (MultiPolygon.class.isAssignableFrom(geom.getClass()) ? "MultiPolygonFromText" : "GeometryCollectionFromText"))) : (Point.class.isAssignableFrom(geom.getClass()) ? "PointFromText" : (LineString.class.isAssignableFrom(geom.getClass()) ? "LineStringFromText" : (Polygon.class.isAssignableFrom(geom.getClass()) ? "PolygonFromText" : "GeometryFromText")));
        sql = sql + "('" + geoText + "', " + srid + ")";
        return sql;
    }
}

