/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

public class MysqlConnection
implements DataSource {
    private static final String MYSQL_DRIVER_CLASS = "org.gjt.mm.mysql.Driver";
    private static final String MYSQL_DRIVER_PATH = "jdbc:mysql";
    private String host;
    private String port;
    private String dbName;
    private String user = null;
    private String password = null;

    public MysqlConnection(String host, String port, String dbName) {
        this.host = host;
        this.port = port;
        this.dbName = dbName;
    }

    public void setLogin(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public String getLoginUser() {
        return this.user;
    }

    public String getLoginPassword() {
        return this.password;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        String connectionPath = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName;
        Connection dbConnection = null;
        try {
            Class.forName(MYSQL_DRIVER_CLASS);
            dbConnection = DriverManager.getConnection(connectionPath, user, password);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Mysql driver was not found.");
        }
        return dbConnection;
    }

    public int getLoginTimeout() {
        return 10;
    }

    public void setLoginTimeout(int seconds) {
    }

    public PrintWriter getLogWriter() {
        return new PrintWriter(System.out);
    }

    public void setLogWriter(PrintWriter out) {
    }
}

