/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gml;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.net.URI;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.referencing.CRS;
import org.geotools.xml.gml.FCBuffer;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.SAXException;

public class FileGMLDataStore
extends AbstractDataStore {
    private URI uri;
    private volatile FCBuffer fcbuffer = null;
    private int bufferSize;
    private int timeout;
    private FeatureType schema;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public FileGMLDataStore(URI uri, int featureBufferSize, int timeout) {
        super(false);
        this.uri = uri;
        this.bufferSize = featureBufferSize;
        this.timeout = timeout;
    }

    protected String createFeatureTypeName() {
        int slash;
        String path = this.uri.getPath();
        int dot = path.indexOf(46, slash = Math.max(0, path.lastIndexOf(47) + 1));
        if (dot < 0) {
            dot = path.length();
        }
        return path.substring(slash, dot);
    }

    public String[] getTypeNames() throws IOException {
        return new String[]{this.fcbuffer == null ? this.createFeatureTypeName() : this.fcbuffer.getFeatureType().getTypeName()};
    }

    public FeatureType getSchema(String typeName) throws IOException {
        if (!this.getTypeNames()[0].equals(typeName)) {
            throw new IOException("Feature type " + typeName + " does not exist.  This datastore only has " + this.getTypeNames()[0]);
        }
        return this.getSchema();
    }

    protected FeatureReader getFeatureReader(String typeName) throws IOException {
        if (!this.getTypeNames()[0].equals(typeName)) {
            throw new IOException("Feature type " + typeName + " does not exist.  This datastore only has " + this.getTypeNames()[0]);
        }
        try {
            return FCBuffer.getFeatureReader(this.uri, this.bufferSize, this.timeout);
        }
        catch (SAXException sxe) {
            sxe.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureType getSchema() throws IOException {
        if (this.fcbuffer == null) {
            FileGMLDataStore fileGMLDataStore = this;
            synchronized (fileGMLDataStore) {
                if (this.fcbuffer == null) {
                    try {
                        this.fcbuffer = (FCBuffer)FCBuffer.getFeatureReader(this.uri, this.bufferSize, this.timeout);
                        try {
                            if (this.fcbuffer.hasNext()) {
                                Feature f = this.fcbuffer.next();
                                try {
                                    this.schema = this.createFinalSchema(f);
                                }
                                catch (SchemaException e) {
                                    LOGGER.warning(e.getLocalizedMessage());
                                    this.schema = this.fcbuffer.getFeatureType();
                                }
                            }
                        }
                        finally {
                            this.fcbuffer.close();
                        }
                    }
                    catch (SAXException e) {
                        throw new IOException(e.toString());
                    }
                }
            }
        }
        return this.schema;
    }

    private FeatureType createFinalSchema(Feature f) throws SchemaException {
        FeatureTypeFactory builder = FeatureTypeBuilder.newInstance(f.getFeatureType().getTypeName());
        for (int i = 0; i < f.getNumberOfAttributes(); ++i) {
            CoordinateReferenceSystem crs;
            AttributeType att;
            if (!(class$com$vividsolutions$jts$geom$Geometry == null ? FileGMLDataStore.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom((att = f.getFeatureType().getAttributeType(i)).getType())) {
                builder.addType(att);
                continue;
            }
            Geometry geom = (Geometry)f.getAttribute(i);
            Object data = geom.getUserData();
            if (data instanceof CoordinateReferenceSystem) {
                builder.addType(AttributeTypeFactory.newAttributeType(att.getName(), att.getType(), att.isNillable(), att.getRestriction(), att.createDefaultValue(), data));
                continue;
            }
            if (!(data instanceof String)) continue;
            String string = (String)data;
            String[] parts = string.split("#");
            if (parts[0].equals("http://www.opengis.net/gml/srs/epsg.xml")) {
                try {
                    crs = CRS.decode((String)("EPSG:" + parts[1]));
                }
                catch (NoSuchAuthorityCodeException e) {
                    LOGGER.warning(e.getLocalizedMessage());
                    crs = null;
                }
                catch (FactoryException fe) {
                    LOGGER.warning(fe.getLocalizedMessage());
                    crs = null;
                }
            } else {
                crs = null;
            }
            builder.addType(AttributeTypeFactory.newAttributeType(att.getName(), att.getType(), att.isNillable(), att.getRestriction(), att.createDefaultValue(), (Object)crs));
        }
        return builder.getFeatureType();
    }

    protected Envelope getBounds(Query query) throws IOException {
        if (query == Query.ALL || query.getFilter().equals(Filter.NONE)) {
            return null;
        }
        return null;
    }
}

