/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.gml.FileGMLDataStore;
import org.geotools.feature.FeatureType;

public class GMLDataStore
extends AbstractDataStore {
    protected File directory;
    private URI uri;
    private Map datastores = new HashMap();
    private int bufferSize;
    private int timeout;

    public GMLDataStore(URI udir, int featureBufferSize, int timeout) {
        super(false);
        File dir = new File(udir.getPath());
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a Directory");
        }
        this.directory = dir;
        this.bufferSize = featureBufferSize;
        this.timeout = timeout;
    }

    public String[] getTypeNames() throws IOException {
        FilenameFilter f = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".gml") || name.endsWith(".xml");
            }
        };
        String[] list = this.directory.list(f);
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].substring(0, list[i].lastIndexOf(46));
        }
        return list;
    }

    public FeatureType getSchema(String typeName) throws IOException {
        return this.getFileDataStore(typeName).getSchema();
    }

    private synchronized FileGMLDataStore getFileDataStore(String typeName) throws IOException {
        FileGMLDataStore gmlDatastore = (FileGMLDataStore)this.datastores.get(typeName);
        if (gmlDatastore == null) {
            File file = new File(this.directory, typeName + ".gml");
            if (!file.exists()) {
                file = new File(this.directory, typeName + ".xml");
            }
            if (!file.exists()) {
                throw new IOException("GML file doesn't exist: " + file.getName());
            }
            this.uri = file.toURI();
            gmlDatastore = new FileGMLDataStore(this.uri, this.bufferSize, this.timeout);
            this.datastores.put(typeName, gmlDatastore);
        }
        return gmlDatastore;
    }

    protected FeatureReader getFeatureReader(String typeName) throws IOException {
        return this.getFileDataStore(typeName).getFeatureReader(typeName);
    }

    public Envelope getBounds(Query query) throws IOException {
        if (query.getTypeName() == null) {
            throw new NullPointerException("TypeName in query may not be null");
        }
        return this.getFileDataStore(query.getTypeName()).getBounds(query);
    }
}

