/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gml;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.gml.FileGMLDataStore;
import org.geotools.data.gml.GMLDataStore;

public class GMLDataStoreFactory
implements FileDataStoreFactorySpi {
    private Map datastores = new HashMap();
    public static final DataStoreFactorySpi.Param URLP = new DataStoreFactorySpi.Param("url", URL.class, "url to a gml file");
    public static final DataStoreFactorySpi.Param TIMEOUT = new DataStoreFactorySpi.Param("timeout", Integer.class, "length of time out", false);
    public static final DataStoreFactorySpi.Param BUFFER_SIZEP = new DataStoreFactorySpi.Param("featureBufferSize", Integer.class, "Number of features to load into the buffer", false);

    public synchronized DataStore createDataStore(Map params) throws IOException {
        if (this.datastores.get(params) == null) {
            DataStore ds = this.createNewDataStore(params);
            this.datastores.put(params, ds);
        }
        return (DataStore)this.datastores.get(params);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        URL url = (URL)URLP.lookUp(params);
        boolean retvalue = this.testURL(url);
        if (retvalue) {
            Integer buffer;
            Integer timeout = (Integer)params.get(GMLDataStoreFactory.TIMEOUT.key);
            if (timeout == null) {
                timeout = new Integer(10000);
            }
            if ((buffer = (Integer)params.get(GMLDataStoreFactory.TIMEOUT.key)) == null) {
                buffer = new Integer(10);
            }
            try {
                if ("file".equals(url.getProtocol())) {
                    File file = new File(url.getFile());
                    if (file.isDirectory()) {
                        return new GMLDataStore(new URI(url.getPath()), buffer, timeout);
                    }
                    return new FileGMLDataStore(new URI(url.getPath()), buffer, timeout);
                }
                return new FileGMLDataStore(new URI(url.getPath()), buffer, timeout);
            }
            catch (URISyntaxException e) {
                throw new IOException(e.toString());
            }
        }
        throw new IOException("Provided url:" + url + " was not valid");
    }

    public String getDisplayName() {
        return "GML";
    }

    public String getDescription() {
        return "Read only data store for validating gml 2.x data";
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{URLP};
    }

    public boolean canProcess(Map params) {
        if (params != null && params.containsKey("url")) {
            Object url = params.get("url");
            URL tempurl = null;
            if (url instanceof URL) {
                tempurl = (URL)url;
            } else if (url instanceof String) {
                try {
                    tempurl = new URL((String)url);
                }
                catch (MalformedURLException e) {
                    return false;
                }
            } else {
                return false;
            }
            if (this.canProcess(tempurl)) {
                return true;
            }
        }
        return false;
    }

    public boolean isAvailable() {
        return true;
    }

    public String[] getFileExtensions() {
        return new String[]{".xml", ".gml"};
    }

    public boolean canProcess(URL f) {
        try {
            return this.testURL(f);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean testURL(URL f) throws IOException {
        if ("file".equals(f.getProtocol())) {
            File file = new File(f.getFile());
            if (file.isDirectory()) {
                return true;
            }
            if (f.getFile().toUpperCase().endsWith(".XML")) {
                return true;
            }
            if (f.getFile().toUpperCase().endsWith(".GML")) {
                return true;
            }
            throw new IOException("*.xml or *.gml file required");
        }
        if ("http".equals(f.getProtocol())) {
            URLConnection conn = f.openConnection();
            if ("text/xml".equals(conn.getContentType())) {
                return true;
            }
            if ("application/gml".equals(conn.getContentType())) {
                return true;
            }
            throw new IOException("text/xml or application/gml mime type required");
        }
        return false;
    }

    public DataStore createDataStore(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(GMLDataStoreFactory.URLP.key, url);
        return this.createDataStore(params);
    }

    public String getTypeName(URL url) throws IOException {
        DataStore ds = this.createDataStore(url);
        String[] names = ds.getTypeNames();
        return names == null || names.length == 0 ? null : names[0];
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

