/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import [Lorg.opengis.spatialschema.geometry.DirectPosition;;
import javax.xml.namespace.QName;
import org.geotools.geometry.DirectPosition1D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.gml3.bindings.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.DirectPosition;

public class DirectPositionListTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return GML.DIRECTPOSITIONLISTTYPE;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return DirectPosition;.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateReferenceSystem crs = GML3ParsingUtils.crs(node);
        double[] values = (double[])value;
        Integer count = (Integer)node.getAttributeValue("count");
        if (count == null) {
            count = new Integer(values.length / 2);
        }
        if (count == 0) {
            return new DirectPosition[0];
        }
        int dim = values.length / count;
        if (dim < 1 || dim > 2) {
            throw new IllegalArgumentException("dimension must be 1 or 2");
        }
        DirectPosition[] dps = new DirectPosition[count.intValue()];
        if (dim == 1) {
            for (int i = 0; i < count; ++i) {
                dps[i] = new DirectPosition1D(crs);
                dps[i].setOrdinate(0, values[i]);
            }
        } else {
            int j = 0;
            for (int i = 0; i < count; ++i) {
                dps[i] = new DirectPosition2D(crs);
                dps[i].setOrdinate(0, values[j++]);
                dps[i].setOrdinate(1, values[j++]);
            }
        }
        return dps;
    }
}

