/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.bindings.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.DirectPosition;

public class EnvelopeTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return GML.ENVELOPETYPE;
    }

    public Class getType() {
        return ReferencedEnvelope.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateReferenceSystem crs = GML3ParsingUtils.crs(node);
        if (node.getChild("lowerCorner") != null) {
            DirectPosition l = (DirectPosition)node.getChildValue("lowerCorner");
            DirectPosition u = (DirectPosition)node.getChildValue("upperCorner");
            return new ReferencedEnvelope(l.getOrdinate(0), l.getOrdinate(1), u.getOrdinate(0), u.getOrdinate(1), crs);
        }
        if (node.hasChild(Coordinate.class)) {
            List c = node.getChildValues(Coordinate.class);
            Coordinate c1 = (Coordinate)c.get(0);
            Coordinate c2 = (Coordinate)c.get(1);
            return new ReferencedEnvelope(c1.x, c1.y, c2.x, c2.y, crs);
        }
        if (node.hasChild(DirectPosition.class)) {
            List dp = node.getChildValues(DirectPosition.class);
            DirectPosition dp1 = (DirectPosition)dp.get(0);
            DirectPosition dp2 = (DirectPosition)dp.get(1);
            return new ReferencedEnvelope(dp1.getOrdinate(0), dp1.getOrdinate(1), dp2.getOrdinate(0), dp2.getOrdinate(1), crs);
        }
        if (node.hasChild(CoordinateSequence.class)) {
            CoordinateSequence seq = (CoordinateSequence)node.getChildValue(CoordinateSequence.class);
            return new ReferencedEnvelope(seq.getX(0), seq.getY(0), seq.getX(1), seq.getY(1), crs);
        }
        return null;
    }
}

