/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imageio.asciigrid;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.RasterFactory;
import org.geotools.gce.imageio.asciigrid.AsciiGridsImageMetadata;
import org.geotools.gce.imageio.asciigrid.raster.AsciiGridRaster;
import org.geotools.gce.imageio.asciigrid.raster.EsriAsciiGridRaster;
import org.geotools.gce.imageio.asciigrid.raster.GrassAsciiGridRaster;
import org.geotools.gce.imageio.asciigrid.spi.AsciiGridsImageReaderSpi;

public final class AsciiGridsImageReader
extends ImageReader {
    private static final Logger logger = Logger.getLogger("org.geotools.gce.imageio.asciigrid");
    private static final int MIN_SIZE_NEED_TILING = 0x500000;
    private static final int DEFAULT_TILE_SIZE = 524288;
    private boolean GRASS = false;
    private int width = -1;
    private int height = -1;
    private int imageSize = -1;
    private boolean isTiled = false;
    private int tileWidth = -1;
    private int tileHeight = -1;
    private AsciiGridRaster rasterReader = null;
    private static final ComponentColorModel cm = RasterFactory.createComponentColorModel((int)4, (ColorSpace)ColorSpace.getInstance(1003), (boolean)false, (boolean)false, (int)1);
    private SampleModel sm;
    private ImageTypeSpecifier imageType;
    private ImageInputStream imageInputStream = null;
    private AsciiGridsImageMetadata metadata;

    public AsciiGridsImageReader(AsciiGridsImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    public void setInput(Object input) {
        IllegalArgumentException ex;
        block31: {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Setting Input");
            }
            if (this.imageInputStream != null) {
                this.reset();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Resetting old stream");
                }
            }
            if (input instanceof ImageInputStream) {
                this.imageInputStream = (ImageInputStream)input;
            } else {
                if (input instanceof URL) {
                    URL testUrl = (URL)input;
                    if (!testUrl.getProtocol().equalsIgnoreCase("file")) {
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.severe("Unsupported URL provided as input!");
                        }
                        throw new IllegalArgumentException("Unsupported URL provided as input!");
                    }
                    try {
                        File inFile = new File(URLDecoder.decode(testUrl.getFile(), "UTF-8"));
                        if (!inFile.exists()) {
                            if (logger.isLoggable(Level.SEVERE)) {
                                logger.severe("Input file does not exists!");
                            }
                            throw new IllegalArgumentException("Input file does not exists!");
                        }
                        break block31;
                    }
                    catch (UnsupportedEncodingException e) {
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                        IllegalArgumentException ex2 = new IllegalArgumentException();
                        ex2.initCause(e);
                        throw ex2;
                    }
                }
                if (input instanceof File) {
                    File inFile = (File)input;
                    if (!inFile.exists()) {
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.severe("Input file does not exists!");
                        }
                        throw new IllegalArgumentException("Input file does not exists!");
                    }
                } else {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.severe("Input is not decodable!");
                    }
                    throw new IllegalArgumentException("Input is not decodable!");
                }
            }
        }
        if (this.imageInputStream == null) {
            try {
                this.imageInputStream = ImageIO.createImageInputStream(input);
                if (this.imageInputStream == null) {
                    throw new IllegalArgumentException("Unsupported object provided as input!");
                }
            }
            catch (IOException e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                ex = new IllegalArgumentException();
                ex.initCause(e);
                throw ex;
            }
        }
        try {
            this.imageInputStream.reset();
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            ex = new IllegalArgumentException("Unable to parse the header for the provided input");
            ex.initCause(e);
            throw ex;
        }
        this.imageInputStream.mark();
        try {
            this.rasterReader = new EsriAsciiGridRaster(this.imageInputStream, this);
            this.rasterReader.parseHeader();
        }
        catch (IOException e) {
            try {
                this.rasterReader = new GrassAsciiGridRaster(this.imageInputStream, this);
                this.rasterReader.parseHeader();
            }
            catch (IOException e1) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
                }
                IllegalArgumentException ex3 = new IllegalArgumentException("Unable to parse the header for the provided input");
                ex3.initCause(e1);
                throw ex3;
            }
        }
        super.setInput(this.imageInputStream, true, false);
        this.initializeReader();
    }

    private void initializeReader() {
        this.GRASS = this.rasterReader instanceof GrassAsciiGridRaster;
        this.width = this.rasterReader.getNCols();
        this.height = this.rasterReader.getNRows();
        this.sm = cm.createCompatibleSampleModel(this.width, this.height);
        int dataType = this.sm.getDataType();
        int sampleSizeBit = DataBuffer.getDataTypeSize(dataType);
        int sampleSizeByte = (sampleSizeBit + 7) / 8;
        this.imageSize = this.width * this.height * sampleSizeByte;
        if (this.imageSize >= 0x500000) {
            this.isTiled = true;
            this.tileWidth = this.width;
            this.tileHeight = 524288 / (this.tileWidth * sampleSizeByte);
            if (this.tileHeight < 1) {
                this.tileHeight = 1;
            }
            this.rasterReader.setTilesData(this.tileWidth, this.tileHeight);
        } else {
            this.tileWidth = this.width;
            this.tileHeight = this.height;
        }
        this.imageType = new ImageTypeSpecifier(cm, this.sm);
    }

    private void checkImageIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("illegal Index");
        }
    }

    public int getHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.height;
    }

    public int getWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.width;
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        if (this.imageType == null) {
            this.imageType = new ImageTypeSpecifier(cm, this.sm);
        }
        l.add(this.imageType);
        return l.iterator();
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        logger.info("getStreamMetadata");
        return null;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (this.metadata == null) {
            this.metadata = new AsciiGridsImageMetadata(this.rasterReader);
        }
        return this.metadata;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkImageIndex(imageIndex);
        this.processImageStarted(imageIndex);
        return new BufferedImage(cm, (WritableRaster)this.readRaster(imageIndex, param), false, null);
    }

    public int getTileGridXOffset(int imageIndex) throws IOException {
        return 0;
    }

    public int getTileGridYOffset(int imageIndex) throws IOException {
        return 0;
    }

    public int getTileHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.tileHeight;
    }

    public int getTileWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.tileWidth;
    }

    public boolean isImageTiled(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.isTiled;
    }

    public boolean isRandomAccessEasy(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return false;
    }

    public boolean isSeekForwardOnly() {
        return true;
    }

    public BufferedImage read(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.read(imageIndex, null);
    }

    public RenderedImage readAsRenderedImage(int imageIndex, ImageReadParam param) throws IOException {
        return this.read(imageIndex, param);
    }

    public boolean readerSupportsThumbnails() {
        return false;
    }

    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        return this.rasterReader.readRaster(param);
    }

    public BufferedImage readTile(int imageIndex, int tileX, int tileY) throws IOException {
        this.checkImageIndex(imageIndex);
        int w = this.getWidth(imageIndex);
        int h = this.getHeight(imageIndex);
        int tw = this.getTileWidth(imageIndex);
        int th = this.getTileHeight(imageIndex);
        int x = tw * tileX;
        int y = th * tileY;
        if (tileX < 0 || tileY < 0 || x >= w || y >= h) {
            throw new IllegalArgumentException("Tile indices are out of bounds!");
        }
        if (x + tw > w) {
            tw = w - x;
        }
        if (y + th > h) {
            th = h - y;
        }
        ImageReadParam param = this.getDefaultReadParam();
        Rectangle tileRect = new Rectangle(x, y, tw, th);
        param.setSourceRegion(tileRect);
        return this.read(imageIndex, param);
    }

    public Raster readTileRaster(int imageIndex, int tileX, int tileY) throws IOException {
        return this.readTile(imageIndex, tileX, tileY).getRaster();
    }

    public boolean canReadRaster() {
        return true;
    }

    public int getMinIndex() {
        return 0;
    }

    public int getNumThumbnails(int imageIndex) throws IOException {
        return 0;
    }

    public boolean hasThumbnails(int imageIndex) throws IOException {
        return false;
    }

    public boolean isIgnoringMetadata() {
        return this.ignoreMetadata;
    }

    public AsciiGridRaster getRasterReader() {
        return this.rasterReader;
    }

    public ImageInputStream getCurrentImageInputStream() {
        return this.imageInputStream;
    }

    public void dispose() {
        if (this.imageInputStream != null) {
            try {
                this.imageInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.imageInputStream = null;
        super.dispose();
    }

    public void reset() {
        this.dispose();
        super.setInput(null, false, false);
        this.rasterReader = null;
        this.tileWidth = -1;
        this.tileHeight = -1;
        this.height = -1;
        this.width = -1;
        this.sm = null;
        this.isTiled = false;
        this.imageType = null;
        this.imageSize = -1;
        this.GRASS = false;
        this.metadata = null;
    }

    public synchronized void abort() {
        super.abort();
    }

    protected synchronized boolean abortRequested() {
        return super.abortRequested();
    }

    protected synchronized void clearAbortRequest() {
        super.clearAbortRequest();
    }

    public void processImageProgress(float percentageDone) {
        super.processImageProgress(percentageDone);
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.setInput(input);
    }

    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input);
    }
}

