/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imageio.asciigrid.raster;

import java.awt.Rectangle;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.JAI;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileFactory;
import javax.media.jai.iterator.RectIter;
import org.geotools.gce.imageio.asciigrid.AsciiGridsImageReader;
import org.geotools.gce.imageio.asciigrid.raster.DoubleConverter;

public abstract class AsciiGridRaster {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.gce.imageio.asciigrid.raster");
    static final String newline = System.getProperty("line.separator");
    protected final int[] tileTreeMutex = new int[1];
    protected final int[] abortMutex = new int[1];
    protected double maxValue = 1.4E-45f;
    protected double minValue = 3.4028234663852886E38;
    protected double xllCellCoordinate = Double.NaN;
    protected double yllCellCoordinate = Double.NaN;
    protected int sourceXSubsampling = 1;
    protected int sourceYSubsampling = 1;
    protected boolean isCorner;
    protected double cellSizeX = Double.NaN;
    protected double cellSizeY = Double.NaN;
    protected int nCols = -1;
    protected int nRows = -1;
    protected boolean compress;
    protected long dataStartAt = -1L;
    protected TreeMap tileMarker = new TreeMap();
    protected int tileWidth = -1;
    protected int tileHeight = -1;
    protected ImageInputStream imageIS = null;
    protected ImageOutputStream imageOS = null;
    protected double noData = Double.NaN;
    protected AsciiGridsImageReader reader;

    protected AsciiGridRaster(ImageInputStream iis) {
        this.imageIS = iis;
        this.abortMutex[0] = 0;
    }

    protected AsciiGridRaster(ImageInputStream iis, AsciiGridsImageReader reader) {
        this(iis);
        this.reader = reader;
    }

    protected AsciiGridRaster(ImageOutputStream ios) {
        this.imageOS = ios;
        this.abortMutex[0] = 0;
    }

    public abstract void parseHeader() throws IOException;

    public double getNoData() {
        return this.noData;
    }

    public abstract String getNoDataMarker();

    public abstract void writeHeader(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws IOException;

    public final double getMaxValue() {
        return this.maxValue;
    }

    public final double getMinValue() {
        return this.minValue;
    }

    public final int getNRows() {
        return this.nRows;
    }

    public final int getNCols() {
        return this.nCols;
    }

    public final double getXllCellCoordinate() {
        return this.xllCellCoordinate;
    }

    public final double getYllCellCoordinate() {
        return this.yllCellCoordinate;
    }

    public final void setTilesData(int tileWidth, int tileHeight) {
        this.tileHeight = tileHeight;
        this.tileWidth = tileWidth;
    }

    public final int getTileHeight() {
        return this.tileHeight;
    }

    public final int getTileWidth() {
        return this.tileWidth;
    }

    public final boolean isCorner() {
        return this.isCorner;
    }

    final long getDataStartAt() {
        return this.dataStartAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public WritableRaster readRaster(ImageReadParam param) throws IOException {
        int[] nArray;
        int dstWidth = -1;
        int dstHeight = -1;
        int srcRegionWidth = -1;
        int srcRegionHeight = -1;
        int srcRegionXOffset = -1;
        int srcRegionYOffset = -1;
        int xSubsamplingFactor = -1;
        int ySubsamplingFactor = -1;
        boolean doSubsampling = false;
        Rectangle srcRegion = param.getSourceRegion();
        if (srcRegion != null) {
            srcRegionWidth = (int)srcRegion.getWidth();
            srcRegionHeight = (int)srcRegion.getHeight();
            srcRegionXOffset = (int)srcRegion.getX();
            srcRegionYOffset = (int)srcRegion.getY();
            if (srcRegionXOffset < 0) {
                srcRegionXOffset = 0;
            }
            if (srcRegionYOffset < 0) {
                srcRegionYOffset = 0;
            }
            if (srcRegionXOffset + srcRegionWidth > this.nCols) {
                srcRegionWidth = this.nCols - srcRegionXOffset;
            }
            dstWidth = srcRegionWidth;
            if (srcRegionYOffset + srcRegionHeight > this.nRows) {
                srcRegionHeight = this.nRows - srcRegionYOffset;
            }
            dstHeight = srcRegionHeight;
        } else {
            dstWidth = this.nCols;
            dstHeight = this.nRows;
            srcRegionYOffset = 0;
            srcRegionXOffset = 0;
            srcRegionWidth = this.nCols;
            srcRegionHeight = this.nRows;
        }
        xSubsamplingFactor = param.getSourceXSubsampling();
        ySubsamplingFactor = param.getSourceYSubsampling();
        if (xSubsamplingFactor > this.nCols) throw new IOException("The subSamplingFactor cannot be greater than image size!");
        if (ySubsamplingFactor > this.nRows) {
            throw new IOException("The subSamplingFactor cannot be greater than image size!");
        }
        if (xSubsamplingFactor > 1 || ySubsamplingFactor > 1) {
            doSubsampling = true;
        }
        int samplesToLoad = srcRegionHeight * this.nCols;
        dstWidth = (dstWidth - 1) / xSubsamplingFactor + 1;
        dstHeight = (dstHeight - 1) / ySubsamplingFactor + 1;
        int samplesToThrowAwayBeforeFirstValidSample = this.nCols * srcRegionYOffset;
        TileFactory factory = (TileFactory)JAI.getDefaultInstance().getRenderingHint(JAI.KEY_TILE_FACTORY);
        WritableRaster raster = factory != null ? factory.createTile(RasterFactory.createBandedSampleModel((int)4, (int)dstWidth, (int)dstHeight, (int)1), null) : RasterFactory.createBandedRaster((int)4, (int)dstWidth, (int)dstHeight, (int)1, null);
        int ch = -1;
        int prevCh = -1;
        int samplesCounted = 0;
        long streamPosition = 0L;
        this.imageIS.seek(this.dataStartAt);
        if (samplesToThrowAwayBeforeFirstValidSample > 0) {
            nArray = this.tileTreeMutex;
            // MONITORENTER : this.tileTreeMutex
            Long markedPos = (Long)this.tileMarker.get(new Long(samplesToThrowAwayBeforeFirstValidSample));
            if (markedPos != null) {
                this.imageIS.seek(markedPos.intValue());
                samplesCounted = samplesToThrowAwayBeforeFirstValidSample;
            } else {
                SortedMap sm = this.tileMarker.headMap(new Long(samplesToThrowAwayBeforeFirstValidSample));
                if (!sm.entrySet().isEmpty()) {
                    Long key = sm.lastKey();
                    markedPos = (Long)this.tileMarker.get(key);
                    if (markedPos != null) {
                        this.imageIS.seek(markedPos.intValue());
                        samplesCounted = key.intValue();
                    }
                } else {
                    this.imageIS.seek(this.dataStartAt);
                    samplesCounted = 0;
                }
            }
            // MONITOREXIT : nArray
        }
        streamPosition = this.imageIS.getStreamPosition();
        nArray = this.abortMutex;
        // MONITORENTER : this.abortMutex
        if (this.abortMutex[0] == 1) {
            // MONITOREXIT : nArray
            return raster;
        }
        // MONITOREXIT : nArray
        if (samplesCounted < samplesToThrowAwayBeforeFirstValidSample) {
            int tileH = this.getTileHeight();
            int tileW = this.getTileWidth();
            while (samplesCounted < samplesToThrowAwayBeforeFirstValidSample) {
                ch = this.imageIS.read();
                if (ch == -1) {
                    throw new EOFException("EOF found while looking for valid input");
                }
                ++streamPosition;
                if (ch != 32 && ch != 10 && ch != 13 && ch != 9 && (prevCh == 32 || prevCh == 10 || prevCh == 13 || prevCh == 9) && ++samplesCounted % (tileH * tileW) == 0) {
                    Long key = new Long(samplesCounted);
                    Long val = new Long(streamPosition);
                    int[] nArray2 = this.tileTreeMutex;
                    // MONITORENTER : this.tileTreeMutex
                    if (!this.tileMarker.containsKey(key)) {
                        this.tileMarker.put(key, val);
                    }
                    // MONITOREXIT : nArray2
                }
                prevCh = ch;
            }
        }
        samplesCounted = 0;
        prevCh = -1;
        ch = -1;
        double value = 0.0;
        int valSign = 1;
        double exponent = 0.0;
        int expSign = 1;
        double multiplier = 0.1;
        int expChar = 0;
        int decimalPoint = 0;
        int digits = 0;
        int decimalDigits = 0;
        int expDigits = 0;
        int rasterX = 0;
        int rasterY = 0;
        int tempCol = 0;
        int tempRow = 0;
        double noDataValue = this.getNoData();
        while (true) {
            int[] nArray3;
            if (samplesCounted >= samplesToLoad) {
                nArray3 = this.tileTreeMutex;
                // MONITORENTER : this.tileTreeMutex
                this.tileMarker.put(new Long(samplesToLoad + samplesToThrowAwayBeforeFirstValidSample), new Long(streamPosition));
                // MONITOREXIT : nArray3
                return raster;
            }
            ch = this.imageIS.read();
            ++streamPosition;
            if (ch != 32 && ch != 10 && ch != 13 && ch != 9 && ch != 0) {
                if (prevCh == 32 || prevCh == 10 || prevCh == 13 || prevCh == 9 || prevCh == 0) {
                    if (decimalPoint == 1) {
                        if (decimalDigits == 0) throw new NumberFormatException("An Illegal number was found:\nDigits = " + digits + "\nDecimalPoints = " + decimalPoint + "\nDecimalDigits = " + decimalDigits + "\nE Symbols = " + expChar + "\nDigits after E Symbol = " + expDigits + "\n");
                    }
                    if (expChar == 1) {
                        if (expDigits == 0) throw new NumberFormatException("An Illegal number was found:\nDigits = " + digits + "\nDecimalPoints = " + decimalPoint + "\nDecimalDigits = " + decimalDigits + "\nE Symbols = " + expChar + "\nDigits after E Symbol = " + expDigits + "\n");
                    }
                    if (digits == 0 && decimalDigits == 0 && expDigits > 0) {
                        throw new NumberFormatException("An Illegal number was found:\nDigits = " + digits + "\nDecimalPoints = " + decimalPoint + "\nDecimalDigits = " + decimalDigits + "\nE Symbols = " + expChar + "\nDigits after E Symbol = " + expDigits + "\n");
                    }
                    tempCol = samplesCounted % this.nCols;
                    tempRow = samplesCounted / this.nCols;
                    if (tempCol >= srcRegionXOffset && tempCol < srcRegionXOffset + srcRegionWidth && (!doSubsampling || doSubsampling && tempRow % ySubsamplingFactor == 0 && tempCol % xSubsamplingFactor == 0)) {
                        if (exponent != 0.0) {
                            value *= Math.pow(10.0, exponent * (double)expSign);
                        }
                        if ((value *= (double)valSign) != noDataValue && !Double.isNaN(value) && !Double.isInfinite(value)) {
                            nArray3 = this.tileTreeMutex;
                            // MONITORENTER : this.tileTreeMutex
                            this.minValue = Math.min(this.minValue, value);
                            this.maxValue = Math.max(this.maxValue, value);
                            // MONITOREXIT : nArray3
                        }
                        rasterY = tempRow / ySubsamplingFactor;
                        rasterX = (tempCol - srcRegionXOffset) / xSubsamplingFactor;
                        raster.setSample(rasterX, rasterY, 0, (float)value);
                    }
                    ++samplesCounted;
                    value = 0.0;
                    valSign = 1;
                    exponent = 0.0;
                    expChar = 0;
                    expDigits = 0;
                    decimalPoint = 0;
                    decimalDigits = 0;
                    digits = 0;
                }
                switch (ch) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        if (decimalPoint == 0 && expChar == 0) {
                            value = value * 10.0 + (double)(ch - 48);
                            ++digits;
                            break;
                        }
                        if (expChar == 1) {
                            exponent = exponent * 10.0 + (double)(ch - 48);
                            ++expDigits;
                            break;
                        }
                        value += (double)(ch - 48) * multiplier;
                        multiplier /= 10.0;
                        ++decimalDigits;
                        break;
                    }
                    case 46: {
                        if (expChar > 0) {
                            throw new NumberFormatException("A Decimal point can't exists after the E symbol within the same number\n");
                        }
                        if (++decimalPoint > 1) {
                            throw new NumberFormatException("The number contains more than 1 decimal point!\n");
                        }
                        multiplier = 0.1;
                        break;
                    }
                    case 45: {
                        if (prevCh == 69 || prevCh == 101) {
                            expSign = -1;
                            break;
                        }
                        valSign = -1;
                        break;
                    }
                    case 43: {
                        if (prevCh == 69 || prevCh == 101) {
                            expSign = 1;
                            break;
                        }
                        valSign = 1;
                        break;
                    }
                    case 42: {
                        value = Double.NaN;
                        break;
                    }
                    case 69: 
                    case 101: {
                        if (++expChar > 1) {
                            throw new NumberFormatException("The number contains more than one 'E' symbol !\n");
                        }
                        exponent = 0.0;
                        expSign = 1;
                        expDigits = 0;
                        break;
                    }
                    case -1: {
                        if (samplesCounted == samplesToLoad) break;
                        throw new EOFException("EOF found while looking for valid input");
                    }
                    default: {
                        throw new NumberFormatException("Invalid data value was found. ASCII CODE : " + ch);
                    }
                }
            }
            prevCh = ch;
        }
    }

    public void writeRaster(RectIter iterator, Double noDataDouble, String noDataMarker) throws IOException {
        byte[] noDataMarkerBytes = noDataMarker.getBytes();
        byte[] newLineBytes = newline.getBytes();
        while (!iterator.finishedLines()) {
            while (!iterator.finishedPixels()) {
                double sample = iterator.getSampleDouble();
                if (noDataDouble.compareTo(new Double(sample)) != 0 && !Double.isNaN(sample) && !Double.isInfinite(sample)) {
                    this.imageOS.writeBytes(Double.toString(sample));
                } else {
                    this.imageOS.write(noDataMarkerBytes);
                }
                iterator.nextPixel();
                if (iterator.finishedPixels()) continue;
                this.imageOS.write(32);
            }
            this.imageOS.write(newLineBytes);
            iterator.nextLine();
            iterator.startPixels();
        }
    }

    public int getSourceXSubsampling() {
        return this.sourceXSubsampling;
    }

    public int getSourceYSubsampling() {
        return this.sourceYSubsampling;
    }

    public final double getCellSizeX() {
        return this.cellSizeX;
    }

    public final double getCellSizeY() {
        return this.cellSizeY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        int[] nArray = this.abortMutex;
        synchronized (this.abortMutex) {
            this.abortMutex[0] = 1;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAborting() {
        int[] nArray = this.abortMutex;
        synchronized (this.abortMutex) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.abortMutex[0] == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAbort() {
        int[] nArray = this.abortMutex;
        synchronized (this.abortMutex) {
            this.abortMutex[0] = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    double getValue(ImageInputStream inStream, int maxBytesToRead, int maxValueLength) throws IOException {
        double retVal = Double.NaN;
        boolean started = false;
        int bytesRead = 0;
        int validBytesRead = 0;
        DoubleConverter numberConver = DoubleConverter.acquire();
        while (true) {
            byte b;
            if ((b = (byte)(inStream.read() & 0xFF)) == -1) {
                return Double.NEGATIVE_INFINITY;
            }
            if (++bytesRead > maxBytesToRead) break;
            if (b == 32 || b == 10 || b == 13 || b == 9) {
                if (!started) continue;
                break;
            }
            if ((b < 48 || b > 57) && b != 43 && b != 45 && b != 69 && b != 101 && b != 46) {
                return Double.NEGATIVE_INFINITY;
            }
            ++validBytesRead;
            if (!numberConver.pushChar(b)) {
                return Double.NEGATIVE_INFINITY;
            }
            started = true;
            if (validBytesRead > maxValueLength) break;
        }
        numberConver.compute();
        retVal = numberConver.getValue();
        return retVal;
    }

    String getKey(ImageInputStream inStream, int maxBytesToRead, int maxKeyLength, byte specialChar) throws IOException {
        byte b;
        StringBuffer buffer = new StringBuffer(10);
        boolean started = false;
        int bytesRead = 0;
        int validBytesRead = 0;
        while ((b = (byte)(inStream.read() & 0xFF)) != -1 && ++bytesRead < maxBytesToRead) {
            if (b == 32 || b == 10 || b == 13 || b == 9) {
                if (started) break;
                continue;
            }
            if (specialChar > 127 ? !(b == 95 || b >= 97 && b <= 122 || b >= 64 && b <= 90) : !(b == 95 || b == specialChar || b >= 97 && b <= 122 || b >= 64 && b <= 90)) break;
            buffer.append(new String(new byte[]{b}, "ascii"));
            started = true;
            if (++validBytesRead < maxKeyLength) continue;
            break;
        }
        return buffer.toString();
    }
}

