/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imageio.asciigrid.raster;

import java.lang.ref.SoftReference;
import java.util.Vector;

final class DoubleConverter {
    private static final int CONVERTER_NUM = 50;
    static Vector pool = new Vector(50);
    private double value = 0.0;
    private int valSign = 1;
    private double exponent = 0.0;
    private int expSign = 1;
    private double multiplier = 0.1;
    private int expChar = 0;
    private int decimalPoint = 0;
    private int digits = 0;
    private int decimalDigits = 0;
    private int expDigits = 0;
    private int prevCh = -1;
    private boolean eof = false;
    private double retValue;

    private static void enlargePool(int num) {
        for (int i = 0; i < num; ++i) {
            pool.add(new SoftReference<DoubleConverter>(new DoubleConverter()));
        }
    }

    private DoubleConverter() {
    }

    void reset() {
        this.value = 0.0;
        this.valSign = 1;
        this.exponent = 0.0;
        this.expSign = 1;
        this.multiplier = 0.1;
        this.expChar = 0;
        this.decimalPoint = 0;
        this.digits = 0;
        this.decimalDigits = 0;
        this.expDigits = 0;
        this.eof = false;
        this.prevCh = -1;
    }

    boolean pushChar(int newChar) {
        boolean retVal = false;
        if (newChar != 32 && newChar != 10 && newChar != 13 && newChar != 9 && newChar != 0) {
            if (this.prevCh == 32 || this.prevCh == 10 || this.prevCh == 13 || this.prevCh == 9 || this.prevCh == 0) {
                if (this.decimalPoint == 1 && this.decimalDigits == 0 || this.expChar == 1 && this.expDigits == 0 || this.digits == 0 && this.decimalDigits == 0 && this.expDigits > 0) {
                    throw new NumberFormatException("An Illegal number was found:\nDigits = " + this.digits + "\nDecimalPoints = " + this.decimalPoint + "\nDecimalDigits = " + this.decimalDigits + "\nE Symbols = " + this.expChar + "\nDigits after E Symbol = " + this.expDigits + "\n");
                }
                retVal = true;
                this.compute();
                this.reset();
            }
            switch (newChar) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    retVal = true;
                    if (this.decimalPoint == 0 && this.expChar == 0) {
                        this.value = this.value * 10.0 + (double)(newChar - 48);
                        ++this.digits;
                        break;
                    }
                    if (this.expChar == 1) {
                        this.exponent = this.exponent * 10.0 + (double)(newChar - 48);
                        ++this.expDigits;
                        break;
                    }
                    this.value += (double)(newChar - 48) * this.multiplier;
                    this.multiplier /= 10.0;
                    ++this.decimalDigits;
                    break;
                }
                case 46: {
                    retVal = true;
                    if (this.expChar > 0) {
                        throw new NumberFormatException("A Decimal point can't exists after the E symbol within the same number\n");
                    }
                    ++this.decimalPoint;
                    if (this.decimalPoint > 1) {
                        throw new NumberFormatException("The number contains more than 1 decimal point!\n");
                    }
                    this.multiplier = 0.1;
                    break;
                }
                case 45: {
                    retVal = true;
                    if (this.prevCh == 69 || this.prevCh == 101) {
                        this.expSign = -1;
                        break;
                    }
                    this.valSign = -1;
                    break;
                }
                case 43: {
                    retVal = true;
                    if (this.prevCh == 69 || this.prevCh == 101) {
                        this.expSign = 1;
                        break;
                    }
                    this.valSign = 1;
                    break;
                }
                case 42: {
                    this.value = Double.NaN;
                    break;
                }
                case 69: 
                case 101: {
                    ++this.expChar;
                    retVal = true;
                    if (this.expChar > 1) {
                        throw new NumberFormatException("The number contains more than one 'E' symbol !\n");
                    }
                    this.exponent = 0.0;
                    this.expSign = 1;
                    this.expDigits = 0;
                    break;
                }
                case -1: {
                    retVal = true;
                    this.eof = true;
                    break;
                }
                default: {
                    throw new NumberFormatException("Invalid data value was found. ASCII CODE : " + newChar);
                }
            }
        }
        this.prevCh = newChar;
        return retVal;
    }

    void compute() {
        if (this.exponent != 0.0) {
            this.value *= Math.pow(10.0, this.exponent * (double)this.expSign);
        }
        this.retValue = this.value * (double)this.valSign;
    }

    boolean isEof() {
        return this.eof;
    }

    double getValue() {
        return this.retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DoubleConverter acquire() {
        Vector vector = pool;
        synchronized (vector) {
            while (pool.size() > 0) {
                SoftReference r = (SoftReference)pool.remove(0);
                Object o = r.get();
                if (o == null) continue;
                return (DoubleConverter)o;
            }
            DoubleConverter.enlargePool(49);
            return new DoubleConverter();
        }
    }

    static void release(DoubleConverter c) {
        pool.add(new SoftReference<DoubleConverter>(c));
    }

    static {
        DoubleConverter.enlargePool(50);
    }
}

