/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imageio.asciigrid.raster;

import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.geotools.gce.imageio.asciigrid.AsciiGridsImageReader;
import org.geotools.gce.imageio.asciigrid.raster.AsciiGridRaster;

public final class EsriAsciiGridRaster
extends AsciiGridRaster {
    private static final Logger logger = Logger.getLogger(EsriAsciiGridRaster.class.toString());
    public static final String NO_DATA_MARKER = "-9999";
    public static final String NCOLS = "NCOLS";
    public static final String NROWS = "NROWS";
    public static final String XLLCORNER = "XLLCORNER";
    public static final String YLLCORNER = "YLLCORNER";
    public static final String XLLCENTER = "XLLCENTER";
    public static final String YLLCENTER = "YLLCENTER";
    public static final String CELLSIZE = "CELLSIZE";
    public static final String NODATA_VALUE = "NODATA_VALUE";
    private String noDataMarker;

    public EsriAsciiGridRaster(ImageInputStream ios) {
        super(ios);
    }

    public EsriAsciiGridRaster(ImageOutputStream ios) {
        super(ios);
    }

    public EsriAsciiGridRaster(ImageInputStream ios, AsciiGridsImageReader reader) {
        super(ios, reader);
    }

    public void parseHeader() throws IOException {
        boolean keepParsing = true;
        this.imageIS.mark();
        int requiredFields = 0;
        String sKey = null;
        boolean cornerInitialized = false;
        int maxNumBytes = 100;
        double value = 0.0;
        while (keepParsing && !((sKey = this.getKey(this.imageIS, maxNumBytes, 12, (byte)-1)) == null | sKey.length() == 0) && sKey != "" && !Double.isNaN(value = this.getValue(this.imageIS, 300, 150)) && !Double.isNaN(value)) {
            if (NCOLS.equalsIgnoreCase(sKey)) {
                this.nCols = (int)value;
                ++requiredFields;
                continue;
            }
            if (NROWS.equalsIgnoreCase(sKey)) {
                this.nRows = (int)value;
                ++requiredFields;
                continue;
            }
            if (XLLCORNER.equalsIgnoreCase(sKey)) {
                this.xllCellCoordinate = value;
                if (!cornerInitialized) {
                    this.isCorner = true;
                    cornerInitialized = true;
                }
                ++requiredFields;
                continue;
            }
            if (YLLCORNER.equalsIgnoreCase(sKey)) {
                this.yllCellCoordinate = value;
                ++requiredFields;
                continue;
            }
            if (XLLCENTER.equalsIgnoreCase(sKey)) {
                this.xllCellCoordinate = value;
                if (!cornerInitialized) {
                    this.isCorner = false;
                    cornerInitialized = true;
                }
                ++requiredFields;
                continue;
            }
            if (YLLCENTER.equalsIgnoreCase(sKey)) {
                this.yllCellCoordinate = (int)value;
                ++requiredFields;
                continue;
            }
            if (CELLSIZE.equalsIgnoreCase(sKey)) {
                this.cellSizeX = this.cellSizeY = value;
                ++requiredFields;
                continue;
            }
            if (NODATA_VALUE.equalsIgnoreCase(sKey)) {
                this.noData = value;
                ++requiredFields;
                keepParsing = false;
                continue;
            }
            keepParsing = false;
        }
        if (requiredFields < 5) {
            this.imageIS.reset();
            throw new IOException("This file is not a valid ESRI ascii grid file.");
        }
        if (requiredFields == 6) {
            byte b;
            int limit = 0;
            do {
                b = (byte)(this.imageIS.read() & 0xFF);
                if (++limit > 100) {
                    this.imageIS.reset();
                    throw new IOException("This file is not a valid ESRI ascii grid file.");
                }
                if (b != -1) continue;
                this.imageIS.reset();
                throw new IOException("This file is not a valid ESRI ascii grid file.");
            } while (b == 32 || b == 9 || b == 10 || b == 13 || (b < 48 || b > 57) && !(b == 43 | b == 45));
            this.dataStartAt = this.imageIS.getStreamPosition() - 1L;
        } else if (requiredFields == 5) {
            this.imageIS.seek(this.imageIS.getStreamPosition() - 1L);
            byte b = (byte)(this.imageIS.read() & 0xFF);
            if (b >= 48 && b <= 57 || b == 43 | b == 45) {
                this.dataStartAt = this.imageIS.getStreamPosition() - 1L;
            } else {
                this.imageIS.reset();
                throw new IOException("This file is not a valid ESRI ascii grid file.");
            }
        }
        this.imageIS.reset();
        this.imageIS.mark();
    }

    public void writeHeader(String columns, String rows, String xll, String yll, String cellsizeX, String cellsizeY, String rasterSpaceType, String noDataValue) throws IOException {
        this.imageOS.writeBytes(NCOLS + " " + columns + newline);
        this.imageOS.writeBytes(NROWS + " " + rows + newline);
        if (rasterSpaceType.equalsIgnoreCase("pixelIsArea")) {
            this.imageOS.writeBytes(XLLCENTER + " " + xll + newline);
            this.imageOS.writeBytes(YLLCENTER + " " + yll + newline);
        } else {
            this.imageOS.writeBytes(XLLCORNER + " " + xll + newline);
            this.imageOS.writeBytes(YLLCORNER + " " + yll + newline);
        }
        this.imageOS.writeBytes(CELLSIZE + " " + cellsizeX + newline);
        if (noDataValue != null) {
            this.imageOS.writeBytes(NODATA_VALUE + " " + (noDataValue.equalsIgnoreCase("nan") ? NO_DATA_MARKER : noDataValue) + newline);
            this.noData = Double.parseDouble(noDataValue);
        }
    }

    public String getNoDataMarker() {
        if (this.noDataMarker == null) {
            this.noDataMarker = !Double.isNaN(this.noData) ? Double.toString(this.noData) : NO_DATA_MARKER;
        }
        return this.noDataMarker;
    }
}

