/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imageio.asciigrid.raster;

import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.geotools.gce.imageio.asciigrid.AsciiGridsImageReader;
import org.geotools.gce.imageio.asciigrid.raster.AsciiGridRaster;

public final class GrassAsciiGridRaster
extends AsciiGridRaster {
    private static final Logger logger = Logger.getLogger("org.geotools.gce.imageio.asciigrid.raster");
    public static final String COLS = "COLS:";
    public static final String ROWS = "ROWS:";
    public static final String NORTH = "NORTH:";
    public static final String SOUTH = "SOUTH:";
    public static final String EAST = "EAST:";
    public static final String WEST = "WEST:";
    public static final String NO_DATA_MARKER = "*";

    public GrassAsciiGridRaster(ImageInputStream iis) {
        super(iis);
    }

    public GrassAsciiGridRaster(ImageInputStream iis, AsciiGridsImageReader reader) {
        super(iis, reader);
    }

    public GrassAsciiGridRaster(ImageOutputStream ios) {
        super(ios);
    }

    public void parseHeader() throws IOException {
        byte b;
        double north = 0.0;
        double south = 0.0;
        double east = 0.0;
        double west = 0.0;
        boolean keepParsing = true;
        this.imageIS.mark();
        int requiredFields = 0;
        String sKey = null;
        int maxNumBytes = 100;
        double value = 0.0;
        while (keepParsing && !((sKey = this.getKey(this.imageIS, maxNumBytes, 6, (byte)58)) == null | sKey.length() == 0) && sKey != "" && !Double.isNaN(value = this.getValue(this.imageIS, maxNumBytes, 150)) && !Double.isNaN(value)) {
            if (NORTH.equalsIgnoreCase(sKey)) {
                north = value;
                ++requiredFields;
                continue;
            }
            if (SOUTH.equalsIgnoreCase(sKey)) {
                south = value;
                ++requiredFields;
                continue;
            }
            if (EAST.equalsIgnoreCase(sKey)) {
                east = value;
                ++requiredFields;
                continue;
            }
            if (WEST.equalsIgnoreCase(sKey)) {
                west = value;
                ++requiredFields;
                continue;
            }
            if (ROWS.equalsIgnoreCase(sKey)) {
                this.nRows = (int)value;
                ++requiredFields;
                continue;
            }
            if (COLS.equalsIgnoreCase(sKey)) {
                this.nCols = (int)value;
                keepParsing = false;
                ++requiredFields;
                continue;
            }
            keepParsing = false;
        }
        if (requiredFields != 6) {
            this.imageIS.reset();
            throw new IOException("This file is not a valid ESRI ascii grid file.");
        }
        int limit = 0;
        do {
            b = (byte)(this.imageIS.read() & 0xFF);
            if (++limit > 100) {
                this.imageIS.reset();
                throw new IOException("This file is not a valid ESRI ascii grid file.");
            }
            if (b != -1) continue;
            this.imageIS.reset();
            throw new IOException("This file is not a valid ESRI ascii grid file.");
        } while (b == 32 || b == 9 || b == 10 || b == 13 || (b < 48 || b > 57) && b != 43 && b != 45 && b != 42);
        this.dataStartAt = this.imageIS.getStreamPosition() - 1L;
        this.imageIS.reset();
        this.imageIS.mark();
        this.xllCellCoordinate = west;
        this.yllCellCoordinate = south;
        this.isCorner = true;
        this.cellSizeY = (north - south) / (double)this.nRows;
        this.cellSizeX = (east - west) / (double)this.nCols;
    }

    public void writeHeader(String columnsString, String rowsString, String xllString, String yllString, String cellsizeStringX, String cellsizeStringY, String rasterSpaceType, String noDataValue) throws IOException {
        this.nCols = Integer.parseInt(columnsString);
        this.nRows = Integer.parseInt(rowsString);
        this.cellSizeX = Double.parseDouble(cellsizeStringX);
        this.cellSizeY = Double.parseDouble(cellsizeStringY);
        this.xllCellCoordinate = Double.parseDouble(xllString);
        this.yllCellCoordinate = Double.parseDouble(yllString);
        double west = this.xllCellCoordinate;
        double south = this.yllCellCoordinate;
        double north = south + this.cellSizeY * (double)this.nRows;
        double east = west + this.cellSizeX * (double)this.nCols;
        this.imageOS.writeBytes(NORTH + " " + Double.toString(north) + newline);
        this.imageOS.writeBytes(SOUTH + " " + Double.toString(south) + newline);
        this.imageOS.writeBytes(EAST + " " + Double.toString(east) + newline);
        this.imageOS.writeBytes(WEST + " " + Double.toString(west) + newline);
        this.imageOS.writeBytes(ROWS + " " + rowsString + newline);
        this.imageOS.writeBytes(COLS + " " + columnsString + newline);
    }

    public String getNoDataMarker() {
        return NO_DATA_MARKER;
    }
}

