/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imageio.asciigrid.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.gce.imageio.asciigrid.AsciiGridsImageReader;
import org.geotools.gce.imageio.asciigrid.raster.AsciiGridRaster;
import org.geotools.gce.imageio.asciigrid.raster.EsriAsciiGridRaster;
import org.geotools.gce.imageio.asciigrid.raster.GrassAsciiGridRaster;

public final class AsciiGridsImageReaderSpi
extends ImageReaderSpi {
    private static final Logger logger = Logger.getLogger(AsciiGridsImageReaderSpi.class.toString());
    static final String[] suffixes = new String[]{"asc", "arx"};
    static final String[] formatNames = new String[]{"Ascii ArcInfo", "Ascii GRASS"};
    static final String[] MIMETypes = new String[]{"image/asc", "image/arx"};
    static final String version = "1.0";
    static final String readerCN = "org.geotools.gce.imageio.asciigrid.AsciiGridsImageReader";
    static final String vendorName = " TODO";
    static final String[] wSN = new String[]{"org.geotools.gce.imageio.asciigrid.AsciiGridsImageWriterSpi"};
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName = null;
    static final String nativeStreamMetadataFormatClassName = null;
    static final String[] extraStreamMetadataFormatNames = null;
    static final String[] extraStreamMetadataFormatClassNames = null;
    static final boolean supportsStandardImageMetadataFormat = true;
    static final String nativeImageMetadataFormatName = "org.geotools.gce.imageio.asciigrid.AsciiGridsImageMetadata_1.0";
    static final String nativeImageMetadataFormatClassName = "org.geotools.gce.imageio.asciigrid.AsciiGridsImageMetadataFormat";
    static final String[] extraImageMetadataFormatNames = new String[]{null};
    static final String[] extraImageMetadataFormatClassNames = new String[]{null};

    public AsciiGridsImageReaderSpi() {
        super(vendorName, version, formatNames, suffixes, MIMETypes, readerCN, STANDARD_INPUT_TYPE, wSN, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, true, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    public boolean canDecodeInput(Object input) throws IOException {
        if (input instanceof ImageInputStream) {
            ((ImageInputStream)input).mark();
        }
        boolean closeMe = false;
        if (input instanceof String) {
            input = new File((String)input);
            closeMe = true;
        }
        if (input instanceof URL) {
            URL tempURL = (URL)input;
            input = tempURL.getProtocol().equalsIgnoreCase("file") ? new File(URLDecoder.decode(tempURL.getFile(), "UTF8")) : ((URL)input).openStream();
            closeMe = true;
        }
        if (input instanceof File) {
            input = ImageIO.createImageInputStream(input);
            closeMe = true;
        }
        if (input instanceof InputStream) {
            // empty if block
        }
        if (!(input instanceof ImageInputStream)) {
            return false;
        }
        ((ImageInputStream)input).mark();
        ImageInputStream spiImageInputStream = (ImageInputStream)input;
        try {
            EsriAsciiGridRaster asciiRaster = new EsriAsciiGridRaster(spiImageInputStream);
            ((AsciiGridRaster)asciiRaster).parseHeader();
        }
        catch (IOException e) {
            try {
                GrassAsciiGridRaster asciiRaster = new GrassAsciiGridRaster(spiImageInputStream);
                ((AsciiGridRaster)asciiRaster).parseHeader();
            }
            catch (IOException e2) {
                ((ImageInputStream)input).reset();
                if (closeMe) {
                    spiImageInputStream.close();
                }
                return false;
            }
        }
        if (input instanceof ImageInputStream) {
            ((ImageInputStream)input).reset();
        }
        if (closeMe) {
            spiImageInputStream.close();
        }
        return true;
    }

    public ImageReader createReaderInstance(Object source) throws IOException {
        return new AsciiGridsImageReader(this);
    }

    public String getDescription(Locale locale) {
        return "AsciiGrids Image Reader, version 1.0";
    }

    public void dispose() {
    }
}

