/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.postgis;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.DataStoreService;
import org.geotools.catalog.GeoResource;
import org.geotools.catalog.ServiceInfo;
import org.geotools.catalog.defaults.DefaultServiceInfo;
import org.geotools.catalog.postgis.PostGISGeoResource;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.postgis.PostgisDataStoreFactory;
import org.geotools.util.ProgressListener;

public class PostGISService
extends DataStoreService {
    public PostGISService(Catalog parent, Map params) {
        super(parent, params);
    }

    protected DataStoreFactorySpi createDataStoreFactory() {
        return new PostgisDataStoreFactory();
    }

    protected GeoResource createGeoResource(String typeName, DataStore dataStore) {
        return new PostGISGeoResource(this, typeName);
    }

    public URI getIdentifier() {
        Map params = this.getConnectionParams();
        String host = (String)params.get(PostgisDataStoreFactory.HOST.key);
        String port = (String)params.get(PostgisDataStoreFactory.PORT.key);
        String database = (String)params.get(PostgisDataStoreFactory.DATABASE.key);
        try {
            return new URI(null, host, database, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected ServiceInfo createMetaData(DataStore dataStore, ProgressListener monitor) {
        URI schema = null;
        try {
            String ns = (String)PostgisDataStoreFactory.NAMESPACE.lookUp(this.getConnectionParams());
            if (ns != null) {
                schema = new URI(ns);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ServiceInfo info = super.createMetaData(dataStore, monitor);
        return new DefaultServiceInfo(info.getTitle(), info.getDescription(), info.getAbstract(), info.getSource(), info.getPublisher(), schema, info.getKeywords(), info.getIcon());
    }
}

