/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.ConnectionPoolManager;

public class PostgisConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.defaultcore");
    private static final String DRIVER_CLASS = "org.postgresql.Driver";
    private static final String DRIVER_PATH = "jdbc:postgresql";
    private String connPath;
    private String host;
    private String dbName;
    private int port = -1;
    private String user = "test";
    private String password = "test";
    private static Map dataSources = new HashMap();

    public PostgisConnectionFactory(String host, String port, String dbName) {
        this.host = host;
        this.dbName = dbName;
        if (port != null) {
            try {
                this.port = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("could not parse port to an int value");
            }
        }
        this.connPath = "jdbc:postgresql://" + host + ":" + port + "/" + dbName;
    }

    public PostgisConnectionFactory(String host, int port, String dbName) {
        this.connPath = "jdbc:postgresql://" + host + ":" + port + "/" + dbName;
        this.host = host;
        this.dbName = dbName;
        this.port = port;
    }

    public void setLogin(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        Properties props = new Properties();
        props.put("user", user);
        props.put("password", password);
        return this.getConnection(props);
    }

    public ConnectionPool getConnectionPool(String user, String pass) throws SQLException {
        org.postgresql.jdbc2.optional.ConnectionPool poolDataSource = null;
        String dbUrl = this.connPath;
        String poolKey = dbUrl + user + pass;
        LOGGER.fine("looking up pool key " + poolKey);
        Object poolDS = dataSources.get(poolKey);
        poolDataSource = (org.postgresql.jdbc2.optional.ConnectionPool)poolDS;
        LOGGER.fine("pool is " + poolDataSource);
        if (poolDataSource == null) {
            poolDataSource = new org.postgresql.jdbc2.optional.ConnectionPool();
            poolDataSource.setServerName(this.host);
            poolDataSource.setDatabaseName(this.dbName);
            poolDataSource.setPortNumber(this.port);
            poolDataSource.setUser(user);
            poolDataSource.setPassword(pass);
            poolDataSource.setDefaultAutoCommit(true);
            dataSources.put(poolKey, poolDataSource);
        }
        ConnectionPoolManager manager = ConnectionPoolManager.getInstance();
        ConnectionPool connectionPool = manager.getConnectionPool((ConnectionPoolDataSource)poolDataSource);
        return connectionPool;
    }

    public ConnectionPool getConnectionPool() throws SQLException {
        return this.getConnectionPool(this.user, this.password);
    }

    public void free(ConnectionPool connectionPool) {
        if (connectionPool == null) {
            return;
        }
        if (!connectionPool.isClosed()) {
            connectionPool.close();
        }
        ConnectionPoolManager.getInstance().free(connectionPool);
    }

    public Connection getConnection(Properties props) throws SQLException {
        Connection dbConnection = null;
        try {
            Class.forName(DRIVER_CLASS);
            LOGGER.finest("getting connection at " + this.connPath + "with props: " + props);
            dbConnection = DriverManager.getConnection(this.connPath, props);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("Postgis driver was not found.");
        }
        return dbConnection;
    }
}

