/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBCUtils;

public class PostgisDBInfo {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.data.postgis");
    String postgisVersion;
    int postgisMajorVersion;
    int postgisMinorVersion;
    String postgresVersion;
    int postgresMajorVersion;
    int postgresMinorVersion;
    boolean schemaEnabled;
    boolean byteaEnabled;
    boolean geosEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PostgisDBInfo(Connection conn) {
        block12: {
            this.schemaEnabled = true;
            this.byteaEnabled = false;
            this.geosEnabled = false;
            try {
                String sqlStatement = "SELECT postgis_version();";
                Statement statement = conn.createStatement();
                ResultSet result = statement.executeQuery(sqlStatement);
                if (!result.next()) break block12;
                this.postgisVersion = result.getString(1);
                LOGGER.fine("PostGIS version is " + this.postgisVersion);
                try {
                    String[] values = this.postgisVersion.trim().split(" ");
                    String[] versionNumbersStr = values[0].trim().split("\\.");
                    int[] versionNumbers = new int[versionNumbersStr.length];
                    for (int i = 0; i < versionNumbers.length; ++i) {
                        versionNumbers[i] = Integer.parseInt(versionNumbersStr[i]);
                    }
                    this.postgisMajorVersion = versionNumbers[0];
                    this.postgisMinorVersion = versionNumbers[1];
                    if (this.postgisMajorVersion > 0 || this.postgisMinorVersion > 7 || versionNumbers.length > 2 && versionNumbers[2] >= 2) {
                        this.byteaEnabled = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Exception occurred while parsing the version number.", e);
                }
                if (this.postgisVersion.indexOf("USE_GEOS=1") != -1) {
                    this.geosEnabled = true;
                } else {
                    LOGGER.warning("GEOS is NOT enabled. This will result in limited functionality and performance.");
                }
                this.postgresVersion = conn.getMetaData().getDatabaseProductVersion();
                LOGGER.fine("Postgres version is " + this.postgresVersion);
                this.postgresMajorVersion = conn.getMetaData().getDatabaseMajorVersion();
                this.postgresMinorVersion = conn.getMetaData().getDatabaseMinorVersion();
                if (this.postgresMajorVersion < 7 || this.postgresMajorVersion == 7 && this.postgresMinorVersion < 3) {
                    this.schemaEnabled = false;
                }
            }
            catch (SQLException sqle) {
                String message = sqle.getMessage();
                LOGGER.severe(message);
            }
            finally {
                JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
            }
        }
    }

    public String getVersion() {
        return this.postgisVersion;
    }

    public int getMajorVersion() {
        return this.postgisMajorVersion;
    }

    public int getMinorVersion() {
        return this.postgisMinorVersion;
    }

    public String getPostgresVersion() {
        return this.postgresVersion;
    }

    public int getPostgresMajorVersion() {
        return this.postgresMajorVersion;
    }

    public int getPostgresMinorVersion() {
        return this.postgresMinorVersion;
    }

    public boolean isSchemaEnabled() {
        return this.schemaEnabled;
    }

    public boolean isGeosEnabled() {
        return this.geosEnabled;
    }

    public boolean isByteaEnabled() {
        return this.byteaEnabled;
    }
}

