/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCFeatureLocking;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.attributeio.WKTAttributeIO;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapperFactory;
import org.geotools.data.postgis.PostgisDBInfo;
import org.geotools.data.postgis.PostgisDataStoreFactory;
import org.geotools.data.postgis.PostgisFeatureLocking;
import org.geotools.data.postgis.PostgisFeatureWriter;
import org.geotools.data.postgis.PostgisSQLBuilder;
import org.geotools.data.postgis.attributeio.PgWKBAttributeIO;
import org.geotools.data.postgis.fidmapper.PostgisFIDMapperFactory;
import org.geotools.data.postgis.referencing.PostgisAuthorityFactory;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.LengthFunction;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.SQLEncoderPostgis;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PostgisDataStore
extends JDBCDataStore
implements DataStore {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.data.postgis");
    protected static GeometryFactory geometryFactory = new GeometryFactory();
    protected static WKTReader geometryReader = new WKTReader(geometryFactory);
    private static Map GEOM_TYPE_MAP = new HashMap();
    private static Map CLASS_MAPPINGS;
    private static Map GEOM_CLASS_MAPPINGS;
    public static final int OPTIMIZE_SAFE = 0;
    public static final int OPTIMIZE_SQL = 1;
    protected static final int MAX_ALLOWED_VALUE = 0xA00000;
    private PostgisAuthorityFactory paf = null;
    protected PostgisDBInfo dbInfo;
    protected boolean useGeos;
    public int OPTIMIZE_MODE;
    protected boolean WKBEnabled = false;
    protected boolean byteaEnabled = false;
    protected boolean byteaWKB = false;
    protected boolean looseBbox;
    protected boolean estimatedExtent;
    protected boolean schemaEnabled = true;

    protected PostgisDataStore(ConnectionPool connPool) throws IOException {
        this(connPool, null);
    }

    protected PostgisDataStore(ConnectionPool connPool, String namespace) throws IOException {
        this(connPool, PostgisDataStore.schema(null), namespace);
    }

    protected PostgisDataStore(ConnectionPool connPool, String schema, String namespace) throws IOException {
        this(connPool, new JDBCDataStoreConfig(namespace, PostgisDataStore.schema(schema), new HashMap(), new HashMap()), 1);
    }

    protected PostgisDataStore(ConnectionPool connPool, String schema, String namespace, int optimizeMode) throws IOException {
        this(connPool, new JDBCDataStoreConfig(namespace, PostgisDataStore.schema(schema), new HashMap(), new HashMap()), optimizeMode);
    }

    protected static String schema(String schema) {
        if (schema != null && !"".equals(schema)) {
            return schema;
        }
        return (String)PostgisDataStoreFactory.SCHEMA.sample;
    }

    public PostgisDataStore(ConnectionPool connectionPool, JDBCDataStoreConfig config, int optimizeMode) throws IOException {
        super(connectionPool, config);
        this.guessDataStoreOptions();
        this.OPTIMIZE_MODE = optimizeMode;
        this.setFIDMapperFactory(this.buildFIDMapperFactory(config));
    }

    protected LockingManager createLockingManager() {
        return new InProcessLockingManager();
    }

    protected PostgisSQLBuilder createSQLBuilder() {
        PostgisSQLBuilder builder = new PostgisSQLBuilder(new SQLEncoderPostgis(), this.config);
        this.initBuilder(builder);
        return builder;
    }

    protected void guessDataStoreOptions() throws IOException {
        PostgisDBInfo dbInfo = this.getDBInfo();
        if (dbInfo == null) {
            LOGGER.severe("Could not obtain PostgisDBInfo");
            this.byteaEnabled = true;
            this.byteaWKB = false;
            this.useGeos = true;
            this.schemaEnabled = true;
        } else {
            this.byteaEnabled = dbInfo.isByteaEnabled();
            if (dbInfo.getMajorVersion() >= 1) {
                this.byteaWKB = true;
            }
            this.useGeos = dbInfo.isGeosEnabled();
            this.schemaEnabled = dbInfo.isSchemaEnabled();
        }
    }

    public String[] getTypeNames() throws IOException {
        int TABLE_NAME_COL = 3;
        Connection conn = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            DatabaseMetaData meta = conn.getMetaData();
            String[] tableType = new String[]{"TABLE", "VIEW"};
            ResultSet tables = meta.getTables(null, this.config.getDatabaseSchemaName(), "%", tableType);
            while (tables.next()) {
                String tableName = tables.getString(3);
                if (!this.allowTable(tableName)) continue;
                list.add(tableName);
            }
            tables.close();
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, (SQLException)sqlException);
            conn = null;
            String message = "Error querying database for list of tables:" + sqlException.getMessage();
            throw new DataSourceException(message, sqlException);
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Envelope getEnvelope(String typeName) {
        block30: {
            block29: {
                conn = null;
                try {
                    try {
                        conn = this.createConnection();
                        st = null;
                        rs = null;
                        envelope = null;
                        schema = this.getSchema(typeName);
                        geomName = schema.getDefaultGeometry().getName();
                        if (this.getDBInfo().getMajorVersion() >= 1) {
                            dbSchema = this.config.getDatabaseSchemaName();
                            q = this.schemaEnabled == false || dbSchema == null || "".equals(dbSchema) != false ? "SELECT AsText(force_2d(envelope(estimated_extent('" + typeName + "','" + geomName + "'))))" : "SELECT AsText(force_2d(envelope(estimated_extent('" + dbSchema + "','" + typeName + "','" + geomName + "'))))";
                            st = conn.createStatement();
                            rs = st.executeQuery(q);
                            if (rs.next()) {
                                wkt = rs.getString(1);
                                if (wkt != null && !wkt.trim().equals("")) {
                                    envelope = PostgisDataStore.geometryReader.read(wkt).getEnvelopeInternal();
                                    minX = envelope.getMinX();
                                    minY = envelope.getMinY();
                                    maxX = envelope.getMaxX();
                                    maxY = envelope.getMaxY();
                                    deltaX = (maxX - minX) * 0.1;
                                    deltaY = (maxY - minY) * 0.1;
                                    envelope.expandToInclude(minX - deltaX, minY - deltaY);
                                    envelope.expandToInclude(maxX + deltaX, maxY + deltaY);
                                } else {
                                    PostgisDataStore.LOGGER.warning("PostGIS estimated_extent function did not return a result.\nPerhaps 'ANALYZE " + typeName + ";' needs to be run or the table is empty?");
                                }
                            }
                            rs.close();
                            st.close();
                        }
                        if (envelope == null) {
                            envelope = new Envelope();
                            blockSize = 10;
                            fetchAllLimit = 99;
                            offset = new int[]{0, 10, 100, 1000, 10000, 20000, 40000};
                            hits = 0;
                            misses = 0;
                            for (i = 0; i < offset.length && misses < 4; ++i) {
                                limit = " LIMIT 10 OFFSET " + offset[i];
                                if (i + 1 < offset.length && offset[i + 1] - offset[i] <= 10) {
                                    limit = " LIMIT 20 OFFSET " + offset[i];
                                    offset[i + 1] = offset[i] + 10;
                                    ++i;
                                }
                                q = "SELECT AsText(force_2d(envelope(" + geomName + "))) FROM " + typeName;
                                if (offset[i] > -1) {
                                    q = q + limit;
                                }
                                st = conn.createStatement();
                                rs = st.executeQuery(q);
                                gotEnvelope = false;
                                while (rs.next()) {
                                    gotEnvelope = true;
                                    wkt = rs.getString(1);
                                    if (wkt == null || wkt.trim().equals("")) continue;
                                    e = PostgisDataStore.geometryReader.read(wkt).getEnvelopeInternal();
                                    if (envelope.isNull()) {
                                        envelope.init(e);
                                        continue;
                                    }
                                    envelope.expandToInclude(e);
                                }
                                if (gotEnvelope) {
                                    ++hits;
                                } else {
                                    ++misses;
                                    if (hits == 0) {
                                        rs.close();
                                        st.close();
                                        wkt = new Envelope();
                                        var26_36 = null;
                                        if (conn == null) return wkt;
                                        break block29;
                                    }
                                    if (offset[i - 1] < 99) {
                                        offset[i] = -1;
                                    } else {
                                        min = offset[i - 1];
                                        max = offset[i];
                                        if (misses == 2) {
                                            min = offset[i - 2];
                                            max = offset[i - 1];
                                        }
                                        if (misses < 3) {
                                            offset[i] = (int)((double)(min + max) / 2.0);
                                            width = (int)((double)(max - min) / (double)(offset.length - i));
                                            for (j = i + 1; j < offset.length; ++j) {
                                                offset[j] = min + width * (j - i);
                                            }
                                        } else {
                                            rs.close();
                                            st.close();
                                            break;
                                        }
                                    }
                                    --i;
                                }
                                rs.close();
                                st.close();
                                if (offset[i] == -1) break;
                            }
                            minX = envelope.getMinX();
                            minY = envelope.getMinY();
                            maxX = envelope.getMaxX();
                            maxY = envelope.getMaxY();
                            deltaX = (maxX - minX) * 1.0;
                            deltaY = (maxY - minY) * 1.0;
                            envelope.expandToInclude(minX - deltaX, minY - deltaY);
                            envelope.expandToInclude(maxX + deltaX, maxY + deltaY);
                        }
                        var8_14 = envelope;
                        break block30;
                    }
                    catch (Exception ignore) {
                        var4_6 = null;
                        var26_38 = null;
                        if (conn == null) return var4_6;
                        try {
                            conn.close();
                            return var4_6;
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        return var4_6;
                    }
                }
                catch (Throwable var25_45) {
                    var26_39 = null;
                    if (conn == null) throw var25_45;
                    try {}
                    catch (SQLException e) {
                        throw var25_45;
                    }
                    conn.close();
                    throw var25_45;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 1052->1061)] { 
lbl128:
            // 1 sources

            conn.close();
            return wkt;
lbl130:
            // 1 sources

            catch (SQLException e) {
                // empty catch block
            }
            return wkt;
        }
        var26_37 = null;
        if (conn == null) return var8_14;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var8_14;
        }
        conn.close();
        return var8_14;
    }

    protected boolean allowTable(String tablename) {
        if (tablename.equals("geometry_columns")) {
            return false;
        }
        return !tablename.startsWith("spatial_ref_sys");
    }

    protected FeatureType buildSchema(String typeName, FIDMapper mapper) throws IOException {
        Connection conn = this.getConnection(Transaction.AUTO_COMMIT);
        try {
            Statement st = conn.createStatement();
            try {
                st.execute("SELECT * FROM geometry_columns LIMIT 0;");
            }
            catch (Throwable t) {
                String msg = "Error querying relation: geometry_columns. Possible cause:" + t.getLocalizedMessage();
                throw new DataSourceException(msg, t);
            }
            try {
                SQLEncoderPostgis encoder = new SQLEncoderPostgis(-1);
                encoder.setSupportsGEOS(this.useGeos);
                PostgisSQLBuilder builder = new PostgisSQLBuilder(encoder, this.config);
                this.initBuilder(builder);
                st.execute("SELECT * FROM " + builder.encodeTableName(typeName) + " LIMIT 0;");
            }
            catch (Throwable t) {
                String msg = "Error querying relation:" + typeName + "." + " Possible cause:" + t.getLocalizedMessage();
                throw new DataSourceException(msg, t);
            }
            st.close();
        }
        catch (SQLException e) {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, (SQLException)e);
            throw new DataSourceException(e);
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        }
        return super.buildSchema(typeName, mapper);
    }

    /*
     * WARNING - void declaration
     */
    public FeatureReader getFeatureReader(FeatureType requestType, Filter filter, Transaction transaction) throws IOException {
        void var7_7;
        DefaultQuery query;
        String typeName = requestType.getTypeName();
        FeatureType schemaType = this.getSchema(typeName);
        int compare = DataUtilities.compare((FeatureType)requestType, (FeatureType)schemaType);
        if (compare == 0) {
            query = new DefaultQuery(typeName, filter);
        } else if (compare == 1) {
            String[] names = this.attributeNames(requestType, filter);
            query = new DefaultQuery(typeName, filter, Integer.MAX_VALUE, names, "getFeatureReader");
        } else {
            throw new IOException("Type " + typeName + " does match request");
        }
        if (filter == Filter.ALL || filter.equals(Filter.ALL)) {
            return new EmptyFeatureReader(requestType);
        }
        FeatureReader reader = this.getFeatureReader((Query)var7_7, transaction);
        if (compare == 1) {
            reader = new ReTypeFeatureReader(reader, requestType, false);
        }
        return reader;
    }

    protected String[] attributeNames(FeatureType featureType, Filter filter) throws IOException {
        String typeName = featureType.getTypeName();
        FeatureType original = this.getSchema(typeName);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        if (featureType.getAttributeCount() == original.getAttributeCount()) {
            return DataUtilities.attributeNames((FeatureType)featureType);
        }
        String[] typeAttributes = DataUtilities.attributeNames((FeatureType)featureType);
        String[] filterAttributes = DataUtilities.attributeNames((Filter)sqlBuilder.getPostQueryFilter(filter));
        if (filterAttributes == null || filterAttributes.length == 0) {
            return typeAttributes;
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(typeAttributes));
        set.addAll(Arrays.asList(filterAttributes));
        if (set.size() == typeAttributes.length) {
            return typeAttributes;
        }
        return set.toArray(new String[set.size()]);
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        FeatureTypeInfo info = this.typeHandler.getFeatureTypeInfo(typeName);
        int srid = -1;
        SQLEncoderPostgis encoder = new SQLEncoderPostgis();
        encoder.setSupportsGEOS(this.useGeos);
        encoder.setFIDMapper(this.typeHandler.getFIDMapper(typeName));
        if (info.getSchema().getDefaultGeometry() != null) {
            String geom = info.getSchema().getDefaultGeometry().getName();
            srid = info.getSRID(geom);
            encoder.setDefaultGeometry(geom);
        }
        encoder.setSRID(srid);
        encoder.setLooseBbox(this.looseBbox);
        PostgisSQLBuilder builder = new PostgisSQLBuilder(encoder, this.config, info.getSchema());
        this.initBuilder(builder);
        return builder;
    }

    protected void initBuilder(PostgisSQLBuilder builder) {
        builder.setWKBEnabled(this.WKBEnabled);
        builder.setByteaEnabled(this.byteaEnabled);
        builder.setSchemaEnabled(this.schemaEnabled);
    }

    protected int determineSRID(String tableName, String geometryColumnName) throws IOException {
        Connection dbConnection;
        block9: {
            ResultSet result;
            Statement statement;
            String sqlStatement;
            StringBuffer sql;
            String dbSchema;
            block8: {
                dbConnection = null;
                dbSchema = this.config.getDatabaseSchemaName();
                sql = new StringBuffer();
                sql.append("SELECT srid FROM geometry_columns WHERE ");
                if (this.schemaEnabled && dbSchema != null && dbSchema.length() > 0) {
                    sql.append("f_table_schema='");
                    sql.append(dbSchema);
                    sql.append("' AND ");
                }
                sql.append("f_table_name='");
                sql.append(tableName);
                sql.append("' AND f_geometry_column='");
                sql.append(geometryColumnName);
                sql.append("';");
                sqlStatement = sql.toString();
                LOGGER.fine("srid statement is " + sqlStatement);
                dbConnection = this.getConnection(Transaction.AUTO_COMMIT);
                statement = dbConnection.createStatement();
                result = statement.executeQuery(sqlStatement);
                if (!result.next()) break block8;
                int retSrid = result.getInt("srid");
                JDBCUtils.close((Statement)statement);
                int n = retSrid;
                JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
                return n;
            }
            result.close();
            sql = new StringBuffer();
            sql.append("SELECT SRID(\"");
            sql.append(geometryColumnName);
            sql.append("\") FROM \"");
            if (this.schemaEnabled && dbSchema != null && dbSchema.length() > 0) {
                sql.append(dbSchema);
                sql.append("\".\"");
            }
            sql.append(tableName);
            sql.append("\" LIMIT 1");
            sqlStatement = sql.toString();
            result = statement.executeQuery(sqlStatement);
            if (!result.next()) break block9;
            int retSrid = result.getInt(1);
            JDBCUtils.close((Statement)statement);
            int n = retSrid;
            JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
            return n;
        }
        try {
            try {
                String mesg = "No geometry column row for srid in table: " + tableName + ", geometry column " + geometryColumnName;
                throw new DataSourceException(mesg);
            }
            catch (SQLException sqle) {
                String message = sqle.getMessage();
                throw new DataSourceException(message, sqle);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
            throw throwable;
        }
    }

    protected AttributeType buildAttributeType(ResultSet metadataRs) throws IOException {
        try {
            int TABLE_NAME = 3;
            int COLUMN_NAME = 4;
            int TYPE_NAME = 6;
            String typeName = metadataRs.getString(6);
            if (typeName.equals("geometry")) {
                String tableName = metadataRs.getString(3);
                String columnName = metadataRs.getString(4);
                return this.getGeometryAttribute(tableName, columnName);
            }
            return super.buildAttributeType(metadataRs);
        }
        catch (SQLException e) {
            throw new IOException("Sql error occurred: " + e.getMessage());
        }
    }

    protected FIDMapperFactory buildFIDMapperFactory(JDBCDataStoreConfig config) {
        return new PostgisFIDMapperFactory(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FIDMapper buildFIDMapper(String typeName, FIDMapperFactory factory) throws IOException {
        Connection conn = null;
        try {
            FIDMapper mapper;
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            String dbSchema = this.config.getDatabaseSchemaName();
            FIDMapper fIDMapper = mapper = factory.getMapper(null, dbSchema, typeName, conn);
            return fIDMapper;
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    AttributeType getGeometryAttribute(String tableName, String columnName) throws IOException {
        Connection dbConnection = null;
        Class<?> type = null;
        int srid = 0;
        try {
            dbConnection = this.getConnection(Transaction.AUTO_COMMIT);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT type FROM geometry_columns WHERE ");
            String dbSchema = this.config.getDatabaseSchemaName();
            if (this.schemaEnabled && dbSchema != null && dbSchema.length() > 0) {
                sql.append("f_table_schema='");
                sql.append(dbSchema);
                sql.append("' AND ");
            }
            sql.append("f_table_name='");
            sql.append(tableName);
            sql.append("' AND f_geometry_column='");
            sql.append(columnName);
            sql.append("';");
            String sqlStatement = sql.toString();
            LOGGER.fine("geometry type sql statement is " + sqlStatement);
            String geometryType = null;
            Statement statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                geometryType = result.getString("type");
                LOGGER.fine("geometry type is: " + geometryType);
            }
            result.close();
            if (geometryType == null) {
                AttributeIO attrIO;
                Object object;
                sql = new StringBuffer();
                if (this.WKBEnabled) {
                    sql.append("SELECT encode(AsBinary(force_2d(\"");
                    sql.append(columnName);
                    sql.append("\"), 'XDR'),'base64') FROM \"");
                } else {
                    sql.append("SELECT AsText(\"");
                    sql.append(columnName);
                    sql.append("\") FROM \"");
                }
                if (this.schemaEnabled && dbSchema != null && dbSchema.length() > 0) {
                    sql.append(dbSchema);
                    sql.append("\".\"");
                }
                sql.append(tableName);
                sql.append("\" LIMIT 1");
                sqlStatement = sql.toString();
                result = statement.executeQuery(sqlStatement);
                if (result.next() && (object = (attrIO = this.getGeometryAttributeIO(null, null)).read(result, 1)) instanceof Geometry) {
                    Geometry geom = (Geometry)object;
                    geometryType = geom.getGeometryType().toUpperCase();
                    type = geom.getClass();
                    srid = geom.getSRID();
                }
                result.close();
            }
            statement.close();
            if (geometryType == null) {
                String msg = " no geometry found in the GEOMETRY_COLUMNS table for " + tableName + " of the postgis install.  A row" + " for " + columnName + " is required" + " for geotools to work correctly";
                throw new DataSourceException(msg);
            }
            if (type == null) {
                type = (Class<?>)GEOM_TYPE_MAP.get(geometryType);
            }
        }
        catch (SQLException sqe) {
            throw new IOException("An SQL exception occurred: " + sqe.getMessage());
        }
        finally {
            JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
        }
        if (srid < 1) {
            srid = this.determineSRID(tableName, columnName);
        }
        CoordinateReferenceSystem crs = null;
        try {
            crs = this.getPostgisAuthorityFactory().createCRS(srid);
        }
        catch (FactoryException e) {
            crs = null;
        }
        return AttributeTypeFactory.newAttributeType((String)columnName, (Class)type, (boolean)true, (int)0, null, (Object)crs);
    }

    private PostgisAuthorityFactory getPostgisAuthorityFactory() {
        if (this.paf == null) {
            this.paf = new PostgisAuthorityFactory(this.connectionPool);
        }
        return this.paf;
    }

    private String getGeometrySQLTypeName(Class type) {
        String res = (String)GEOM_CLASS_MAPPINGS.get(type);
        if (res == null) {
            throw new RuntimeException("Unknown type name for class " + type + " please update GEOMETRY_MAPPINGS");
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void createSchema(FeatureType featureType) throws IOException {
        String tableName = featureType.getTypeName();
        String lcTableName = tableName.toLowerCase();
        AttributeType[] attributeType = featureType.getAttributeTypes();
        String dbSchema = this.config.getDatabaseSchemaName();
        PostgisSQLBuilder sqlb = this.createSQLBuilder();
        String fidColumn = lcTableName + "_fid";
        for (int i = 0; i < attributeType.length; ++i) {
            if (!attributeType[i].getName().equalsIgnoreCase(fidColumn)) continue;
            String message = "The featuretype cannot contain the column " + fidColumn + ", since this is used as the hidden FID column";
            throw new IOException(message);
        }
        Connection con = this.getConnection(Transaction.AUTO_COMMIT);
        Statement st = null;
        boolean shouldExecute = !this.tablePresent(tableName, con);
        try {
            try {
                con.setAutoCommit(false);
                st = con.createStatement();
                StringBuffer sql = new StringBuffer("CREATE TABLE ");
                sql.append(sqlb.encodeTableName(tableName));
                sql.append(" (");
                sql.append(sqlb.encodeColumnName(fidColumn));
                sql.append(" serial PRIMARY KEY,");
                sql.append(this.makeSqlCreate(attributeType));
                sql.append(");");
                String sqlStr = sql.toString();
                LOGGER.info(sqlStr);
                if (shouldExecute) {
                    st.execute(sqlStr);
                }
                sql = new StringBuffer("DELETE FROM GEOMETRY_COLUMNS WHERE f_table_catalog=''");
                sql.append(" AND f_table_schema = '");
                sql.append(dbSchema);
                sql.append("'");
                sql.append("AND f_table_name = '");
                sql.append(tableName);
                sql.append("';");
                sqlStr = sql.toString();
                LOGGER.info(sqlStr);
                if (shouldExecute) {
                    st.execute(sqlStr);
                }
                for (int i = 0; i < attributeType.length; ++i) {
                    block37: {
                        GeometryAttributeType geomAttribute;
                        block36: {
                            int SRID;
                            String columnName;
                            block34: {
                                if (!(attributeType[i] instanceof GeometryAttributeType)) continue;
                                geomAttribute = (GeometryAttributeType)attributeType[i];
                                columnName = attributeType[i].getName();
                                CoordinateReferenceSystem refSys = geomAttribute.getCoordinateSystem();
                                if (refSys != null) {
                                    try {
                                        Set ident = refSys.getIdentifiers();
                                        if ((ident == null || ident.isEmpty()) && refSys == DefaultGeographicCRS.WGS84) {
                                            SRID = 4326;
                                            break block34;
                                        }
                                        String code = ((NamedIdentifier)ident.toArray()[0]).getCode();
                                        SRID = Integer.parseInt(code);
                                    }
                                    catch (Exception e) {
                                        LOGGER.warning("SRID could not be determined");
                                        SRID = -1;
                                    }
                                } else {
                                    SRID = -1;
                                }
                            }
                            String typeName = null;
                            Class type = geomAttribute.getType();
                            typeName = geomAttribute instanceof GeometryAttributeType ? this.getGeometrySQLTypeName(type) : (String)CLASS_MAPPINGS.get(type);
                            if (typeName == null) break block36;
                            sql = new StringBuffer("INSERT INTO GEOMETRY_COLUMNS VALUES (");
                            sql.append("'','");
                            sql.append(dbSchema);
                            sql.append("','");
                            sql.append(tableName);
                            sql.append("','");
                            sql.append(columnName);
                            sql.append("',2,");
                            sql.append(SRID);
                            sql.append(",'");
                            sql.append(typeName);
                            sql.append("');");
                            sqlStr = sql.toString();
                            LOGGER.info(sqlStr);
                            if (shouldExecute) {
                                st.execute(sqlStr);
                            }
                            if (SRID > -1) {
                                sql = new StringBuffer("ALTER TABLE ");
                                sql.append(sqlb.encodeTableName(tableName));
                                sql.append(" ADD CONSTRAINT ");
                                sql.append(sqlb.encodeColumnName("enforce_srid_" + columnName));
                                sql.append(" CHECK (SRID(");
                                sql.append(sqlb.encodeColumnName(columnName));
                                sql.append(") = ");
                                sql.append(SRID);
                                sql.append(");");
                                sqlStr = sql.toString();
                                LOGGER.info(sqlStr);
                                if (shouldExecute) {
                                    st.execute(sqlStr);
                                }
                            }
                            sql = new StringBuffer("ALTER TABLE ");
                            sql.append(sqlb.encodeTableName(tableName));
                            sql.append(" ADD CONSTRAINT ");
                            sql.append(sqlb.encodeColumnName("enforce_dims_" + columnName));
                            sql.append(" CHECK (ndims(");
                            sql.append(sqlb.encodeColumnName(columnName));
                            sql.append(") = 2);");
                            sqlStr = sql.toString();
                            LOGGER.info(sqlStr);
                            if (shouldExecute) {
                                st.execute(sqlStr);
                            }
                            if (!typeName.equals("GEOMETRY")) {
                                sql = new StringBuffer("ALTER TABLE ");
                                sql.append(sqlb.encodeTableName(tableName));
                                sql.append(" ADD CONSTRAINT ");
                                sql.append(sqlb.encodeColumnName("enforce_geotype_" + columnName));
                                sql.append(" CHECK (geometrytype(");
                                sql.append(sqlb.encodeColumnName(columnName));
                                sql.append(") = '");
                                sql.append(typeName);
                                sql.append("'::text OR ");
                                sql.append(sqlb.encodeColumnName(columnName));
                                sql.append(" IS NULL);");
                                sqlStr = sql.toString();
                                LOGGER.info(sqlStr);
                                if (shouldExecute) {
                                    st.execute(sqlStr);
                                }
                            }
                            break block37;
                        }
                        LOGGER.warning("Error: " + geomAttribute.getName() + " unknown type!!!");
                    }
                    sql = new StringBuffer("CREATE INDEX spatial_");
                    sql.append(tableName);
                    sql.append("_");
                    sql.append(attributeType[i].getName().toLowerCase());
                    sql.append(" ON ");
                    sql.append(sqlb.encodeTableName(tableName));
                    sql.append(" USING GIST (");
                    sql.append(sqlb.encodeColumnName(attributeType[i].getName()));
                    sql.append(");");
                    sqlStr = sql.toString();
                    LOGGER.info(sqlStr);
                    if (!shouldExecute) continue;
                    st.execute(sqlStr);
                }
                con.commit();
            }
            catch (SQLException e) {
                try {
                    if (con == null) throw (IOException)new IOException(e.getMessage()).initCause(e);
                    con.rollback();
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
                catch (SQLException sqle) {
                    throw new IOException(sqle.getMessage());
                }
            }
            Object var21_25 = null;
            try {
                block35: {
                    try {
                        if (st == null) break block35;
                        st.close();
                    }
                    catch (SQLException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                Object var24_27 = null;
                try {
                    if (con != null) {
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (SQLException e) {
                    throw new IOException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var24_28 = null;
                try {}
                catch (SQLException e) {
                    throw new IOException(e.getMessage());
                }
                if (con == null) throw throwable;
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var21_26 = null;
            try {}
            catch (Throwable throwable2) {
                Object var24_30 = null;
                try {}
                catch (SQLException e) {
                    throw new IOException(e.getMessage());
                }
                if (con == null) throw throwable2;
                con.setAutoCommit(true);
                con.close();
                throw throwable2;
            }
            try {}
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
            if (st != null) {
                st.close();
            }
            Object var24_29 = null;
            try {}
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
            if (con == null) throw throwable;
            con.setAutoCommit(true);
            con.close();
            throw throwable;
        }
        if (shouldExecute) return;
        throw new IOException("The table " + tableName + " already exists.");
    }

    private StringBuffer makeSqlCreate(AttributeType[] attributeType) throws IOException {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < attributeType.length; ++i) {
            String typeName = null;
            typeName = (String)CLASS_MAPPINGS.get(attributeType[i].getType());
            if (typeName == null) {
                typeName = (String)GEOM_CLASS_MAPPINGS.get(attributeType[i].getType());
            }
            if (typeName != null) {
                Object defaultValue;
                if (attributeType[i] instanceof GeometryAttributeType) {
                    typeName = "GEOMETRY";
                } else if (typeName.equals("VARCHAR")) {
                    int length = -1;
                    Filter f = attributeType[i].getRestriction();
                    if (f != null && f != Filter.ALL && f != Filter.NONE && (f.getFilterType() == 15 || f.getFilterType() == 17)) {
                        try {
                            CompareFilter cf = (CompareFilter)f;
                            if (cf.getLeftValue() instanceof LengthFunction) {
                                length = Integer.parseInt(((LiteralExpression)cf.getRightValue()).getLiteral().toString());
                            } else if (cf.getRightValue() instanceof LengthFunction) {
                                length = Integer.parseInt(((LiteralExpression)cf.getLeftValue()).getLiteral().toString());
                            }
                        }
                        catch (NumberFormatException e) {
                            length = 256;
                        }
                    } else {
                        length = 256;
                    }
                    if (length < 1) {
                        LOGGER.warning("FeatureType did not specify string length; defaulted to 256");
                        length = 256;
                    } else if (length > 0xA00000) {
                        length = 0xA00000;
                    }
                    typeName = typeName + "(" + length + ")";
                }
                if (!attributeType[i].isNillable()) {
                    typeName = typeName + " NOT NULL";
                }
                if ((defaultValue = attributeType[i].createDefaultValue()) != null) {
                    typeName = typeName + " DEFAULT '" + defaultValue.toString() + "'";
                }
            } else {
                String msg = attributeType[i] == null ? "AttributeType was null!" : "Type '" + attributeType[i].getType() + "' not supported!";
                throw new IOException(msg);
            }
            buf.append(" \"" + attributeType[i].getName() + "\" " + typeName + ",");
        }
        return buf.deleteCharAt(buf.length() - 1);
    }

    private boolean tablePresent(String table, Connection con) throws IOException {
        int TABLE_NAME_COL = 3;
        Connection conn = null;
        try {
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            DatabaseMetaData meta = conn.getMetaData();
            String[] tableType = new String[]{"TABLE"};
            ResultSet tables = meta.getTables(null, this.config.getDatabaseSchemaName(), "%", tableType);
            while (tables.next()) {
                String tableName = tables.getString(3);
                if (!this.allowTable(tableName) || tableName == null || !tableName.equalsIgnoreCase(table)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, (SQLException)sqlException);
            conn = null;
            String message = "Error querying database for list of tables:" + sqlException.getMessage();
            throw new DataSourceException(message, sqlException);
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    public void updateSchema(String typeName, FeatureType featureType) throws IOException {
        throw new IOException("PostgisDataStore.updateSchema not yet implemented");
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        if (!this.typeHandler.getFIDMapper(typeName).isVolatile() || this.allowWriteOnVolatileFIDs) {
            LOGGER.fine("get Feature source called on " + typeName);
            if (this.OPTIMIZE_MODE == 1) {
                LOGGER.fine("returning pg feature locking");
                return this.createFeatureLockingInternal(this, this.getSchema(typeName));
            }
            if (this.getLockingManager() != null) {
                LOGGER.fine("returning jdbc feature locking");
                return new JDBCFeatureLocking((JDBC1DataStore)this, this.getSchema(typeName));
            }
            LOGGER.fine("returning jdbc feature store (lock manager is null)");
            return new JDBCFeatureStore((JDBC1DataStore)this, this.getSchema(typeName));
        }
        return new JDBCFeatureSource((JDBC1DataStore)this, this.getSchema(typeName));
    }

    public PostgisFeatureLocking createFeatureLockingInternal(PostgisDataStore ds, FeatureType type) throws IOException {
        return new PostgisFeatureLocking(ds, type);
    }

    protected JDBCFeatureWriter createFeatureWriter(FeatureReader fReader, QueryData queryData) throws IOException {
        PostgisSQLBuilder sqlBuilder = (PostgisSQLBuilder)this.getSqlBuilder(fReader.getFeatureType().getTypeName());
        PostgisFeatureWriter postgisFeatureWriter = new PostgisFeatureWriter(fReader, queryData, this.WKBEnabled, this.byteaWKB, sqlBuilder);
        postgisFeatureWriter.setFeatureListenerManager(this.listenerManager);
        return postgisFeatureWriter;
    }

    public FeatureWriter getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getFeatureWriter(typeName, Filter.NONE, transaction);
    }

    public FeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        FeatureWriter writer = this.getFeatureWriter(typeName, Filter.ALL, transaction);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    int getSRID(String typeName, String geomColName) throws IOException {
        return this.typeHandler.getFeatureTypeInfo(typeName).getSRID(geomColName);
    }

    protected AttributeIO getGeometryAttributeIO(AttributeType type, QueryData queryData) {
        if (this.WKBEnabled) {
            return new PgWKBAttributeIO(this.isByteaEnabled());
        }
        return new WKTAttributeIO();
    }

    protected int getResultSetType(boolean forWrite) {
        return 1003;
    }

    protected int getConcurrency(boolean forWrite) {
        return 1007;
    }

    public boolean isWKBEnabled() {
        return this.WKBEnabled;
    }

    public void setWKBEnabled(boolean enabled) {
        this.WKBEnabled = enabled;
    }

    public void setLooseBbox(boolean isLooseBbox) {
        this.looseBbox = isLooseBbox;
    }

    public boolean isLooseBbox() {
        return this.looseBbox;
    }

    public boolean isByteaEnabled() {
        return this.byteaEnabled;
    }

    public void setByteaWKB(boolean byteaWKB) {
        this.byteaWKB = byteaWKB;
    }

    public boolean isByteaWKB() {
        return this.byteaWKB;
    }

    public void setByteaEnabled(boolean byteaEnabled) {
        this.byteaEnabled = byteaEnabled;
    }

    public void setEstimatedExtent(boolean estimatedExtent) {
        this.estimatedExtent = estimatedExtent;
        if (estimatedExtent) {
            LOGGER.info("Setting OPTIMIZE_MODE to 'SQL'");
            this.setOptimizeMode(1);
        }
    }

    public boolean isEstimatedExtent() {
        return this.estimatedExtent;
    }

    public void setOptimizeMode(int mode) {
        this.OPTIMIZE_MODE = mode;
    }

    public int getOptimizeMode() {
        return this.OPTIMIZE_MODE;
    }

    public FeatureType getSchema(String arg0) throws IOException {
        return super.getSchema(arg0);
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public PostgisDBInfo getDBInfo() {
        if (this.dbInfo == null) {
            try {
                Connection conn = this.getConnection(Transaction.AUTO_COMMIT);
                this.dbInfo = new PostgisDBInfo(conn);
            }
            catch (IOException e1) {
                LOGGER.severe("Could not obtain DBInfo object");
            }
        }
        return this.dbInfo;
    }

    static {
        GEOM_TYPE_MAP.put("GEOMETRY", Geometry.class);
        GEOM_TYPE_MAP.put("POINT", Point.class);
        GEOM_TYPE_MAP.put("LINESTRING", LineString.class);
        GEOM_TYPE_MAP.put("POLYGON", Polygon.class);
        GEOM_TYPE_MAP.put("MULTIPOINT", MultiPoint.class);
        GEOM_TYPE_MAP.put("MULTILINESTRING", MultiLineString.class);
        GEOM_TYPE_MAP.put("MULTIPOLYGON", MultiPolygon.class);
        GEOM_TYPE_MAP.put("GEOMETRYCOLLECTION", GeometryCollection.class);
        CLASS_MAPPINGS = new HashMap();
        CLASS_MAPPINGS.put(String.class, "VARCHAR");
        CLASS_MAPPINGS.put(Boolean.class, "BOOLEAN");
        CLASS_MAPPINGS.put(Integer.class, "INTEGER");
        CLASS_MAPPINGS.put(Float.class, "REAL");
        CLASS_MAPPINGS.put(Double.class, "DOUBLE PRECISION");
        CLASS_MAPPINGS.put(BigDecimal.class, "DECIMAL");
        CLASS_MAPPINGS.put(Date.class, "DATE");
        CLASS_MAPPINGS.put(java.util.Date.class, "DATE");
        CLASS_MAPPINGS.put(Time.class, "TIME");
        CLASS_MAPPINGS.put(Timestamp.class, "TIMESTAMP");
        GEOM_CLASS_MAPPINGS = new HashMap();
        Set keys = GEOM_TYPE_MAP.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Class geomClass = (Class)GEOM_TYPE_MAP.get(name);
            GEOM_CLASS_MAPPINGS.put(geomClass, name);
        }
    }
}

