/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.postgis.PostgisConnectionFactory;
import org.geotools.data.postgis.PostgisDataStore;

public class PostgisDataStoreFactory
extends AbstractDataStoreFactory
implements DataStoreFactorySpi {
    private static final String DRIVER_CLASS = "org.postgresql.Driver";
    public static final DataStoreFactorySpi.Param DBTYPE = new DataStoreFactorySpi.Param("dbtype", String.class, "must be 'postgis'", true, "postgis");
    public static final DataStoreFactorySpi.Param HOST = new DataStoreFactorySpi.Param("host", String.class, "postgis host machine", true, "localhost");
    public static final DataStoreFactorySpi.Param PORT = new DataStoreFactorySpi.Param("port", Integer.class, "postgis connection port (default is 5432)", true, new Integer(5432));
    public static final DataStoreFactorySpi.Param DATABASE = new DataStoreFactorySpi.Param("database", String.class, "postgis database");
    public static final DataStoreFactorySpi.Param SCHEMA = new DataStoreFactorySpi.Param("schema", String.class, "postgis schema", false, "public");
    public static final DataStoreFactorySpi.Param USER = new DataStoreFactorySpi.Param("user", String.class, "user name to login as");
    public static final DataStoreFactorySpi.Param PASSWD = new DataStoreFactorySpi.Param("passwd", String.class, "password used to login", false);
    public static final DataStoreFactorySpi.Param NAMESPACE = new DataStoreFactorySpi.Param("namespace", String.class, "namespace prefix used", false);
    public static final DataStoreFactorySpi.Param WKBENABLED = new DataStoreFactorySpi.Param("wkb enabled", Boolean.class, "set to true if Well Known Binary should be used to read PostGIS data (experimental)", false, new Boolean(true));
    public static final DataStoreFactorySpi.Param LOOSEBBOX = new DataStoreFactorySpi.Param("loose bbox", Boolean.class, "set to true if the Bounding Box should be 'loose', faster but not as deadly accurate", false, new Boolean(true));
    public static final DataStoreFactorySpi.Param ESTIMATEDEXTENT = new DataStoreFactorySpi.Param("estimated extent", Boolean.class, "set to true if the bounds for a table should be computed using the 'estimated_extent' function, but beware that this function is less accurate, and in some cases *far* less accurate if the data within the actual bounds does not follow a uniform distribution. It also relies on the fact that you haveaccurate table stats available. So it is a good idea to 'VACUUM ANALYZE' the postgis table.", false, new Boolean(false));

    public boolean canProcess(Map params) {
        if (!super.canProcess(params)) {
            return false;
        }
        return ((String)params.get("dbtype")).equalsIgnoreCase("postgis");
    }

    public DataStore createDataStore(Map params) throws IOException {
        ConnectionPool pool;
        String host = (String)HOST.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        String schema = (String)SCHEMA.lookUp(params);
        String database = (String)DATABASE.lookUp(params);
        Boolean wkb_enabled = (Boolean)WKBENABLED.lookUp(params);
        Boolean is_loose_bbox = (Boolean)LOOSEBBOX.lookUp(params);
        Boolean is_estimated_extent = (Boolean)ESTIMATEDEXTENT.lookUp(params);
        String namespace = (String)NAMESPACE.lookUp(params);
        if (!this.canProcess(params)) {
            throw new IOException("The parameters map isn't correct!!");
        }
        PostgisConnectionFactory connFact = new PostgisConnectionFactory(host, port.toString(), database);
        connFact.setLogin(user, passwd);
        try {
            pool = connFact.getConnectionPool();
        }
        catch (SQLException e) {
            throw new DataSourceException("Could not create connection", e);
        }
        PostgisDataStore dataStore = this.createDataStoreInternal(pool, namespace, schema);
        if (wkb_enabled != null) {
            dataStore.setWKBEnabled(wkb_enabled);
        }
        if (is_loose_bbox != null) {
            dataStore.setLooseBbox(is_loose_bbox);
        }
        if (is_estimated_extent != null) {
            dataStore.setOptimizeMode(1);
            dataStore.setEstimatedExtent(is_estimated_extent);
        }
        return dataStore;
    }

    protected PostgisDataStore createDataStoreInternal(ConnectionPool pool, String namespace, String schema) throws IOException {
        if (schema == null && namespace == null) {
            return new PostgisDataStore(pool);
        }
        if (schema == null && namespace != null) {
            return new PostgisDataStore(pool, namespace);
        }
        return new PostgisDataStore(pool, schema, namespace);
    }

    protected PostgisDataStore createDataStoreInternal(ConnectionPool pool) throws IOException {
        return this.createDataStoreInternal(pool, null, null);
    }

    protected PostgisDataStore createDataStoreInternal(ConnectionPool pool, String namespace) throws IOException {
        return this.createDataStoreInternal(pool, namespace, null);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Postgis cannot create a new Database");
    }

    public String getDisplayName() {
        return "Postgis";
    }

    public String getDescription() {
        return "PostGIS spatial database";
    }

    public boolean isAvailable() {
        try {
            Class.forName(DRIVER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{DBTYPE, HOST, PORT, SCHEMA, DATABASE, USER, PASSWD, WKBENABLED, LOOSEBBOX, ESTIMATEDEXTENT, NAMESPACE};
    }
}

