/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.postgis.PostgisDataStore;
import org.geotools.data.postgis.PostgisSQLBuilder;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLEncoderPostgis;
import org.geotools.filter.SQLUnpacker;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class PostgisFeatureStore
extends JDBCFeatureStore {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.postgis");
    protected static WKTWriter geometryWriter = new WKTWriter();
    protected static GeometryFactory geometryFactory = new GeometryFactory();
    protected static WKTReader geometryReader = new WKTReader(geometryFactory);
    protected static final String CONN_ERROR = "Some sort of database connection error: ";
    protected PostgisSQLBuilder sqlBuilder;
    protected SQLEncoderPostgis encoder;
    protected String tableName;
    protected FIDMapper fidMapper;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public PostgisFeatureStore(PostgisDataStore postgisDataStore, FeatureType featureType) throws IOException {
        super((JDBC1DataStore)postgisDataStore, featureType);
        this.tableName = featureType.getTypeName();
        this.fidMapper = postgisDataStore.getFIDMapper(this.tableName);
        this.sqlBuilder = (PostgisSQLBuilder)postgisDataStore.getSqlBuilder(this.tableName);
        GeometryAttributeType geomType = featureType.getDefaultGeometry();
        this.encoder = new SQLEncoderPostgis();
        this.encoder.setFIDMapper(postgisDataStore.getFIDMapper(featureType.getTypeName()));
        if (geomType != null) {
            int srid = this.getSRID(geomType.getName());
            this.encoder.setDefaultGeometry(geomType.getName());
            this.encoder.setSRID(srid);
            this.encoder.setFIDMapper(this.fidMapper);
        }
    }

    protected int getSRID(String geomName) throws IOException {
        return this.getPostgisDataStore().getSRID(this.tableName, geomName);
    }

    private String addQuotes(Object value) {
        String retString = value != null ? "'" + value.toString() + "'" : "null";
        return retString;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFeatures(Filter filter) throws IOException {
        String sql = "";
        String whereStmt = null;
        this.assertFilter(filter);
        Filter encodableFilter = this.sqlBuilder.getPreQueryFilter(filter);
        Filter unEncodableFilter = this.sqlBuilder.getPostQueryFilter(filter);
        Statement statement = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            statement = conn.createStatement();
            if (encodableFilter == null && unEncodableFilter != null) {
                encodableFilter = this.getEncodableFilter(unEncodableFilter);
            }
            if (encodableFilter != null) {
                whereStmt = this.encoder.encode(encodableFilter);
                sql = "DELETE from " + this.sqlBuilder.encodeTableName(this.tableName) + whereStmt + ";";
                LOGGER.fine("sql statment is " + sql);
                DefaultQuery query = new DefaultQuery(this.getSchema().getTypeName(), filter);
                ReferencedEnvelope bounds = this.bounds((Query)query);
                statement.executeUpdate(sql);
                if (bounds != null && !bounds.isNull()) {
                    this.getJDBCDataStore().listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), (Envelope)bounds, false);
                }
            }
            this.close(statement);
        }
        catch (SQLException sqle) {
            try {
                this.close(conn, this.getTransaction(), sqle);
                String message = CONN_ERROR + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, sqle);
                catch (SQLEncoderException ence) {
                    message = "error encoding sql from filter " + ence.getMessage();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, ence);
                }
                catch (IllegalAttributeException iae) {
                    throw new DataSourceException("attribute problem", iae);
                }
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(conn, this.getTransaction(), null);
                throw throwable;
            }
        }
        this.close(statement);
        this.close(conn, this.getTransaction(), null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyFeatures(AttributeType[] type, Object[] value, Filter filter) throws IOException {
        Statement statement;
        Connection conn;
        block11: {
            LOGGER.info("asserting filter " + filter);
            this.assertFilter(filter);
            boolean fail = false;
            conn = null;
            statement = null;
            String sql = "";
            Object fid = null;
            String whereStmt = null;
            Filter encodableFilter = this.sqlBuilder.getPreQueryFilter(filter);
            Filter unEncodableFilter = this.sqlBuilder.getPostQueryFilter(filter);
            try {
                conn = this.getConnection();
                statement = conn.createStatement();
                if (encodableFilter == null && unEncodableFilter != null) {
                    FidFilter fidFilter = this.getEncodableFilter(unEncodableFilter);
                    encodableFilter = fidFilter;
                }
                if (encodableFilter == null) break block11;
                whereStmt = this.encoder.encode(encodableFilter);
                sql = this.makeModifySql(type, value, whereStmt);
                LOGGER.finer("encoded modify is " + sql);
                DefaultQuery query = new DefaultQuery(this.getSchema().getTypeName(), filter);
                ReferencedEnvelope bounds = this.bounds((Query)query);
                statement.executeUpdate(sql);
                if (bounds != null && !bounds.isNull()) {
                    ReferencedEnvelope afterBounds = this.bounds((Query)query);
                    if (afterBounds != null) {
                        bounds.expandToInclude((Envelope)afterBounds);
                    }
                } else {
                    bounds = this.bounds((Query)query);
                }
                if (bounds != null && !bounds.isNull()) {
                    this.getJDBCDataStore().listenerManager.fireFeaturesChanged(this.getSchema().getTypeName(), this.getTransaction(), (Envelope)bounds, false);
                }
            }
            catch (SQLException sqle) {
                try {
                    fail = true;
                    this.close(conn, this.getTransaction(), sqle);
                    String message = CONN_ERROR + sqle.getMessage();
                    LOGGER.warning(message);
                    throw new DataSourceException(message, sqle);
                    catch (SQLEncoderException ence) {
                        fail = true;
                        message = "error encoding sql from filter " + ence.getMessage();
                        LOGGER.warning(message);
                        throw new DataSourceException(message, ence);
                    }
                    catch (IllegalAttributeException iae) {
                        throw new DataSourceException("attribute problem", iae);
                    }
                }
                catch (Throwable throwable) {
                    this.close(statement);
                    this.close(conn, this.getTransaction(), null);
                    throw throwable;
                }
            }
        }
        this.close(statement);
        this.close(conn, this.getTransaction(), null);
    }

    private FidFilter getEncodableFilter(Filter unEncodableFilter) throws IOException, FactoryConfigurationError, IllegalAttributeException {
        DefaultQuery query = new DefaultQuery();
        query.setPropertyNames(new String[0]);
        query.setFilter(unEncodableFilter);
        FeatureCollection features = this.getFeatures(unEncodableFilter);
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        FidFilter fidFilter = ff.createFidFilter();
        FeatureReader it = features.reader();
        while (it.hasNext()) {
            Feature feature = it.next();
            fidFilter.addFid(feature.getID());
        }
        return fidFilter;
    }

    private String formatFid(Feature feature) {
        String fid = feature.getID();
        if (fid.startsWith(this.tableName)) {
            fid = fid.substring(this.tableName.length() + 1);
        }
        return this.addQuotes(fid);
    }

    public void modifyFeatures(AttributeType type, Object value, Filter filter) throws IOException {
        AttributeType[] singleType = new AttributeType[]{type};
        Object[] singleVal = new Object[]{value};
        this.modifyFeatures(singleType, singleVal, filter);
    }

    private String makeModifySql(AttributeType[] types, Object[] values, String whereStmt) throws IOException {
        int arrLength = types.length;
        if (arrLength == values.length) {
            StringBuffer sqlStatement = new StringBuffer("UPDATE ");
            sqlStatement.append(this.sqlBuilder.encodeTableName(this.tableName) + " SET ");
            for (int i = 0; i < arrLength; ++i) {
                String newValue;
                AttributeType curType = types[i];
                Object curValue = values[i];
                if (curType instanceof GeometryAttributeType) {
                    int srid = this.getSRID(curType.getName());
                    String geoText = geometryWriter.write((Geometry)curValue);
                    newValue = "GeometryFromText('" + geoText + "', " + srid + ")";
                } else {
                    newValue = this.addQuotes(curValue);
                }
                sqlStatement.append(this.sqlBuilder.encodeColumnName(curType.getName()) + " = " + newValue);
                sqlStatement.append(i < arrLength - 1 ? ", " : " ");
            }
            sqlStatement.append(whereStmt + ";");
            return sqlStatement.toString();
        }
        throw new IOException("length of value array is not same length as type array");
    }

    protected PostgisDataStore getPostgisDataStore() {
        return (PostgisDataStore)super.getJDBCDataStore();
    }

    public String makeSql(SQLUnpacker unpacker, Query query) throws IOException {
        int i;
        boolean useLimit = unpacker.getUnSupported() == null;
        Filter filter = unpacker.getSupported();
        LOGGER.fine("Filter in making sql is " + filter);
        AttributeType[] attributeTypes = this.getAttTypes(query);
        int numAttributes = attributeTypes.length;
        StringBuffer sqlStatement = new StringBuffer("SELECT ");
        if (!this.fidMapper.returnFIDColumnsAsAttributes()) {
            for (i = 0; i < this.fidMapper.getColumnCount(); ++i) {
                sqlStatement.append(this.fidMapper.getColumnName(i));
                if (numAttributes <= 0 && i >= this.fidMapper.getColumnCount() - 1) continue;
                sqlStatement.append(", ");
            }
        }
        LOGGER.finer("making sql for " + numAttributes + " attributes");
        for (i = 0; i < numAttributes; ++i) {
            String curAttName = attributeTypes[i].getName();
            if ((class$com$vividsolutions$jts$geom$Geometry == null ? PostgisFeatureStore.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(attributeTypes[i].getType())) {
                sqlStatement.append(", AsText(force_2d(\"" + curAttName + "\"))");
                continue;
            }
            sqlStatement.append(", \"" + curAttName + "\"");
        }
        String where = "";
        if (filter != null) {
            try {
                where = this.encoder.encode(filter);
            }
            catch (SQLEncoderException sqle) {
                String message = "Encoder error" + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, sqle);
            }
        }
        String limit = "";
        if (useLimit) {
            limit = " LIMIT " + query.getMaxFeatures();
        }
        sqlStatement.append(" FROM \"" + this.tableName + "\" " + where + limit + ";").toString();
        LOGGER.fine("sql statement is " + sqlStatement);
        return sqlStatement.toString();
    }

    public String makeSql(Query query) throws IOException {
        int i;
        Filter encodableFilter = this.sqlBuilder.getPreQueryFilter(query.getFilter());
        Filter unEncodableFilter = this.sqlBuilder.getPostQueryFilter(query.getFilter());
        boolean useLimit = unEncodableFilter == null || unEncodableFilter.equals(Filter.NONE);
        LOGGER.fine("Filter in making sql is " + encodableFilter);
        AttributeType[] attributeTypes = this.getAttTypes(query);
        int numAttributes = attributeTypes.length;
        StringBuffer sqlStatement = new StringBuffer("SELECT ");
        if (!this.fidMapper.returnFIDColumnsAsAttributes()) {
            for (i = 0; i < this.fidMapper.getColumnCount(); ++i) {
                sqlStatement.append(this.fidMapper.getColumnName(i));
                if (numAttributes <= 0 && i >= this.fidMapper.getColumnCount() - 1) continue;
                sqlStatement.append(", ");
            }
        }
        LOGGER.finer("making sql for " + numAttributes + " attributes");
        for (i = 0; i < numAttributes; ++i) {
            String curAttName = attributeTypes[i].getName();
            if ((class$com$vividsolutions$jts$geom$Geometry == null ? PostgisFeatureStore.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(attributeTypes[i].getType())) {
                sqlStatement.append(", AsText(force_2d(\"" + curAttName + "\"))");
                continue;
            }
            sqlStatement.append(", \"" + curAttName + "\"");
        }
        String where = "";
        if (encodableFilter != null) {
            try {
                where = this.encoder.encode(encodableFilter);
            }
            catch (SQLEncoderException sqle) {
                String message = "Encoder error" + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, sqle);
            }
        }
        String limit = "";
        if (useLimit) {
            limit = " LIMIT " + query.getMaxFeatures();
        }
        this.sqlBuilder.sqlFrom(sqlStatement, this.tableName);
        sqlStatement.append(where + limit + ";");
        LOGGER.fine("sql statement is " + sqlStatement);
        return sqlStatement.toString();
    }

    private AttributeType[] getAttTypes(Query query) throws IOException {
        AttributeType[] schemaTypes = this.getSchema().getAttributeTypes();
        if (query.retrieveAllProperties()) {
            return schemaTypes;
        }
        List<String> attNames = Arrays.asList(query.getPropertyNames());
        AttributeType[] retAttTypes = new AttributeType[attNames.size()];
        int retPos = 0;
        int n = schemaTypes.length;
        for (int i = 0; i < n; ++i) {
            String schemaTypeName = schemaTypes[i].getName();
            if (!attNames.contains(schemaTypeName)) continue;
            retAttTypes[retPos++] = schemaTypes[i];
        }
        if (attNames.size() != retPos) {
            String msg = "attempted to request a property, " + attNames.get(0) + " that is not part of the schema ";
            throw new IOException(msg);
        }
        return retAttTypes;
    }

    public Envelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public Envelope getBounds(Query query) throws IOException {
        return this.bounds(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReferencedEnvelope bounds(Query query) throws IOException {
        Filter preFilter;
        Filter filter = query.getFilter();
        if (filter == Filter.ALL) {
            return new ReferencedEnvelope(new Envelope(), query.getCoordinateSystem());
        }
        FeatureType schema = this.getSchema();
        JDBCDataStore jdbc = (JDBCDataStore)this.getJDBCDataStore();
        SQLBuilder sqlBuilder = jdbc.getSqlBuilder(schema.getTypeName());
        Filter postQueryFilter = sqlBuilder.getPostQueryFilter(query.getFilter());
        if (postQueryFilter != null && !postQueryFilter.equals(Filter.NONE)) {
            return null;
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            Envelope retEnv = new Envelope();
            preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
            AttributeType[] attributeTypes = schema.getAttributeTypes();
            FeatureType schemaNew = schema;
            if (!query.retrieveAllProperties()) {
                try {
                    schemaNew = DataUtilities.createSubType((FeatureType)schema, (String[])query.getPropertyNames());
                    if (schemaNew.getDefaultGeometry() == null && schema.getDefaultGeometry() != null) {
                        ArrayList<String> al = new ArrayList<String>(Arrays.asList(query.getPropertyNames()));
                        al.add(schema.getDefaultGeometry().getName());
                        schemaNew = DataUtilities.createSubType((FeatureType)schema, (String[])al.toArray(new String[1]));
                    }
                }
                catch (SchemaException e1) {
                    throw new DataSourceException("Could not create subtype", e1);
                }
            }
            attributeTypes = schemaNew.getAttributeTypes();
            int n = schemaNew.getAttributeCount();
            for (int j = 0; j < n; ++j) {
                if (!(class$com$vividsolutions$jts$geom$Geometry == null ? PostgisFeatureStore.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(attributeTypes[j].getType())) continue;
                String attName = attributeTypes[j].getName();
                Envelope curEnv = this.getEnvelope(conn, attName, sqlBuilder, filter);
                if (curEnv == null) {
                    ReferencedEnvelope referencedEnvelope = null;
                    return referencedEnvelope;
                }
                retEnv.expandToInclude(curEnv);
            }
            LOGGER.finer("returning bounds " + retEnv);
            if (schemaNew != null && schemaNew.getDefaultGeometry() != null) {
                ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(retEnv, schemaNew.getDefaultGeometry().getCoordinateSystem());
                return referencedEnvelope;
            }
            if (query.getCoordinateSystem() != null) {
                ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(retEnv, query.getCoordinateSystem());
                return referencedEnvelope;
            }
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(retEnv, null);
            return referencedEnvelope;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close((Connection)conn, (Transaction)this.transaction, (SQLException)sqlException);
            conn = null;
            throw new DataSourceException("Could not count " + query.getHandle(), sqlException);
        }
        catch (SQLEncoderException e) {
            preFilter = null;
            return preFilter;
        }
        catch (ParseException parseE) {
            String message = "Could not read geometry: " + parseE.getMessage();
            ReferencedEnvelope referencedEnvelope = null;
            return referencedEnvelope;
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)this.transaction, null);
        }
    }

    protected Envelope getEnvelope(Connection conn, String geomName, SQLBuilder sqlBuilder, Filter filter) throws SQLException, SQLEncoderException, IOException, ParseException {
        boolean useEstimatedExtent;
        String typeName = this.getSchema().getTypeName();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT AsText(force_2d(Envelope(");
        boolean bl = useEstimatedExtent = (filter == null || filter == Filter.NONE) && ((PostgisDataStore)this.getDataStore()).isEstimatedExtent();
        if (useEstimatedExtent) {
            sql.append("estimated_extent(");
            sql.append("'" + typeName + "','" + geomName + "'))));");
        } else {
            sql.append("Extent(\"" + geomName + "\")))) ");
            sqlBuilder.sqlFrom(sql, typeName);
            sqlBuilder.sqlWhere(sql, filter);
        }
        LOGGER.fine("SQL: " + sql);
        Statement statement = conn.createStatement();
        ResultSet results = statement.executeQuery(sql.toString());
        results.next();
        String wkt = results.getString(1);
        Envelope retEnv = null;
        if (wkt == null) {
            return null;
        }
        retEnv = geometryReader.read(wkt).getEnvelopeInternal();
        results.close();
        statement.close();
        return retEnv;
    }
}

