/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCTextFeatureWriter;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.postgis.PostgisSQLBuilder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.SQLEncoderException;

public class PostgisFeatureWriter
extends JDBCTextFeatureWriter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    protected static WKTWriter geometryWriter = new WKTWriter();
    private boolean WKBEnabled;
    private boolean byteaWKB;
    private PostgisSQLBuilder sqlBuilder;

    public PostgisFeatureWriter(FeatureReader fReader, QueryData queryData, boolean WKBEnabled, boolean byteaWKB, PostgisSQLBuilder sqlBuilder) throws IOException {
        super(fReader, queryData);
        this.WKBEnabled = WKBEnabled;
        this.byteaWKB = byteaWKB;
        this.sqlBuilder = sqlBuilder;
    }

    protected String getGeometryInsertText(Geometry geom, int srid) throws IOException {
        if (this.WKBEnabled) {
            String wkb = WKBWriter.bytesToHex((byte[])new WKBWriter().write(geom));
            if (this.byteaWKB) {
                return "setSRID('" + wkb + "'::geometry," + srid + ")";
            }
            return "GeomFromWKB('" + wkb + "', " + srid + ")";
        }
        String geoText = geometryWriter.write(geom);
        return "GeometryFromText('" + geoText + "', " + srid + ")";
    }

    public boolean isWKBEnabled() {
        return this.WKBEnabled;
    }

    public void setWKBEnabled(boolean enabled) {
        this.WKBEnabled = enabled;
    }

    protected String encodeName(String tableName) {
        return this.sqlBuilder.encodeTableName(tableName);
    }

    protected String encodeColumnName(String colName) {
        return this.sqlBuilder.encodeColumnName(colName);
    }

    protected String makeSelectForUpdateSql(Feature current) {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        FeatureType featureType = ftInfo.getSchema();
        String tableName = featureType.getTypeName();
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        FidFilter fid = ff.createFidFilter(current.getID());
        StringBuffer sql = new StringBuffer("SELECT ");
        this.sqlBuilder.sqlColumns(sql, this.mapper, new AttributeType[0]);
        this.sqlBuilder.sqlFrom(sql, tableName);
        try {
            this.sqlBuilder.sqlWhere(sql, fid);
        }
        catch (SQLEncoderException e) {
            e.printStackTrace();
        }
        sql.append(" FOR UPDATE");
        try {
            int major = this.queryData.getConnection().getMetaData().getDatabaseMajorVersion();
            int minor = this.queryData.getConnection().getMetaData().getDatabaseMinorVersion();
            if (major > 8 || major == 8 && minor >= 1) {
                sql.append(" NOWAIT");
            } else {
                LOGGER.warning("To fully support concurrent edits, please upgrade to postgres >= 8.1; the version currently in use will block");
            }
        }
        catch (SQLException e) {
            LOGGER.warning("Failed to determine postgres version; assuming < 8.1");
        }
        return sql.toString();
    }
}

