/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import org.geotools.data.jdbc.DefaultSQLBuilder;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLEncoderPostgis;

public class PostgisSQLBuilder
extends DefaultSQLBuilder {
    protected boolean WKBEnabled = false;
    protected boolean byteaEnabled = false;
    protected boolean schemaEnabled = true;
    protected JDBCDataStoreConfig config;

    public PostgisSQLBuilder(int srid, JDBCDataStoreConfig config) {
        this(new SQLEncoderPostgis(srid), config);
    }

    public PostgisSQLBuilder(SQLEncoder encoder, JDBCDataStoreConfig config) {
        super(encoder);
        this.config = config;
    }

    public PostgisSQLBuilder(SQLEncoder encoder, JDBCDataStoreConfig config, FeatureType ft) {
        super(encoder);
        this.config = config;
        this.ft = ft;
    }

    public void sqlColumns(StringBuffer sql, FIDMapper mapper, AttributeType[] attributes) {
        int i;
        for (i = 0; i < mapper.getColumnCount(); ++i) {
            sql.append("\"" + mapper.getColumnName(i) + "\"");
            if (attributes.length <= 0 && i >= mapper.getColumnCount() - 1) continue;
            sql.append(", ");
        }
        for (i = 0; i < attributes.length; ++i) {
            String colName = attributes[i].getName();
            if (attributes[i] instanceof GeometryAttributeType) {
                if (this.WKBEnabled) {
                    if (this.byteaEnabled) {
                        sql.append("encode(AsBinary(force_2d(\"" + colName + "\"), 'XDR'),'base64')");
                    } else {
                        sql.append("AsBinary(force_2d(\"" + colName + "\"), 'XDR')");
                    }
                } else {
                    sql.append("AsText(force_2d(\"" + colName + "\"))");
                }
            } else {
                sql.append("\"" + colName + "\"");
            }
            if (i >= attributes.length - 1) continue;
            sql.append(", ");
        }
    }

    public void sqlFrom(StringBuffer sql, String typeName) {
        sql.append(" FROM ");
        sql.append(this.encodeTableName(typeName));
    }

    public void sqlWhere(StringBuffer sql, Filter preFilter) throws SQLEncoderException {
        if (preFilter != null || preFilter == Filter.NONE) {
            String where = this.encoder.encode(preFilter);
            sql.append(" ");
            sql.append(where);
        }
    }

    public boolean isWKBEnabled() {
        return this.WKBEnabled;
    }

    public void setWKBEnabled(boolean enabled) {
        this.WKBEnabled = enabled;
    }

    public boolean isByteaEnabled() {
        return this.byteaEnabled;
    }

    public void setByteaEnabled(boolean byteaEnable) {
        this.byteaEnabled = byteaEnable;
    }

    public void setSchemaEnabled(boolean schemaEnabled) {
        this.schemaEnabled = schemaEnabled;
    }

    public boolean isSchemaEnabled() {
        return this.schemaEnabled;
    }

    public String encodeTableName(String tableName) {
        return this.schemaEnabled ? "\"" + this.config.getDatabaseSchemaName() + "\".\"" + tableName + "\"" : "\"" + tableName + "\"";
    }

    public String encodeColumnName(String columnName) {
        return "\"" + columnName + "\"";
    }
}

