/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.referencing;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.referencing.JDBCAuthorityFactory;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PostgisAuthorityFactory
extends JDBCAuthorityFactory {
    private String TABLE_NAME = "SPATIAL_REF_SYS";
    private String WKT_COLUMN = "SRTEXT";
    private String SRID_COLUMN = "SRID";
    private String AUTH_NAME = "AUTH_NAME";
    private String AUTH_SRID = "AUTH_SRID";

    public PostgisAuthorityFactory(ConnectionPool pool) {
        super(pool);
    }

    public CoordinateReferenceSystem createCRS(int srid) throws FactoryException, IOException {
        Connection dbConnection;
        block8: {
            dbConnection = null;
            String sqlStatement = "SELECT * FROM " + this.TABLE_NAME + " WHERE " + this.SRID_COLUMN + " = " + srid;
            dbConnection = this.connectionPool.getConnection();
            Statement statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement);
            if (!result.next()) break block8;
            CoordinateReferenceSystem crs = null;
            try {
                crs = this.createFromAuthority(result);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (crs == null) {
                crs = this.createFromWKT(result);
            }
            JDBCUtils.close((Statement)statement);
            CoordinateReferenceSystem coordinateReferenceSystem = crs;
            JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
            return coordinateReferenceSystem;
        }
        try {
            try {
                String mesg = "No row found for " + srid + " in table: " + this.TABLE_NAME;
                throw new FactoryException(mesg);
            }
            catch (SQLException sqle) {
                String message = sqle.getMessage();
                throw new DataSourceException(message, sqle);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
            throw throwable;
        }
    }

    protected CoordinateReferenceSystem createFromWKT(ResultSet result) throws DataSourceException, FactoryException {
        try {
            String wkt = result.getString(this.WKT_COLUMN);
            return this.factory.createFromWKT(wkt);
        }
        catch (SQLException sqle) {
            String message = sqle.getMessage();
            throw new DataSourceException(message, sqle);
        }
    }

    protected CoordinateReferenceSystem createFromAuthority(ResultSet result) throws DataSourceException, FactoryException {
        try {
            String name = result.getString(this.AUTH_NAME);
            int id = result.getInt(this.AUTH_SRID);
            return CRS.decode((String)(name + ":" + id));
        }
        catch (SQLException sqle) {
            String message = sqle.getMessage();
            throw new DataSourceException(message, sqle);
        }
    }
}

