/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.factory.FactoryGroup;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.util.InternationalString;

public class AUTOCRSAuthorityFactory
implements CRSAuthorityFactory {
    private final FactoryGroup factories;
    private static AUTOCRSAuthorityFactory DEFAULT;
    private final Map facts = new HashMap();

    public AUTOCRSAuthorityFactory() {
        this(FactoryFinder.getCRSFactory(null));
    }

    public AUTOCRSAuthorityFactory(CRSFactory factory) {
        this.factories = new FactoryGroup(null, null, factory, null);
        this.facts.put(new Integer(42001), new Auto42001());
        this.facts.put(new Integer(42002), new Auto42002());
        this.facts.put(new Integer(42003), new Auto42003());
        this.facts.put(new Integer(42004), new Auto42004());
    }

    public static synchronized CRSAuthorityFactory getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new AUTOCRSAuthorityFactory();
        }
        return DEFAULT;
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        Code c = new Code(code, "CoordinateReferenceSystem");
        return this.factFinder(c).create(c);
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.createCoordinateReferenceSystem(code);
    }

    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        return (ProjectedCRS)this.createCoordinateReferenceSystem(code);
    }

    public Citation getAuthority() {
        return Citations.AUTO;
    }

    public Set getAuthorityCodes(Class clazz) throws FactoryException {
        TreeSet<String> set = new TreeSet<String>();
        Iterator i = this.facts.keySet().iterator();
        while (i.hasNext()) {
            Integer code = (Integer)i.next();
            set.add("AUTO:" + code);
        }
        return set;
    }

    public ObjectFactory getObjectFactory() {
        return this.factories.getCRSFactory();
    }

    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    public InternationalString getDescriptionText(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    private Factlet factFinder(Code code) throws NoSuchAuthorityCodeException {
        Integer key = new Integer(code.code);
        Factlet fac = (Factlet)this.facts.get(key);
        if (fac == null) {
            throw new NoSuchAuthorityCodeException(code.toString(), "AUTO", code.classname);
        }
        return fac;
    }

    public CompoundCRS createCompoundCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public DerivedCRS createDerivedCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public EngineeringCRS createEngineeringCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public GeocentricCRS createGeocentricCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public GeographicCRS createGeographicCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public ImageCRS createImageCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public TemporalCRS createTemporalCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    public VerticalCRS createVerticalCRS(String str) throws FactoryException {
        throw new FactoryException("Not implemented");
    }

    private class Auto42004
    implements Factlet {
        private Auto42004() {
        }

        public boolean match(Code code) {
            return code.code == 42004;
        }

        public Unit unit() {
            return SI.METER;
        }

        public Ellipsoid ellipsoid() {
            return DefaultEllipsoid.WGS84;
        }

        public PrimeMeridian primeMeridian() {
            return DefaultPrimeMeridian.GREENWICH;
        }

        public Datum datum() {
            return DefaultGeodeticDatum.WGS84;
        }

        public CoordinateReferenceSystem create(Code code) throws FactoryException {
            DefaultGeographicCRS geoCRS = DefaultGeographicCRS.WGS84;
            DefaultCartesianCS cartCS = DefaultCartesianCS.PROJECTED;
            double centralMeridian = code.longitude;
            double standardParallel1 = code.latitude;
            String classification = "Equirectangular";
            ParameterValueGroup parameters = AUTOCRSAuthorityFactory.this.factories.getMathTransformFactory().getDefaultParameters("Equirectangular");
            parameters.parameter("central_meridian").setValue(centralMeridian);
            parameters.parameter("latitude_of_origin").setValue(0.0);
            parameters.parameter("standard_parallel_1").setValue(standardParallel1);
            parameters.parameter("scale_factor").setValue(1.0);
            parameters.parameter("false_easting").setValue(0.0);
            parameters.parameter("false_northing").setValue(0.0);
            return AUTOCRSAuthorityFactory.this.factories.createProjectedCRS(Collections.singletonMap("name", "WGS 84 / Auto Orthographic"), (GeographicCRS)geoCRS, null, parameters, (CartesianCS)cartCS);
        }
    }

    private class Auto42003
    implements Factlet {
        private Auto42003() {
        }

        public boolean match(Code code) {
            return code.code == 42003;
        }

        public Unit unit() {
            return SI.METER;
        }

        public Ellipsoid ellipsoid() {
            return DefaultEllipsoid.WGS84;
        }

        public PrimeMeridian primeMeridian() {
            return DefaultPrimeMeridian.GREENWICH;
        }

        public Datum datum() {
            return DefaultGeodeticDatum.WGS84;
        }

        public CoordinateReferenceSystem create(Code code) throws FactoryException {
            DefaultGeographicCRS geoCRS = DefaultGeographicCRS.WGS84;
            DefaultCartesianCS cartCS = DefaultCartesianCS.PROJECTED;
            double centralMeridian = code.longitude;
            double latitudeOfOrigin = code.latitude;
            String classification = "Orthographic";
            ParameterValueGroup parameters = AUTOCRSAuthorityFactory.this.factories.getMathTransformFactory().getDefaultParameters("Orthographic");
            parameters.parameter("central_meridian").setValue(centralMeridian);
            parameters.parameter("latitude_of_origin").setValue(latitudeOfOrigin);
            parameters.parameter("scale_factor").setValue(1.0);
            parameters.parameter("false_easting").setValue(0.0);
            parameters.parameter("false_northing").setValue(0.0);
            return AUTOCRSAuthorityFactory.this.factories.createProjectedCRS(Collections.singletonMap("name", "WGS 84 / Auto Orthographic"), (GeographicCRS)geoCRS, null, parameters, (CartesianCS)cartCS);
        }
    }

    private class Auto42002
    implements Factlet {
        private Auto42002() {
        }

        public boolean match(Code code) {
            return code.code == 42002;
        }

        public Unit unit() {
            return SI.METER;
        }

        public Ellipsoid ellipsoid() {
            return DefaultEllipsoid.WGS84;
        }

        public PrimeMeridian primeMeridian() {
            return DefaultPrimeMeridian.GREENWICH;
        }

        public Datum datum() {
            return DefaultGeodeticDatum.WGS84;
        }

        public CoordinateReferenceSystem create(Code code) throws FactoryException {
            DefaultGeographicCRS geoCRS = DefaultGeographicCRS.WGS84;
            DefaultCartesianCS cartCS = DefaultCartesianCS.PROJECTED;
            double centralMeridian = code.longitude;
            double falseNorthing = code.latitude >= 0.0 ? 0.0 : 1.0E7;
            String classification = "Transverse_Mercator";
            ParameterValueGroup parameters = AUTOCRSAuthorityFactory.this.factories.getMathTransformFactory().getDefaultParameters("Transverse_Mercator");
            parameters.parameter("central_meridian").setValue(centralMeridian);
            parameters.parameter("latitude_of_origin").setValue(0.0);
            parameters.parameter("scale_factor").setValue(0.9996);
            parameters.parameter("false_easting").setValue(500000.0);
            parameters.parameter("false_northing").setValue(falseNorthing);
            return AUTOCRSAuthorityFactory.this.factories.createProjectedCRS(Collections.singletonMap("name", "WGS 84 / Auto Tr. Mercator"), (GeographicCRS)geoCRS, null, parameters, (CartesianCS)cartCS);
        }
    }

    private class Auto42001
    implements Factlet {
        private Auto42001() {
        }

        public boolean match(Code code) {
            return code.code == 42001;
        }

        public Unit unit() {
            return SI.METER;
        }

        public Ellipsoid ellipsoid() {
            return DefaultEllipsoid.WGS84;
        }

        public PrimeMeridian primeMeridian() {
            return DefaultPrimeMeridian.GREENWICH;
        }

        public Datum datum() {
            return DefaultGeodeticDatum.WGS84;
        }

        public CoordinateReferenceSystem create(Code code) throws FactoryException {
            DefaultGeographicCRS geoCRS = DefaultGeographicCRS.WGS84;
            DefaultCartesianCS cartCS = DefaultCartesianCS.PROJECTED;
            double falseNorthing = code.latitude >= 0.0 ? 0.0 : 1.0E7;
            double zone = Math.min(Math.floor((code.longitude + 180.0) / 6.0) + 1.0, 60.0);
            double centralMeridian = -183.0 + zone * 6.0;
            String classification = "Transverse_Mercator";
            ParameterValueGroup parameters = AUTOCRSAuthorityFactory.this.factories.getMathTransformFactory().getDefaultParameters("Transverse_Mercator");
            parameters.parameter("central_meridian").setValue(centralMeridian);
            parameters.parameter("latitude_of_origin").setValue(0.0);
            parameters.parameter("scale_factor").setValue(0.9996);
            parameters.parameter("false_easting").setValue(500000.0);
            parameters.parameter("false_northing").setValue(falseNorthing);
            return AUTOCRSAuthorityFactory.this.factories.createProjectedCRS(Collections.singletonMap("name", "WGS 84 / Auto UTM"), (GeographicCRS)geoCRS, null, parameters, (CartesianCS)cartCS);
        }
    }

    private static interface Factlet {
        public boolean match(Code var1);

        public Unit unit();

        public Ellipsoid ellipsoid();

        public PrimeMeridian primeMeridian();

        public Datum datum();

        public CoordinateReferenceSystem create(Code var1) throws FactoryException;
    }

    private static class Code {
        public String authority;
        public int code;
        public double longitude = Double.NaN;
        public double latitude = Double.NaN;
        public final String classname;

        public Code(String text, String classname) throws NoSuchAuthorityCodeException {
            this.classname = classname;
            int startField = -1;
            int i = 0;
            while (true) {
                int endField;
                block11: {
                    if ((endField = text.indexOf(44, ++startField)) < 0) {
                        endField = text.length();
                    }
                    if (endField <= startField) {
                        throw new NoSuchAuthorityCodeException(classname, "AUTO", text);
                    }
                    String field = text.substring(startField, endField).trim();
                    try {
                        switch (i) {
                            case 0: {
                                int split = field.indexOf(58);
                                this.authority = field.substring(0, split);
                                this.code = Integer.parseInt(field.substring(split + 1));
                                break block11;
                            }
                            case 1: {
                                this.longitude = Double.parseDouble(field);
                                break block11;
                            }
                            case 2: {
                                this.latitude = Double.parseDouble(field);
                                break;
                            }
                        }
                        break;
                    }
                    catch (NumberFormatException exception) {
                        NoSuchAuthorityCodeException e = new NoSuchAuthorityCodeException(classname, "AUTO", text);
                        e.initCause((Throwable)exception);
                        throw e;
                    }
                }
                startField = endField;
                ++i;
            }
            if (!(this.longitude >= -180.0 && this.longitude <= 180.0 && this.latitude >= -90.0 && this.latitude <= 90.0)) {
                throw new NoSuchAuthorityCodeException(classname, "AUTO", text);
            }
        }

        public String toString() {
            return "AUTO:" + this.code + "," + this.longitude + "," + this.latitude;
        }
    }
}

