/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.build.line;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.graph.build.line.OptDirectedLineGraphBuilder;
import org.geotools.graph.build.line.OptLineGraphGenerator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.line.OptDirectedXYNode;
import org.geotools.graph.structure.opt.OptDirectedNode;

public class OptDirectedLineGraphGenerator
extends OptLineGraphGenerator {
    HashMap m_in2count = new HashMap();
    HashMap m_out2count = new HashMap();

    public OptDirectedLineGraphGenerator() {
        this.setGraphBuilder(new OptDirectedLineGraphBuilder());
    }

    public Graphable add(Object obj) {
        LineSegment line = (LineSegment)obj;
        Integer count = (Integer)this.m_in2count.get(line.p0);
        if (count == null) {
            this.m_in2count.put(line.p0, new Integer(1));
        } else {
            this.m_in2count.put(line.p0, new Integer(count + 1));
        }
        count = (Integer)this.m_out2count.get(line.p1);
        if (count == null) {
            this.m_out2count.put(line.p1, new Integer(1));
        } else {
            this.m_out2count.put(line.p1, new Integer(count + 1));
        }
        this.getLines().add(line);
        return null;
    }

    public Map getInNodeMap() {
        return this.m_in2count;
    }

    public Map getOutNodeMap() {
        return this.m_out2count;
    }

    protected void generateNodes() {
        OptDirectedXYNode node;
        Integer count;
        Coordinate coord;
        Map.Entry entry;
        Iterator itr = this.m_in2count.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            coord = (Coordinate)entry.getKey();
            count = (Integer)entry.getValue();
            node = (OptDirectedXYNode)this.getGraphBuilder().buildNode();
            node.setCoordinate(coord);
            node.setOutDegree(count);
            count = (Integer)this.m_out2count.get(coord);
            if (count != null) {
                node.setInDegree(count);
            } else {
                node.setInDegree(0);
            }
            this.getGraphBuilder().addNode(node);
            entry.setValue(node);
        }
        itr = this.m_out2count.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            coord = (Coordinate)entry.getKey();
            count = (Integer)entry.getValue();
            node = (OptDirectedXYNode)this.m_in2count.get(coord);
            if (node == null) {
                node = (OptDirectedXYNode)this.getGraphBuilder().buildNode();
                node.setCoordinate(coord);
                node.setOutDegree(0);
                node.setInDegree(count);
                this.getGraphBuilder().addNode(node);
            }
            entry.setValue(node);
        }
    }

    protected Edge generateEdge(LineSegment line) {
        OptDirectedNode n1 = (OptDirectedNode)this.m_in2count.get(line.p0);
        OptDirectedNode n2 = (OptDirectedNode)this.m_out2count.get(line.p1);
        Edge edge = this.getGraphBuilder().buildEdge(n1, n2);
        this.getGraphBuilder().addEdge(edge);
        return edge;
    }

    public Node getNode(Coordinate c) {
        Node n = (Node)this.m_in2count.get(c);
        if (n != null) {
            return n;
        }
        return (Node)this.m_out2count.get(c);
    }

    public Edge getEdge(Coordinate c1, Coordinate c2) {
        return null;
    }
}

