/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.path;

import org.geotools.graph.path.Path;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.GraphWalker;
import org.geotools.graph.traverse.basic.BasicGraphTraversal;
import org.geotools.graph.traverse.standard.DijkstraIterator;

public class DijkstraShortestPathFinder
implements GraphWalker {
    private Graph m_graph;
    private GraphTraversal m_traversal;
    private DijkstraIterator m_iterator;

    public DijkstraShortestPathFinder(Graph graph, DijkstraIterator iterator) {
        this.m_graph = graph;
        this.m_iterator = iterator;
        this.m_traversal = new BasicGraphTraversal(graph, this, iterator);
    }

    public DijkstraShortestPathFinder(Graph graph, Graphable source, DijkstraIterator.EdgeWeighter weighter) {
        this.m_graph = graph;
        this.m_iterator = new DijkstraIterator(weighter);
        this.m_iterator.setSource(source);
        this.m_traversal = new BasicGraphTraversal(graph, this, this.m_iterator);
    }

    public void calculate() {
        this.m_traversal.init();
        this.m_traversal.traverse();
    }

    public Path getPath(Graphable g) {
        Path p = new Path();
        p.add(g);
        Graphable parent = g;
        while ((parent = this.m_iterator.getParent(parent)) != null) {
            p.add(parent);
        }
        if (!p.getLast().equals(this.m_iterator.getSource())) {
            return null;
        }
        return p;
    }

    public double getCost(Graphable g) {
        return this.m_iterator.getCost(g);
    }

    public DijkstraIterator getIterator() {
        return this.m_iterator;
    }

    public GraphTraversal getTraversal() {
        return this.m_traversal;
    }

    public int visit(Graphable element, GraphTraversal traversal) {
        return 0;
    }

    public void finish() {
    }
}

