/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.basic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.geotools.graph.structure.DirectedEdge;
import org.geotools.graph.structure.DirectedNode;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraphable;

public class BasicDirectedEdge
extends BasicGraphable
implements DirectedEdge {
    private DirectedNode m_in;
    private DirectedNode m_out;

    public BasicDirectedEdge(DirectedNode in, DirectedNode out) {
        this.m_in = in;
        this.m_out = out;
    }

    public DirectedNode getInNode() {
        return this.m_in;
    }

    public DirectedNode getOutNode() {
        return this.m_out;
    }

    public Node getNodeA() {
        return this.m_in;
    }

    public Node getNodeB() {
        return this.m_out;
    }

    public Node getOtherNode(Node node) {
        return this.m_in.equals(node) ? this.m_out : (this.m_out.equals(node) ? this.m_in : null);
    }

    public void reverse() {
        this.m_in.removeOut(this);
        this.m_out.removeIn(this);
        DirectedNode tmp = this.m_in;
        this.m_in = this.m_out;
        this.m_out = tmp;
        this.m_in.addOut(this);
        this.m_out.addIn(this);
    }

    public Iterator getRelated() {
        HashSet related = new HashSet();
        related.addAll(this.m_in.getEdges());
        related.addAll(this.m_out.getEdges());
        related.remove(this);
        return related.iterator();
    }

    public Iterator getInRelated() {
        ArrayList<DirectedEdge> in = new ArrayList<DirectedEdge>();
        Iterator itr = this.m_in.getInEdges().iterator();
        while (itr.hasNext()) {
            DirectedEdge de = (DirectedEdge)itr.next();
            if (de.equals(this)) continue;
            in.add(de);
        }
        return in.iterator();
    }

    public Iterator getOutRelated() {
        ArrayList<DirectedEdge> out = new ArrayList<DirectedEdge>();
        Iterator itr = this.m_out.getOutEdges().iterator();
        while (itr.hasNext()) {
            DirectedEdge de = (DirectedEdge)itr.next();
            if (de.equals(this)) continue;
            out.add(de);
        }
        return out.iterator();
    }

    public int compareNodes(Edge other) {
        if (other instanceof DirectedEdge) {
            DirectedEdge de = (DirectedEdge)other;
            if (de.getInNode().equals(this.m_in) && de.getOutNode().equals(this.m_out)) {
                return 0;
            }
            if (de.getInNode().equals(this.m_out) && de.getOutNode().equals(this.m_in)) {
                return -1;
            }
        }
        return 1;
    }
}

