/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.basic;

import java.util.ArrayList;
import java.util.Iterator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraphable;

public class BasicEdge
extends BasicGraphable
implements Edge {
    private Node m_nodeA;
    private Node m_nodeB;

    public BasicEdge(Node nodeA, Node nodeB) {
        this.m_nodeA = nodeA;
        this.m_nodeB = nodeB;
    }

    public Node getNodeA() {
        return this.m_nodeA;
    }

    public Node getNodeB() {
        return this.m_nodeB;
    }

    public Node getOtherNode(Node node) {
        if (node.equals(this.m_nodeA)) {
            return this.m_nodeB;
        }
        if (node.equals(this.m_nodeB)) {
            return this.m_nodeA;
        }
        return null;
    }

    public Iterator getRelated() {
        Edge e;
        ArrayList<Edge> adj = new ArrayList<Edge>();
        Iterator itr = this.m_nodeA.getEdges().iterator();
        while (itr.hasNext()) {
            e = (Edge)itr.next();
            switch (e.compareNodes(this)) {
                case 0: {
                    if (e.equals(this)) break;
                }
                case -1: 
                case 1: {
                    adj.add(e);
                }
            }
        }
        itr = this.m_nodeB.getEdges().iterator();
        while (itr.hasNext()) {
            e = (Edge)itr.next();
            switch (e.compareNodes(this)) {
                case -1: 
                case 0: {
                    break;
                }
                case 1: {
                    adj.add(e);
                }
            }
        }
        return adj.iterator();
    }

    public void reverse() {
        Node n = this.m_nodeA;
        this.m_nodeA = this.m_nodeB;
        this.m_nodeB = n;
    }

    public int compareNodes(Edge other) {
        if (this.m_nodeA.equals(other.getNodeA()) && this.m_nodeB.equals(other.getNodeB())) {
            return 0;
        }
        if (this.m_nodeA.equals(other.getNodeA()) && this.m_nodeB.equals(other.getNodeB()) || this.m_nodeA.equals(other.getNodeB()) && this.m_nodeB.equals(other.getNodeA())) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return super.toString() + " (" + this.m_nodeA.getID() + "," + this.m_nodeB.getID() + ")";
    }
}

