/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.traverse.standard;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.GraphVisitor;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.basic.SourceGraphIterator;
import org.geotools.graph.util.PriorityQueue;

public class DijkstraIterator
extends SourceGraphIterator {
    private static Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            DijkstraNode n1 = (DijkstraNode)o1;
            DijkstraNode n2 = (DijkstraNode)o2;
            return n1.cost < n2.cost ? -1 : (n1.cost > n2.cost ? 1 : 0);
        }
    };
    private EdgeWeighter m_weighter;
    private PriorityQueue m_queue;
    private HashMap m_nodemap;

    public DijkstraIterator(EdgeWeighter weighter) {
        this.m_weighter = weighter;
    }

    public void init(Graph graph, GraphTraversal traversal) {
        this.m_nodemap = new HashMap();
        this.m_queue = new PriorityQueue(comparator);
        this.m_queue.init(graph.getNodes().size());
        graph.visitNodes(new GraphVisitor(){

            public int visit(Graphable component) {
                DijkstraNode dn = new DijkstraNode((Node)component, Double.MAX_VALUE);
                DijkstraIterator.this.m_nodemap.put(component, dn);
                if (component == DijkstraIterator.this.getSource()) {
                    dn.cost = 0.0;
                }
                DijkstraIterator.this.m_queue.insert(dn);
                return 0;
            }
        });
    }

    public Graphable next(GraphTraversal traversal) {
        if (this.m_queue.isEmpty()) {
            return null;
        }
        DijkstraNode next = (DijkstraNode)this.m_queue.extract();
        if (next.cost == Double.MAX_VALUE) {
            return null;
        }
        return next.node;
    }

    public void cont(Graphable current, GraphTraversal traversal) {
        DijkstraNode currdn = (DijkstraNode)this.m_nodemap.get(current);
        Iterator itr = this.getRelated(current);
        while (itr.hasNext()) {
            Node related = (Node)itr.next();
            if (traversal.isVisited(related)) continue;
            DijkstraNode reldn = (DijkstraNode)this.m_nodemap.get(related);
            double cost = this.m_weighter.getWeight(currdn.node.getEdge(related)) + currdn.cost;
            if (!(cost < reldn.cost)) continue;
            reldn.cost = cost;
            reldn.parent = currdn;
            this.m_queue.update(reldn);
        }
    }

    public void killBranch(Graphable current, GraphTraversal traversal) {
    }

    public double getCost(Graphable component) {
        return ((DijkstraNode)this.m_nodemap.get((Object)component)).cost;
    }

    public Graphable getParent(Graphable component) {
        if (component.equals(this.getSource())) {
            return null;
        }
        DijkstraNode dn = (DijkstraNode)this.m_nodemap.get(component);
        if (dn == null || dn.parent == null) {
            return null;
        }
        return dn.parent.node;
    }

    protected PriorityQueue getQueue() {
        return this.m_queue;
    }

    protected Iterator getRelated(Graphable current) {
        return current.getRelated();
    }

    protected static class DijkstraNode {
        public Node node;
        public double cost;
        public DijkstraNode parent;

        public DijkstraNode(Node node, double cost) {
            this.node = node;
            this.cost = cost;
        }
    }

    public static interface EdgeWeighter {
        public double getWeight(Edge var1);
    }
}

