/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import java.awt.Dimension;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraph;
import org.geotools.graph.util.delaunay.AutoClustData;
import org.geotools.graph.util.delaunay.AutoClustUtils;
import org.geotools.graph.util.delaunay.DelaunayEdge;
import org.geotools.graph.util.delaunay.DelaunayNode;
import org.geotools.graph.util.delaunay.GraphViewer;

public class AutoClust {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.graph");

    public static Graph runAutoClust(Graph d) {
        Node other;
        AutoClustData acd;
        HashMap<DelaunayNode, AutoClustData> map = new HashMap<DelaunayNode, AutoClustData>();
        Collection nodes = d.getNodes();
        Collection edges = d.getEdges();
        Iterator nodeIt = nodes.iterator();
        double[] localDevs = new double[nodes.size()];
        int index = 0;
        while (nodeIt.hasNext()) {
            double stDev;
            DelaunayNode next = (DelaunayNode)nodeIt.next();
            AutoClustData acd2 = new AutoClustData();
            Vector localEdges = AutoClustUtils.findAdjacentEdges(next, edges);
            double totalLength = 0.0;
            Iterator edgeIt = localEdges.iterator();
            while (edgeIt.hasNext()) {
                DelaunayEdge nextEdge = (DelaunayEdge)edgeIt.next();
                totalLength += nextEdge.getEuclideanDistance();
            }
            double meanLength = totalLength / (double)localEdges.size();
            double sumOfSquaredDiffs = 0.0;
            Iterator anotherEdgeIt = localEdges.iterator();
            while (anotherEdgeIt.hasNext()) {
                DelaunayEdge nextEdge = (DelaunayEdge)anotherEdgeIt.next();
                sumOfSquaredDiffs += Math.pow(nextEdge.getEuclideanDistance() - meanLength, 2.0);
            }
            double variance = sumOfSquaredDiffs / (double)localEdges.size();
            localDevs[index] = stDev = Math.sqrt(variance);
            ++index;
            acd2.setLocalMean(meanLength);
            acd2.setLocalStDev(stDev);
            map.put(next, acd2);
        }
        double total = 0.0;
        for (int i = 0; i < localDevs.length; ++i) {
            total += localDevs[i];
        }
        double meanStDev = total / (double)localDevs.length;
        Iterator anotherNodeIt = nodes.iterator();
        while (anotherNodeIt.hasNext()) {
            DelaunayNode next = (DelaunayNode)anotherNodeIt.next();
            Vector localEdges = AutoClustUtils.findAdjacentEdges(next, edges);
            acd = (AutoClustData)map.get(next);
            Iterator edgeIt = localEdges.iterator();
            Vector<DelaunayEdge> shortEdges = new Vector<DelaunayEdge>();
            Vector<DelaunayEdge> longEdges = new Vector<DelaunayEdge>();
            Vector<DelaunayEdge> otherEdges = new Vector<DelaunayEdge>();
            LOGGER.fine("local mean is " + acd.getLocalMean());
            LOGGER.fine("mean st dev is " + meanStDev);
            while (edgeIt.hasNext()) {
                DelaunayEdge nextEdge = (DelaunayEdge)edgeIt.next();
                double length = nextEdge.getEuclideanDistance();
                if (length < acd.getLocalMean() - meanStDev) {
                    shortEdges.add(nextEdge);
                    LOGGER.finer(nextEdge + ": length " + nextEdge.getEuclideanDistance() + " is short");
                    continue;
                }
                if (length > acd.getLocalMean() + meanStDev) {
                    longEdges.add(nextEdge);
                    LOGGER.finer(nextEdge + ": length " + nextEdge.getEuclideanDistance() + " is long");
                    continue;
                }
                otherEdges.add(nextEdge);
                LOGGER.finer(nextEdge + ": length " + nextEdge.getEuclideanDistance() + " is medium");
            }
            acd.setShortEdges(shortEdges);
            acd.setLongEdges(longEdges);
            acd.setOtherEdges(otherEdges);
        }
        Iterator nodeIt3 = nodes.iterator();
        while (nodeIt3.hasNext()) {
            DelaunayNode next = (DelaunayNode)nodeIt3.next();
            acd = (AutoClustData)map.get(next);
            List shortEdges = acd.getShortEdges();
            List longEdges = acd.getLongEdges();
            edges.removeAll(shortEdges);
            LOGGER.finer("removed " + shortEdges);
            edges.removeAll(longEdges);
            LOGGER.finer("removed " + longEdges);
        }
        LOGGER.fine("End of phase one and ");
        LOGGER.fine("Nodes are " + nodes);
        LOGGER.fine("Edges are " + edges);
        Vector connectedComponents = AutoClustUtils.findConnectedComponents(nodes, edges);
        Iterator nodeIt4 = nodes.iterator();
        while (nodeIt4.hasNext()) {
            Graph gr;
            DelaunayNode next = (DelaunayNode)nodeIt4.next();
            AutoClustData acd3 = (AutoClustData)map.get(next);
            List shortEdges = acd3.getShortEdges();
            if (!shortEdges.isEmpty()) {
                Vector<Graph> shortlyConnectedComponents = new Vector<Graph>();
                Iterator shortIt = shortEdges.iterator();
                while (shortIt.hasNext()) {
                    Edge nextEdge = (Edge)shortIt.next();
                    other = nextEdge.getOtherNode(next);
                    Graph g = AutoClust.getMyComponent(other, connectedComponents);
                    if (shortlyConnectedComponents.contains(g)) continue;
                    shortlyConnectedComponents.add(g);
                }
                Graph cv = null;
                if (shortlyConnectedComponents.size() > 1) {
                    Iterator sccIt = shortlyConnectedComponents.iterator();
                    int maxSize = 0;
                    while (sccIt.hasNext()) {
                        Graph nextGraph = (Graph)sccIt.next();
                        int size = nextGraph.getNodes().size();
                        if (size <= maxSize) continue;
                        maxSize = size;
                        cv = nextGraph;
                    }
                } else {
                    cv = (Graph)shortlyConnectedComponents.get(0);
                }
                Iterator shortIt2 = shortEdges.iterator();
                while (shortIt2.hasNext()) {
                    Edge nextEdge = (Edge)shortIt2.next();
                    Node other2 = nextEdge.getOtherNode(next);
                    if (!cv.equals(AutoClust.getMyComponent(other2, shortlyConnectedComponents))) continue;
                    edges.add(nextEdge);
                }
            }
            if ((gr = AutoClust.getMyComponent(next, connectedComponents)).getNodes().size() != 1) continue;
            Vector<Graph> shortlyConnectedComponents = new Vector<Graph>();
            Iterator shortIt = shortEdges.iterator();
            while (shortIt.hasNext()) {
                Edge nextEdge = (Edge)shortIt.next();
                Node other3 = nextEdge.getOtherNode(next);
                Graph g = AutoClust.getMyComponent(other3, connectedComponents);
                if (shortlyConnectedComponents.contains(g)) continue;
                shortlyConnectedComponents.add(g);
            }
            if (shortlyConnectedComponents.size() != 1) continue;
            edges.addAll(shortEdges);
        }
        LOGGER.fine("End of phase two and ");
        LOGGER.fine("Nodes are " + nodes);
        LOGGER.fine("Edges are " + edges);
        connectedComponents = AutoClustUtils.findConnectedComponents(nodes, edges);
        Iterator nodeIt5 = nodes.iterator();
        while (nodeIt5.hasNext()) {
            DelaunayNode next = (DelaunayNode)nodeIt5.next();
            Vector<Edge> edgesWithinTwo = new Vector<Edge>();
            Vector adjacentEdges = AutoClustUtils.findAdjacentEdges(next, edges);
            edgesWithinTwo.addAll(adjacentEdges);
            Iterator adjacentIt = adjacentEdges.iterator();
            while (adjacentIt.hasNext()) {
                Edge nextEdge = (Edge)adjacentIt.next();
                other = nextEdge.getOtherNode(next);
                Vector adjacentToOther = AutoClustUtils.findAdjacentEdges(other, edges);
                Iterator atoIt = adjacentToOther.iterator();
                while (atoIt.hasNext()) {
                    Edge nextEdge2 = (Edge)atoIt.next();
                    if (edgesWithinTwo.contains(nextEdge2)) continue;
                    edgesWithinTwo.add(nextEdge2);
                }
            }
            double totalLength = 0.0;
            Iterator ewtIt = edgesWithinTwo.iterator();
            while (ewtIt.hasNext()) {
                totalLength += ((DelaunayEdge)ewtIt.next()).getEuclideanDistance();
            }
            double local2Mean = totalLength / (double)edgesWithinTwo.size();
            Iterator ewtIt2 = edgesWithinTwo.iterator();
            while (ewtIt2.hasNext()) {
                DelaunayEdge dEdge = (DelaunayEdge)ewtIt2.next();
                if (!(dEdge.getEuclideanDistance() > local2Mean + meanStDev)) continue;
                edges.remove(dEdge);
            }
        }
        LOGGER.fine("End of phase three and ");
        LOGGER.fine("Nodes are " + nodes);
        LOGGER.fine("Edges are " + edges);
        connectedComponents = AutoClustUtils.findConnectedComponents(nodes, edges);
        return new BasicGraph(nodes, edges);
    }

    private static Graph getMyComponent(Node node, Vector components) {
        Iterator it = components.iterator();
        Graph ret = null;
        boolean found = false;
        while (it.hasNext() && !found) {
            Graph next = (Graph)it.next();
            if (!next.getNodes().contains(node)) continue;
            found = true;
            ret = next;
        }
        if (ret == null) {
            throw new RuntimeException("Couldn't find the graph component containing node: " + node);
        }
        return ret;
    }

    private static void showGraph(Collection nodes, Collection edges, int phase) {
        BasicGraph g = new BasicGraph(nodes, edges);
        JFrame frame = new JFrame();
        GraphViewer viewer = new GraphViewer();
        viewer.setGraph(g);
        frame.getContentPane().add(viewer);
        frame.setDefaultCloseOperation(3);
        frame.setSize(new Dimension(800, 800));
        frame.setTitle("Phase " + phase);
        frame.setVisible(true);
    }
}

